/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.LineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiLineString;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.MultiPolygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Polygon;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Ring;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.core.canvas.FontStyle;
import org.jetbrains.letsPlot.core.canvas.FontWeight;
import org.jetbrains.letsPlot.core.canvas.LineCap;
import org.jetbrains.letsPlot.core.canvas.LineJoin;
import org.jetbrains.letsPlot.core.canvas.TextAlign;
import org.jetbrains.letsPlot.core.canvas.TextBaseline;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.Style;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.core.util.Geometries;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.Symbolizer;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.SymbolizerKt;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileFeature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b`\u0018\u0000 \u000e2\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J$\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&J\u001e\u0010\u000b\u001a\u00020\u0003*\u00020\u00052\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer;", "", "applyTo", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "createDrawTasks", "", "Lkotlin/Function0;", "feature", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "drawLine", "line", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Companion", "LineSymbolizer", "LineTextSymbolizer", "PointTextSymbolizer", "PolygonSymbolizer", "ShieldTextSymbolizer", "livemap"})
public interface Symbolizer {
    @NotNull
    public static final Companion Companion = org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.Symbolizer$Companion.$$INSTANCE;

    @NotNull
    public List<Function0<Unit>> createDrawTasks(@NotNull Context2d var1, @NotNull TileFeature var2);

    public void applyTo(@NotNull Context2d var1);

    public void drawLine(@NotNull Context2d var1, @NotNull List<? extends Vec<?>> var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$Companion;", "", "()V", "BEVEL", "", "BUTT", "LABEL", "LINE", "LINE_TEXT", "MITER", "POINT_TEXT", "POLYGON", "ROUND", "SHIELD_TEXT", "SHORT", "SQUARE", "create", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer;", "style", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "labelBounds", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "setBaseStyle", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "splitLabel", "label", "stringToLineCap", "Lorg/jetbrains/letsPlot/core/canvas/LineCap;", "cap", "stringToLineJoin", "Lorg/jetbrains/letsPlot/core/canvas/LineJoin;", "join", "livemap"})
    @SourceDebugExtension(value={"SMAP\nSymbolizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Symbolizer.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1#2:327\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String BUTT = "butt";
        @NotNull
        private static final String ROUND = "round";
        @NotNull
        private static final String SQUARE = "square";
        @NotNull
        private static final String MITER = "miter";
        @NotNull
        private static final String BEVEL = "bevel";
        @NotNull
        private static final String LINE = "line";
        @NotNull
        private static final String POLYGON = "polygon";
        @NotNull
        private static final String POINT_TEXT = "point-text";
        @NotNull
        private static final String SHIELD_TEXT = "shield-text";
        @NotNull
        private static final String LINE_TEXT = "line-text";
        @NotNull
        private static final String SHORT = "short";
        @NotNull
        private static final String LABEL = "label";

        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final Symbolizer create(@NotNull Style style, @NotNull List<DoubleRectangle> labelBounds) {
            Symbolizer symbolizer;
            block14: {
                block11: {
                    block12: {
                        block13: {
                            String string;
                            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                            Intrinsics.checkNotNullParameter(labelBounds, (String)"labelBounds");
                            String string2 = string = style.getType();
                            if (string2 == null) throw new IllegalStateException("Empty symbolizer type.".toString());
                            switch (string2.hashCode()) {
                                case -353337071: {
                                    if (!string.equals(SHIELD_TEXT)) {
                                        throw new IllegalStateException("Unknown symbolizer type.".toString());
                                    }
                                    break block11;
                                }
                                case 1220086602: {
                                    if (!string.equals(POINT_TEXT)) {
                                        throw new IllegalStateException("Unknown symbolizer type.".toString());
                                    }
                                    break block12;
                                }
                                case -397519558: {
                                    if (!string.equals(POLYGON)) {
                                        throw new IllegalStateException("Unknown symbolizer type.".toString());
                                    }
                                    break block13;
                                }
                                case 3321844: {
                                    if (string.equals(LINE)) break;
                                    throw new IllegalStateException("Unknown symbolizer type.".toString());
                                }
                                case -1842245786: {
                                    if (!string.equals(LINE_TEXT)) {
                                        throw new IllegalStateException("Unknown symbolizer type.".toString());
                                    }
                                    break block14;
                                }
                            }
                            symbolizer = new LineSymbolizer(style);
                            return symbolizer;
                        }
                        symbolizer = new PolygonSymbolizer(style);
                        return symbolizer;
                    }
                    symbolizer = new PointTextSymbolizer(style, labelBounds);
                    return symbolizer;
                }
                symbolizer = new ShieldTextSymbolizer(style, labelBounds);
                return symbolizer;
            }
            symbolizer = new LineTextSymbolizer(style, labelBounds);
            return symbolizer;
            throw new IllegalStateException("Unknown symbolizer type.".toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final LineCap stringToLineCap(@NotNull String cap) {
            LineCap lineCap;
            block6: {
                Intrinsics.checkNotNullParameter((Object)cap, (String)"cap");
                String string = cap;
                switch (string.hashCode()) {
                    case -894674659: {
                        if (!string.equals(SQUARE)) {
                            throw new IllegalStateException(("Unknown lineCap type: " + cap).toString());
                        }
                        break block6;
                    }
                    case 108704142: {
                        if (string.equals(ROUND)) break;
                        throw new IllegalStateException(("Unknown lineCap type: " + cap).toString());
                    }
                    case 3035667: {
                        if (!string.equals(BUTT)) throw new IllegalStateException(("Unknown lineCap type: " + cap).toString());
                        lineCap = LineCap.BUTT;
                        return lineCap;
                    }
                }
                lineCap = LineCap.ROUND;
                return lineCap;
            }
            lineCap = LineCap.SQUARE;
            return lineCap;
            throw new IllegalStateException(("Unknown lineCap type: " + cap).toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final LineJoin stringToLineJoin(@NotNull String join) {
            LineJoin lineJoin;
            block6: {
                Intrinsics.checkNotNullParameter((Object)join, (String)"join");
                String string = join;
                switch (string.hashCode()) {
                    case 108704142: {
                        if (string.equals(ROUND)) break;
                        throw new IllegalStateException(("Unknown lineJoin type: " + join).toString());
                    }
                    case 103906565: {
                        if (!string.equals(MITER)) {
                            throw new IllegalStateException(("Unknown lineJoin type: " + join).toString());
                        }
                        break block6;
                    }
                    case 93630586: {
                        if (!string.equals(BEVEL)) throw new IllegalStateException(("Unknown lineJoin type: " + join).toString());
                        lineJoin = LineJoin.BEVEL;
                        return lineJoin;
                    }
                }
                lineJoin = LineJoin.ROUND;
                return lineJoin;
            }
            lineJoin = LineJoin.MITER;
            return lineJoin;
            throw new IllegalStateException(("Unknown lineJoin type: " + join).toString());
        }

        @NotNull
        public final List<String> splitLabel(@NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)LABEL);
            ArrayList<String> splitted = new ArrayList<String>();
            String characters = "-',.)!?";
            int lastIndex = 0;
            int n = label.length();
            for (int i = 0; i < n; ++i) {
                if (' ' == label.charAt(i)) {
                    if (lastIndex != i) {
                        String string = label.substring(lastIndex, i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        splitted.add(string);
                    }
                    lastIndex = i + 1;
                    continue;
                }
                if (StringsKt.indexOf$default((CharSequence)characters, (char)label.charAt(i), (int)0, (boolean)false, (int)6, null) == -1) continue;
                String string = label.substring(lastIndex, i + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                splitted.add(string);
                lastIndex = i + 1;
            }
            if (lastIndex != label.length()) {
                String string = label.substring(lastIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                splitted.add(string);
            }
            return splitted;
        }

        public final void setBaseStyle(@NotNull Context2d ctx, @NotNull Style style) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Double d = style.getStrokeWidth();
                if (d != null) {
                    double p0 = ((Number)d).doubleValue();
                    boolean bl = false;
                    ctx.setLineWidth(p0);
                }
                Color color = style.getFill();
                if (color != null) {
                    Color p0 = color;
                    boolean bl = false;
                    ctx.setFillStyle(p0);
                }
                Color color2 = style.getStroke();
                if (color2 == null) break block2;
                Color p0 = color2;
                boolean bl = false;
                ctx.setStrokeStyle(p0);
            }
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void drawLine(@NotNull Symbolizer $this, @NotNull Context2d $receiver, @NotNull List<? extends Vec<?>> line) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter(line, (String)"line");
            $receiver.moveTo(Math.rint(line.get(0).getX()), Math.rint(line.get(0).getY()));
            int n = line.size();
            for (int i = 1; i < n; ++i) {
                Vec<?> point = line.get(i);
                $receiver.lineTo(Math.rint(point.getX()), Math.rint(point.getY()));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u0006*\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$LineSymbolizer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer;", "myStyle", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "(Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;)V", "applyTo", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "createDrawTasks", "", "Lkotlin/Function0;", "feature", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "drawMultiLine", "multiLine", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiLineString;", "Lorg/jetbrains/letsPlot/livemap/Client;", "livemap"})
    @SourceDebugExtension(value={"SMAP\nSymbolizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Symbolizer.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$LineSymbolizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1855#2,2:327\n1#3:329\n*S KotlinDebug\n*F\n+ 1 Symbolizer.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$LineSymbolizer\n*L\n63#1:327,2\n*E\n"})
    public static final class LineSymbolizer
    implements Symbolizer {
        @NotNull
        private final Style myStyle;

        public LineSymbolizer(@NotNull Style myStyle) {
            Intrinsics.checkNotNullParameter((Object)myStyle, (String)"myStyle");
            this.myStyle = myStyle;
        }

        private final void drawMultiLine(Context2d $this$drawMultiLine, MultiLineString<Client> multiLine) {
            $this$drawMultiLine.beginPath();
            Iterable $this$forEach$iv = (Iterable)multiLine;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LineString it = (LineString)element$iv;
                boolean bl = false;
                this.drawLine($this$drawMultiLine, (List)it);
            }
        }

        @Override
        @NotNull
        public List<Function0<Unit>> createDrawTasks(@NotNull Context2d ctx, @NotNull TileFeature feature) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            ArrayList<Function0<Unit>> tasks = new ArrayList<Function0<Unit>>();
            MultiLineString it = feature.getTileGeometry().getMultiLineString();
            boolean bl = false;
            tasks.add(new Function0<Unit>(this, ctx, (MultiLineString<Client>)it){
                final /* synthetic */ LineSymbolizer this$0;
                final /* synthetic */ Context2d $ctx;
                final /* synthetic */ MultiLineString<Client> $it;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    LineSymbolizer.access$drawMultiLine(this.this$0, this.$ctx, this.$it);
                }
            });
            tasks.add(new Function0<Unit>((Object)ctx){

                public final void invoke() {
                    ((Context2d)this.receiver).stroke();
                }
            });
            return tasks;
        }

        @Override
        public void applyTo(@NotNull Context2d ctx) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Color color = this.myStyle.getStroke();
                if (color != null) {
                    Color p0 = color;
                    boolean bl = false;
                    ctx.setStrokeStyle(p0);
                }
                Double d = this.myStyle.getStrokeWidth();
                if (d != null) {
                    double p0 = ((Number)d).doubleValue();
                    boolean bl = false;
                    ctx.setLineWidth(p0);
                }
                String string = this.myStyle.getLineCap();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    ctx.setLineCap(Companion.stringToLineCap(it));
                }
                String string2 = this.myStyle.getLineJoin();
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    ctx.setLineJoin(Companion.stringToLineJoin(it));
                }
                List list = this.myStyle.getLineDash();
                if (list != null) {
                    List it = list;
                    boolean bl = false;
                    ctx.setLineDash(CollectionsKt.toDoubleArray((Collection)it));
                }
                Double d2 = this.myStyle.getLineDashOffset();
                if (d2 == null) break block5;
                double p0 = ((Number)d2).doubleValue();
                boolean bl = false;
                ctx.setLineDashOffset(p0);
            }
        }

        @Override
        public void drawLine(@NotNull Context2d $this$drawLine, @NotNull List<? extends Vec<?>> line) {
            DefaultImpls.drawLine(this, $this$drawLine, line);
        }

        public static final /* synthetic */ void access$drawMultiLine(LineSymbolizer $this, Context2d $receiver, MultiLineString multiLine) {
            $this.drawMultiLine($receiver, (MultiLineString<Client>)multiLine);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$LineTextSymbolizer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer;", "style", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "labelBounds", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;Ljava/util/List;)V", "applyTo", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "createDrawTasks", "Lkotlin/Function0;", "feature", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "livemap"})
    public static final class LineTextSymbolizer
    implements Symbolizer {
        public LineTextSymbolizer(@NotNull Style style, @NotNull List<DoubleRectangle> labelBounds) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            Intrinsics.checkNotNullParameter(labelBounds, (String)"labelBounds");
        }

        @Override
        @NotNull
        public List<Function0<Unit>> createDrawTasks(@NotNull Context2d ctx, @NotNull TileFeature feature) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            return CollectionsKt.emptyList();
        }

        @Override
        public void applyTo(@NotNull Context2d ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        }

        @Override
        public void drawLine(@NotNull Context2d $this$drawLine, @NotNull List<? extends Vec<?>> line) {
            DefaultImpls.drawLine(this, $this$drawLine, line);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J$\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00140\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J&\u0010\u001c\u001a\u00020\t*\u00020\u000b2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00132\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J.\u0010\u001f\u001a\u00020\t*\u00020\u000b2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u00132\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$PointTextSymbolizer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer;", "myStyle", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "myLabelBounds", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;Ljava/util/List;)V", "applyTo", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "bboxFromPoint", "point", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "width", "", "height", "createDrawTasks", "", "Lkotlin/Function0;", "feature", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "getLabel", "", "labelInBounds", "", "bbox", "drawTextFast", "multiPoint", "label", "drawWrapText", "wrapWidth", "livemap"})
    @SourceDebugExtension(value={"SMAP\nSymbolizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Symbolizer.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$PointTextSymbolizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,326:1\n1549#2:327\n1620#2,3:328\n1855#2,2:331\n1855#2:333\n1864#2,3:334\n1856#2:337\n1#3:338\n*S KotlinDebug\n*F\n+ 1 Symbolizer.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$PointTextSymbolizer\n*L\n96#1:327\n96#1:328,3\n131#1:331,2\n167#1:333\n171#1:334,3\n167#1:337\n*E\n"})
    public static final class PointTextSymbolizer
    implements Symbolizer {
        @NotNull
        private final Style myStyle;
        @NotNull
        private final List<DoubleRectangle> myLabelBounds;

        public PointTextSymbolizer(@NotNull Style myStyle, @NotNull List<DoubleRectangle> myLabelBounds) {
            Intrinsics.checkNotNullParameter((Object)myStyle, (String)"myStyle");
            Intrinsics.checkNotNullParameter(myLabelBounds, (String)"myLabelBounds");
            this.myStyle = myStyle;
            this.myLabelBounds = myLabelBounds;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Function0<Unit>> createDrawTasks(@NotNull Context2d ctx, @NotNull TileFeature feature) {
            ArrayList<createDrawTasks.2.1.1> tasks;
            block1: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                tasks = new ArrayList<createDrawTasks.2.1.1>();
                Iterable iterable = (Iterable)feature.getTileGeometry().getMultiPoint();
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Vec vec = (Vec)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Geometries.INSTANCE.floor(it));
                }
                List multiPoint = (List)destination$iv$iv;
                boolean bl = false;
                String string = this.getLabel(feature);
                if (string == null) break block1;
                String label = string;
                boolean bl2 = false;
                tasks.add(new Function0<Unit>(this, ctx, label, (List<? extends Vec<? extends Client>>)multiPoint){
                    final /* synthetic */ PointTextSymbolizer this$0;
                    final /* synthetic */ Context2d $ctx;
                    final /* synthetic */ String $label;
                    final /* synthetic */ List<Vec<Client>> $multiPoint;
                    {
                        this.this$0 = $receiver;
                        this.$ctx = $ctx;
                        this.$label = $label;
                        this.$multiPoint = $multiPoint;
                        super(0);
                    }

                    public final void invoke() {
                        Double wrapWidth = PointTextSymbolizer.access$getMyStyle$p(this.this$0).getWrapWidth();
                        if (wrapWidth != null && wrapWidth > 0.0 && wrapWidth < this.$ctx.measureTextWidth(this.$label)) {
                            PointTextSymbolizer.access$drawWrapText(this.this$0, this.$ctx, this.$multiPoint, this.$label, wrapWidth);
                        } else {
                            PointTextSymbolizer.access$drawTextFast(this.this$0, this.$ctx, this.$multiPoint, this.$label);
                        }
                    }
                });
            }
            return tasks;
        }

        private final DoubleRectangle bboxFromPoint(Vec<?> point, double width, double height) {
            return DoubleRectangle.Companion.span(new DoubleVector(point.getX() - width / (double)2, point.getY() - height / (double)2), new DoubleVector(point.getX() + width / (double)2, point.getY() + height / (double)2));
        }

        private final void drawTextFast(Context2d $this$drawTextFast, List<? extends Vec<?>> multiPoint, String label) {
            double width = $this$drawTextFast.measureTextWidth(label);
            Double d = this.myStyle.getSize();
            double height = d != null ? d : 10.0;
            Iterable $this$forEach$iv = multiPoint;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vec point = (Vec)element$iv;
                boolean bl = false;
                DoubleRectangle bbox = this.bboxFromPoint(point, width, height);
                if (this.labelInBounds(bbox)) continue;
                $this$drawTextFast.strokeText(label, point.getX(), point.getY());
                $this$drawTextFast.fillText(label, point.getX(), point.getY());
                this.myLabelBounds.add(bbox);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void drawWrapText(Context2d $this$drawWrapText, List<? extends Vec<?>> multiPoint, String label, double wrapWidth) {
            double width = 0.0;
            width = wrapWidth;
            List words = Companion.splitLabel(label);
            ArrayList<String> next = new ArrayList<String>();
            ArrayList<String> rows = new ArrayList<String>();
            Double d = this.myStyle.getSize();
            double height = d != null ? d : 10.0;
            while (!((Collection)words).isEmpty()) {
                while ($this$drawWrapText.measureTextWidth(CollectionsKt.joinToString$default((Iterable)words, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)) > width && words.size() != 1) {
                    next.add(0, words.remove(words.size() - 1));
                }
                if (words.size() == 1 && $this$drawWrapText.measureTextWidth(words.get(0)) > width) {
                    rows.add(words.get(0));
                    width = $this$drawWrapText.measureTextWidth((String)words.get(0));
                } else {
                    rows.add(CollectionsKt.joinToString$default((Iterable)words, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
                words = next;
                next = new ArrayList();
            }
            Iterable $this$forEach$iv = multiPoint;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Vec point = (Vec)element$iv;
                boolean bl = false;
                DoubleRectangle bbox = this.bboxFromPoint(point, width, height);
                if (this.labelInBounds(bbox)) continue;
                Iterable $this$forEachIndexed$iv = rows;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void row;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    double y = bbox.getOrigin().getY() + height / (double)2 + height * (double)i;
                    $this$drawWrapText.strokeText((String)row, point.getX(), y);
                    $this$drawWrapText.fillText((String)row, point.getX(), y);
                }
                this.myLabelBounds.add(bbox);
            }
        }

        private final boolean labelInBounds(DoubleRectangle bbox) {
            Object v0;
            block1: {
                Iterable iterable = this.myLabelBounds;
                for (Object t : iterable) {
                    DoubleRectangle p0 = (DoubleRectangle)t;
                    boolean bl = false;
                    if (!bbox.intersects(p0)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        private final String getLabel(TileFeature feature) {
            String string;
            String labelField;
            String string2 = this.myStyle.getLabelField();
            if (string2 == null) {
                string2 = "label";
            }
            if (Intrinsics.areEqual((Object)(labelField = string2), (Object)"short")) {
                string = feature.getShort();
            } else if (Intrinsics.areEqual((Object)labelField, (Object)"label")) {
                string = feature.getLabel();
            } else {
                throw new IllegalStateException("Unknown label field: " + labelField);
            }
            return string;
        }

        @Override
        public void applyTo(@NotNull Context2d ctx) {
            String string;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string2 = this.myStyle.getFontStyle();
            if (string2 == null || (string2 = SymbolizerKt.access$getFontStyle(string2)) == null) {
                string2 = FontStyle.NORMAL;
            }
            if ((string = this.myStyle.getFontStyle()) == null || (string = SymbolizerKt.access$getFontWeight(string)) == null) {
                string = FontWeight.NORMAL;
            }
            Double d = this.myStyle.getSize();
            double d2 = d != null ? d : 10.0;
            String string3 = this.myStyle.getFontFamily();
            if (string3 == null) {
                string3 = "serif";
            }
            ctx.setFont(new Font((FontStyle)string2, (FontWeight)string, d2, string3));
            ctx.setTextAlign(TextAlign.CENTER);
            ctx.setTextBaseline(TextBaseline.MIDDLE);
            ctx.setStrokeMiterLimit(0.0);
            Companion.setBaseStyle(ctx, this.myStyle);
        }

        @Override
        public void drawLine(@NotNull Context2d $this$drawLine, @NotNull List<? extends Vec<?>> line) {
            DefaultImpls.drawLine(this, $this$drawLine, line);
        }

        public static final /* synthetic */ Style access$getMyStyle$p(PointTextSymbolizer $this) {
            return $this.myStyle;
        }

        public static final /* synthetic */ void access$drawWrapText(PointTextSymbolizer $this, Context2d $receiver, List multiPoint, String label, double wrapWidth) {
            $this.drawWrapText($receiver, multiPoint, label, wrapWidth);
        }

        public static final /* synthetic */ void access$drawTextFast(PointTextSymbolizer $this, Context2d $receiver, List multiPoint, String label) {
            $this.drawTextFast($receiver, multiPoint, label);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u0006*\u00020\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$PolygonSymbolizer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer;", "myStyle", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "(Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;)V", "applyTo", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "createDrawTasks", "", "Lkotlin/Function0;", "feature", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "drawMultiPolygon", "multiPolygon", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/MultiPolygon;", "livemap"})
    public static final class PolygonSymbolizer
    implements Symbolizer {
        @NotNull
        private final Style myStyle;

        public PolygonSymbolizer(@NotNull Style myStyle) {
            Intrinsics.checkNotNullParameter((Object)myStyle, (String)"myStyle");
            this.myStyle = myStyle;
        }

        private final void drawMultiPolygon(Context2d $this$drawMultiPolygon, MultiPolygon<?> multiPolygon) {
            $this$drawMultiPolygon.beginPath();
            for (Polygon polygon : multiPolygon) {
                for (Ring ring : polygon) {
                    this.drawLine($this$drawMultiPolygon, (List)ring);
                }
            }
        }

        @Override
        @NotNull
        public List<Function0<Unit>> createDrawTasks(@NotNull Context2d ctx, @NotNull TileFeature feature) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            ArrayList<Function0<Unit>> tasks = new ArrayList<Function0<Unit>>();
            MultiPolygon it = feature.getTileGeometry().getMultiPolygon();
            boolean bl = false;
            tasks.add(new Function0<Unit>(this, ctx, (MultiPolygon<Client>)it){
                final /* synthetic */ PolygonSymbolizer this$0;
                final /* synthetic */ Context2d $ctx;
                final /* synthetic */ MultiPolygon<Client> $it;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    PolygonSymbolizer.access$drawMultiPolygon(this.this$0, this.$ctx, this.$it);
                }
            });
            tasks.add(new Function0<Unit>((Object)ctx){

                public final void invoke() {
                    ((Context2d)this.receiver).fill();
                }
            });
            return tasks;
        }

        @Override
        public void applyTo(@NotNull Context2d ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Companion.setBaseStyle(ctx, this.myStyle);
        }

        @Override
        public void drawLine(@NotNull Context2d $this$drawLine, @NotNull List<? extends Vec<?>> line) {
            DefaultImpls.drawLine(this, $this$drawLine, line);
        }

        public static final /* synthetic */ void access$drawMultiPolygon(PolygonSymbolizer $this, Context2d $receiver, MultiPolygon multiPolygon) {
            $this.drawMultiPolygon($receiver, multiPolygon);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer$ShieldTextSymbolizer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/Symbolizer;", "style", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;", "labelBounds", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Style;Ljava/util/List;)V", "applyTo", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "createDrawTasks", "Lkotlin/Function0;", "feature", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "livemap"})
    public static final class ShieldTextSymbolizer
    implements Symbolizer {
        public ShieldTextSymbolizer(@NotNull Style style, @NotNull List<DoubleRectangle> labelBounds) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            Intrinsics.checkNotNullParameter(labelBounds, (String)"labelBounds");
        }

        @Override
        @NotNull
        public List<Function0<Unit>> createDrawTasks(@NotNull Context2d ctx, @NotNull TileFeature feature) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            return CollectionsKt.emptyList();
        }

        @Override
        public void applyTo(@NotNull Context2d ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        }

        @Override
        public void drawLine(@NotNull Context2d $this$drawLine, @NotNull List<? extends Vec<?>> line) {
            DefaultImpls.drawLine(this, $this$drawLine, line);
        }
    }
}

