/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.Asyncs;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculator;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculatorKt;
import org.jetbrains.letsPlot.commons.intern.spatial.GeographicKt;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKeyKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.gis.tileprotocol.TileLayer;
import org.jetbrains.letsPlot.gis.tileprotocol.TileService;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileDataFetcher;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.CellsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u000bH\u0002J&\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00120\fj\u0002`\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataFetcherImpl;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataFetcher;", "myMapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "myTileService", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService;", "(Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;Lorg/jetbrains/letsPlot/gis/tileprotocol/TileService;)V", "calculateBBox", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "quadKeys", "", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "fetch", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileLayer;", "cellKey", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "livemap"})
@SourceDebugExtension(value={"SMAP\nTileDataFetcherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileDataFetcherImpl.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataFetcherImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1549#2:35\n1620#2,3:36\n*S KotlinDebug\n*F\n+ 1 TileDataFetcherImpl.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataFetcherImpl\n*L\n32#1:35\n32#1:36,3\n*E\n"})
public final class TileDataFetcherImpl
implements TileDataFetcher {
    @NotNull
    private final MapProjection myMapProjection;
    @NotNull
    private final TileService myTileService;

    public TileDataFetcherImpl(@NotNull MapProjection myMapProjection, @NotNull TileService myTileService) {
        Intrinsics.checkNotNullParameter((Object)myMapProjection, (String)"myMapProjection");
        Intrinsics.checkNotNullParameter((Object)myTileService, (String)"myTileService");
        this.myMapProjection = myMapProjection;
        this.myTileService = myTileService;
    }

    @Override
    @NotNull
    public Async<List<TileLayer>> fetch(@NotNull QuadKey<World> cellKey) {
        Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
        Set<QuadKey<LonLat>> quadKeys = CellsKt.convertCellKeyToQuadKeys(this.myMapProjection, cellKey);
        Rect<LonLat> rect2 = this.calculateBBox(quadKeys);
        if (rect2 == null) {
            return Asyncs.INSTANCE.constant((Object)CollectionsKt.emptyList());
        }
        Rect<LonLat> bbox = rect2;
        int zoom = cellKey.getLength();
        return this.myTileService.getTileData(bbox, zoom);
    }

    private final Rect<LonLat> calculateBBox(Set<QuadKey<LonLat>> quadKeys) {
        Rect p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = quadKeys;
        GeoBoundingBoxCalculator geoBoundingBoxCalculator = GeographicKt.getBBOX_CALCULATOR();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            QuadKey quadKey = (QuadKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(QuadKeyKt.computeRect((QuadKey)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (Rect)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(GeographicKt.convertToGeoRectangle((Rect)p0));
        }
        return GeoBoundingBoxCalculatorKt.geoRectsBBox((GeoBoundingBoxCalculator)geoBoundingBoxCalculator, (List)((List)destination$iv$iv));
    }
}

