/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.spatial.LonLat;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKeyKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Geometry;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.gis.tileprotocol.TileGeometryParser;
import org.jetbrains.letsPlot.gis.tileprotocol.TileLayer;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.Transform;
import org.jetbrains.letsPlot.livemap.core.Transforms;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTask;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskKt;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskUtil;
import org.jetbrains.letsPlot.livemap.geometry.MicroTasks;
import org.jetbrains.letsPlot.livemap.mapengine.MapProjection;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileDataParser;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileFeature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u00062\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0002J\"\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00110\u00100\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J@\u0010\u0014\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00100\u00150\u000f2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0016J>\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00100\u000f2\u0006\u0010\u001b\u001a\u00020\u00192 \u0010\u001c\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataParserImpl;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataParser;", "myMapProjection", "Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;", "(Lorg/jetbrains/letsPlot/livemap/mapengine/MapProjection;)V", "calculateTransform", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/LonLat;", "Lorg/jetbrains/letsPlot/livemap/Client;", "cellKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "createMicroThread", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Geometry;", "tileGeometryParser", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileGeometryParser;", "parse", "", "", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "tileData", "Lorg/jetbrains/letsPlot/gis/tileprotocol/TileLayer;", "parseTileLayer", "tileLayer", "transform", "livemap"})
@SourceDebugExtension(value={"SMAP\nTileDataParserImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileDataParserImpl.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataParserImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1549#2:100\n1620#2,3:101\n*S KotlinDebug\n*F\n+ 1 TileDataParserImpl.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataParserImpl\n*L\n34#1:100\n34#1:101,3\n*E\n"})
public final class TileDataParserImpl
implements TileDataParser {
    @NotNull
    private final MapProjection myMapProjection;

    public TileDataParserImpl(@NotNull MapProjection myMapProjection) {
        Intrinsics.checkNotNullParameter((Object)myMapProjection, (String)"myMapProjection");
        this.myMapProjection = myMapProjection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MicroTask<Map<String, List<TileFeature>>> parse(@NotNull QuadKey<World> cellKey, @NotNull List<TileLayer> tileData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
        Intrinsics.checkNotNullParameter(tileData, (String)"tileData");
        Function1<Vec<? extends LonLat>, Vec<Client>> transform2 = this.calculateTransform(cellKey);
        HashMap<String, List<TileFeature>> result = new HashMap<String, List<TileFeature>>();
        Iterable iterable = tileData;
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tileLayer;
            TileLayer tileLayer2 = (TileLayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MicroTaskKt.map(this.parseTileLayer((TileLayer)tileLayer, transform2), (Function1)new Function1<List<? extends TileFeature>, Unit>(result, (TileLayer)tileLayer){
                final /* synthetic */ HashMap<String, List<TileFeature>> $result;
                final /* synthetic */ TileLayer $tileLayer;
                {
                    this.$result = $result;
                    this.$tileLayer = $tileLayer;
                    super(1);
                }

                public final void invoke(@NotNull List<TileFeature> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    ((Map)this.$result).put(this.$tileLayer.getName(), it);
                }
            }));
        }
        List microThreads2 = (List)destination$iv$iv;
        return MicroTaskKt.map(MicroTaskUtil.INSTANCE.join(microThreads2), (Function1)new Function1<Unit, Map<String, ? extends List<? extends TileFeature>>>(result){
            final /* synthetic */ HashMap<String, List<TileFeature>> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Map<String, List<TileFeature>> invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$result;
            }
        });
    }

    private final Function1<Vec<? extends LonLat>, Vec<Client>> calculateTransform(QuadKey<World> cellKey) {
        Transform<Vec<World>, Vec<Client>> zoomProjection2 = Transforms.INSTANCE.zoom((Function0<Integer>)((Function0)new PropertyReference0Impl(cellKey){

            @Nullable
            public Object get() {
                return ((QuadKey)this.receiver).getLength();
            }
        }));
        Rect cellMapRect = QuadKeyKt.computeRect(cellKey, this.myMapProjection.getMapRect());
        Vec cellViewOrigin = zoomProjection2.apply(cellMapRect.getOrigin());
        return (Function1)new Function1<Vec<? extends LonLat>, Vec<? extends Client>>(this, zoomProjection2, cellViewOrigin){
            final /* synthetic */ TileDataParserImpl this$0;
            final /* synthetic */ Transform<Vec<World>, Vec<Client>> $zoomProjection;
            final /* synthetic */ Vec<Client> $cellViewOrigin;
            {
                this.this$0 = $receiver;
                this.$zoomProjection = $zoomProjection;
                this.$cellViewOrigin = $cellViewOrigin;
                super(1);
            }

            @Nullable
            public final Vec<Client> invoke(@NotNull Vec<? extends LonLat> lonLatVec) {
                Vec vec;
                Intrinsics.checkNotNullParameter(lonLatVec, (String)"lonLatVec");
                Vec vec2 = (Vec)TileDataParserImpl.access$getMyMapProjection$p(this.this$0).apply(lonLatVec);
                if (vec2 != null) {
                    Vec vec3 = vec2;
                    Transform<Vec<World>, Vec<Client>> transform2 = this.$zoomProjection;
                    Vec<Client> vec4 = this.$cellViewOrigin;
                    Vec it = vec3;
                    boolean bl = false;
                    vec = VecKt.minus(transform2.apply((Vec<World>)it), vec4);
                } else {
                    vec = null;
                }
                return vec;
            }
        };
    }

    private final MicroTask<List<TileFeature>> parseTileLayer(TileLayer tileLayer, Function1<? super Vec<? extends LonLat>, ? extends Vec<? extends Client>> transform2) {
        return MicroTaskKt.flatMap(this.createMicroThread(new TileGeometryParser(tileLayer.getGeometryCollection())), (Function1)new Function1<List<? extends Geometry<LonLat>>, MicroTask<List<? extends TileFeature>>>(transform2, tileLayer){
            final /* synthetic */ Function1<Vec<? extends LonLat>, Vec<Client>> $transform;
            final /* synthetic */ TileLayer $tileLayer;
            {
                this.$transform = $transform;
                this.$tileLayer = $tileLayer;
                super(1);
            }

            @NotNull
            public final MicroTask<List<TileFeature>> invoke(@NotNull List<Geometry<LonLat>> tileGeometries) {
                Intrinsics.checkNotNullParameter(tileGeometries, (String)"tileGeometries");
                ArrayList<TileFeature> tileFeatures = new ArrayList<TileFeature>();
                ArrayList<MicroTask<ResultT>> microThreads2 = new ArrayList<MicroTask<ResultT>>();
                int n = tileGeometries.size();
                Function1<Vec<? extends LonLat>, Vec<Client>> function1 = this.$transform;
                TileLayer tileLayer = this.$tileLayer;
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    Geometry<LonLat> geometry = tileGeometries.get(it);
                    microThreads2.add(MicroTaskKt.map(MicroTasks.INSTANCE.resample(geometry, function1), (Function1)new Function1<Geometry<Client>, Unit>(tileFeatures, tileLayer, it){
                        final /* synthetic */ ArrayList<TileFeature> $tileFeatures;
                        final /* synthetic */ TileLayer $tileLayer;
                        final /* synthetic */ int $it;
                        {
                            this.$tileFeatures = $tileFeatures;
                            this.$tileLayer = $tileLayer;
                            this.$it = $it;
                            super(1);
                        }

                        public final void invoke(@NotNull Geometry<Client> worldMultiPolygon) {
                            Intrinsics.checkNotNullParameter(worldMultiPolygon, (String)"worldMultiPolygon");
                            this.$tileFeatures.add(new TileFeature(worldMultiPolygon, (Integer)CollectionsKt.getOrNull((List)this.$tileLayer.getKinds(), (int)this.$it), (Integer)CollectionsKt.getOrNull((List)this.$tileLayer.getSubs(), (int)this.$it), (String)CollectionsKt.getOrNull((List)this.$tileLayer.getLabels(), (int)this.$it), (String)CollectionsKt.getOrNull((List)this.$tileLayer.getShorts(), (int)this.$it)));
                        }
                    }));
                }
                return MicroTaskKt.map(MicroTaskUtil.INSTANCE.join((Iterable<? extends MicroTask<Unit>>)microThreads2), (Function1)new Function1<Unit, List<? extends TileFeature>>(tileFeatures){
                    final /* synthetic */ ArrayList<TileFeature> $tileFeatures;
                    {
                        this.$tileFeatures = $tileFeatures;
                        super(1);
                    }

                    @NotNull
                    public final List<TileFeature> invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return this.$tileFeatures;
                    }
                });
            }
        });
    }

    private final MicroTask<List<Geometry<LonLat>>> createMicroThread(TileGeometryParser tileGeometryParser) {
        return new MicroTask<List<? extends Geometry<LonLat>>>(tileGeometryParser){
            private boolean myDone;
            final /* synthetic */ TileGeometryParser $tileGeometryParser;
            {
                this.$tileGeometryParser = $tileGeometryParser;
            }

            @NotNull
            public List<Geometry<LonLat>> getResult() {
                return this.$tileGeometryParser.getGeometries();
            }

            public void resume() {
                if (!this.$tileGeometryParser.resume()) {
                    this.myDone = true;
                }
            }

            public boolean alive() {
                return !this.myDone;
            }
        };
    }

    public static final /* synthetic */ MapProjection access$getMyMapProjection$p(TileDataParserImpl $this) {
        return $this.myMapProjection;
    }
}

