/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap.vector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.MapConfig;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.Rule;
import org.jetbrains.letsPlot.gis.tileprotocol.mapConfig.TilePredicate;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTask;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTaskUtil;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerKind;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.Symbolizer;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileDataRenderer;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileFeature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J>\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\tH\u0002JJ\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00180\u0017j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016JF\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010 \u001a\u00020\u0011*\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataRendererImpl;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataRenderer;", "myMapConfigSupplier", "Lkotlin/Function0;", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/MapConfig;", "(Lkotlin/jvm/functions/Function0;)V", "getFeaturesByRule", "", "Lorg/jetbrains/letsPlot/gis/tileprotocol/mapConfig/Rule;", "", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "zoom", "", "features", "rules", "render", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "", "canvas", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "tileFeatures", "", "cellKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "layerKind", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapLayerKind;", "tileFeaturesDrawTasks", "", "ctx", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "drawDummyTile", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "livemap"})
@SourceDebugExtension(value={"SMAP\nTileDataRendererImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileDataRendererImpl.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataRendererImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n372#2,7:119\n1#3:126\n1855#4:127\n1855#4,2:128\n1856#4:130\n*S KotlinDebug\n*F\n+ 1 TileDataRendererImpl.kt\norg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataRendererImpl\n*L\n35#1:119,7\n91#1:127\n92#1:128,2\n91#1:130\n*E\n"})
public final class TileDataRendererImpl
implements TileDataRenderer {
    @NotNull
    private final Function0<MapConfig> myMapConfigSupplier;

    public TileDataRendererImpl(@NotNull Function0<MapConfig> myMapConfigSupplier) {
        Intrinsics.checkNotNullParameter(myMapConfigSupplier, (String)"myMapConfigSupplier");
        this.myMapConfigSupplier = myMapConfigSupplier;
    }

    private final Map<Rule, List<TileFeature>> getFeaturesByRule(int zoom, List<TileFeature> features, List<Rule> rules) {
        HashMap featuresByRule = new HashMap();
        for (TileFeature feature : features) {
            for (Rule rule : rules) {
                Object object;
                if (!rule.predicate((TilePredicate)feature, zoom)) continue;
                Map $this$getOrPut$iv = featuresByRule;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(rule);
                if (value$iv == null) {
                    boolean bl = false;
                    ArrayList answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(rule, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(feature);
            }
        }
        return featuresByRule;
    }

    @Override
    @NotNull
    public MicroTask<Unit> render(@NotNull Canvas canvas, @NotNull Map<String, ? extends List<TileFeature>> tileFeatures, @NotNull QuadKey<World> cellKey, @NotNull BasemapLayerKind layerKind) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter(tileFeatures, (String)"tileFeatures");
        Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
        Intrinsics.checkNotNullParameter((Object)((Object)layerKind), (String)"layerKind");
        Context2d ctx = canvas.getContext2d();
        DoubleVector size = canvas.getSize().toDoubleVector();
        MapConfig mapConfig = (MapConfig)this.myMapConfigSupplier.invoke();
        ArrayList<Object> tasks = new ArrayList<Object>();
        if (!tileFeatures.isEmpty() && mapConfig != null) {
            tasks.add(new Function0<Unit>(ctx, mapConfig, layerKind){
                final /* synthetic */ Context2d $ctx;
                final /* synthetic */ MapConfig $mapConfig;
                final /* synthetic */ BasemapLayerKind $layerKind;
                {
                    this.$ctx = $ctx;
                    this.$mapConfig = $mapConfig;
                    this.$layerKind = $layerKind;
                    super(0);
                }

                public final void invoke() {
                    this.$ctx.setFillStyle((Color)this.$mapConfig.getTileSheetBackgrounds().get(this.$layerKind.toString()));
                }
            });
            tasks.add(new Function0<Unit>(ctx, size){
                final /* synthetic */ Context2d $ctx;
                final /* synthetic */ DoubleVector $size;
                {
                    this.$ctx = $ctx;
                    this.$size = $size;
                    super(0);
                }

                public final void invoke() {
                    this.$ctx.fillRect(0.0, 0.0, this.$size.getX(), this.$size.getY());
                }
            });
            tasks.addAll(this.tileFeaturesDrawTasks(ctx, tileFeatures, layerKind, cellKey.getLength()));
        } else if (layerKind == BasemapLayerKind.WORLD) {
            tasks.add(new Function0<Unit>(this, ctx, size){
                final /* synthetic */ TileDataRendererImpl this$0;
                final /* synthetic */ Context2d $ctx;
                final /* synthetic */ DoubleVector $size;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    this.$size = $size;
                    super(0);
                }

                public final void invoke() {
                    TileDataRendererImpl.access$drawDummyTile(this.this$0, this.$ctx, this.$size);
                }
            });
        }
        return MicroTaskUtil.INSTANCE.create((Iterable<? extends Function0<Unit>>)tasks);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Function0<Unit>> tileFeaturesDrawTasks(Context2d ctx, Map<String, ? extends List<TileFeature>> tileFeatures, BasemapLayerKind layerKind, int zoom) {
        MapConfig mapConfig = (MapConfig)this.myMapConfigSupplier.invoke();
        if (mapConfig == null) {
            return CollectionsKt.emptyList();
        }
        MapConfig mapConfig2 = mapConfig;
        ArrayList<Object> tasks = new ArrayList<Object>();
        ArrayList labelBounds = new ArrayList();
        for (String layerName : mapConfig2.getLayersByZoom(zoom)) {
            List rules = CollectionsKt.flatten((Iterable)mapConfig2.getLayerConfig(layerName).getRules(layerKind.toString()));
            List<TileFeature> list = tileFeatures.get(layerName);
            Intrinsics.checkNotNull(list);
            Map<Rule, List<TileFeature>> featuresByRule = this.getFeaturesByRule(zoom, list, rules);
            for (Rule rule : rules) {
                void $this$forEach$iv;
                tasks.add(new Function0<Unit>((Object)ctx){

                    public final void invoke() {
                        ((Context2d)this.receiver).save();
                    }
                });
                Symbolizer symbolizer = Symbolizer.Companion.create(rule.getStyle(), labelBounds);
                tasks.add(new Function0<Unit>(symbolizer, ctx){
                    final /* synthetic */ Symbolizer $symbolizer;
                    final /* synthetic */ Context2d $ctx;
                    {
                        this.$symbolizer = $symbolizer;
                        this.$ctx = $ctx;
                        super(0);
                    }

                    public final void invoke() {
                        this.$symbolizer.applyTo(this.$ctx);
                    }
                });
                List list2 = featuresByRule.get(rule);
                if (list2 == null) {
                    boolean bl = false;
                    list2 = CollectionsKt.emptyList();
                }
                Iterable iterable = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TileFeature feature = (TileFeature)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = symbolizer.createDrawTasks(ctx, feature);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        Function0 it = (Function0)element$iv2;
                        boolean bl2 = false;
                        tasks.add(it);
                    }
                }
                tasks.add(new Function0<Unit>((Object)ctx){

                    public final void invoke() {
                        ((Context2d)this.receiver).restore();
                    }
                });
            }
        }
        return tasks;
    }

    private final void drawDummyTile(Context2d $this$drawDummyTile, DoubleVector size) {
        $this$drawDummyTile.save();
        $this$drawDummyTile.setFillStyle(Color.Companion.getGRAY());
        $this$drawDummyTile.fillRect(0.0, 0.0, size.getX(), size.getY());
        $this$drawDummyTile.setStrokeStyle(Color.Companion.getWHITE());
        $this$drawDummyTile.strokeRect(0.0, 0.0, size.getX(), size.getY());
        $this$drawDummyTile.setStrokeStyle(Color.Companion.getLIGHT_GRAY());
        $this$drawDummyTile.moveTo(0.0, 0.0);
        $this$drawDummyTile.lineTo(size.getX(), size.getY());
        $this$drawDummyTile.moveTo(0.0, size.getY());
        $this$drawDummyTile.lineTo(size.getX(), 0.0);
        $this$drawDummyTile.stroke();
        $this$drawDummyTile.restore();
    }

    public static final /* synthetic */ void access$drawDummyTile(TileDataRendererImpl $this, Context2d $receiver, DoubleVector size) {
        $this.drawDummyTile($receiver, size);
    }
}

