/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.debug;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.SystemTime;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.multitasking.DebugMicroTask;
import org.jetbrains.letsPlot.livemap.core.multitasking.MicroTask;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.BasemapLayerKind;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.DebugDataComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.StatisticsComponent;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileDataRenderer;
import org.jetbrains.letsPlot.livemap.mapengine.basemap.vector.TileFeature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007JJ\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e2\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/debug/DebugTileDataRenderer;", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataRenderer;", "myStats", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/StatisticsComponent;", "mySystemTime", "Lorg/jetbrains/letsPlot/commons/SystemTime;", "myTileDataRenderer", "(Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/StatisticsComponent;Lorg/jetbrains/letsPlot/commons/SystemTime;Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileDataRenderer;)V", "render", "Lorg/jetbrains/letsPlot/livemap/core/multitasking/MicroTask;", "", "canvas", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "tileFeatures", "", "", "", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/vector/TileFeature;", "cellKey", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "layerKind", "Lorg/jetbrains/letsPlot/livemap/mapengine/basemap/BasemapLayerKind;", "livemap"})
public final class DebugTileDataRenderer
implements TileDataRenderer {
    @NotNull
    private final StatisticsComponent myStats;
    @NotNull
    private final SystemTime mySystemTime;
    @NotNull
    private final TileDataRenderer myTileDataRenderer;

    public DebugTileDataRenderer(@NotNull StatisticsComponent myStats, @NotNull SystemTime mySystemTime, @NotNull TileDataRenderer myTileDataRenderer) {
        Intrinsics.checkNotNullParameter((Object)myStats, (String)"myStats");
        Intrinsics.checkNotNullParameter((Object)mySystemTime, (String)"mySystemTime");
        Intrinsics.checkNotNullParameter((Object)myTileDataRenderer, (String)"myTileDataRenderer");
        this.myStats = myStats;
        this.mySystemTime = mySystemTime;
        this.myTileDataRenderer = myTileDataRenderer;
    }

    @Override
    @NotNull
    public MicroTask<Unit> render(@NotNull Canvas canvas, @NotNull Map<String, ? extends List<TileFeature>> tileFeatures, @NotNull QuadKey<World> cellKey, @NotNull BasemapLayerKind layerKind) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter(tileFeatures, (String)"tileFeatures");
        Intrinsics.checkNotNullParameter(cellKey, (String)"cellKey");
        Intrinsics.checkNotNullParameter((Object)((Object)layerKind), (String)"layerKind");
        MicroTask<Unit> microTask = this.myTileDataRenderer.render(canvas, tileFeatures, cellKey, layerKind);
        if (layerKind == BasemapLayerKind.DEBUG) {
            return microTask;
        }
        String renderKey = DebugDataComponent.Companion.renderTimeKey(layerKind);
        String snapshotKey = DebugDataComponent.Companion.snapshotTimeKey(layerKind);
        DebugMicroTask<Unit> debugMicroTask = new DebugMicroTask<Unit>(this.mySystemTime, microTask);
        debugMicroTask.addFinishHandler((Function0<Unit>)((Function0)new Function0<Unit>(this, cellKey, snapshotKey, renderKey, debugMicroTask){
            final /* synthetic */ DebugTileDataRenderer this$0;
            final /* synthetic */ QuadKey<World> $cellKey;
            final /* synthetic */ String $snapshotKey;
            final /* synthetic */ String $renderKey;
            final /* synthetic */ DebugMicroTask<Unit> $debugMicroTask;
            {
                this.this$0 = $receiver;
                this.$cellKey = $cellKey;
                this.$snapshotKey = $snapshotKey;
                this.$renderKey = $renderKey;
                this.$debugMicroTask = $debugMicroTask;
                super(0);
            }

            public final void invoke() {
                long start = DebugTileDataRenderer.access$getMySystemTime$p(this.this$0).getTimeMs();
                DebugTileDataRenderer.access$getMyStats$p(this.this$0).add(this.$cellKey, this.$snapshotKey, DebugTileDataRenderer.access$getMySystemTime$p(this.this$0).getTimeMs() - start + "ms");
                DebugTileDataRenderer.access$getMyStats$p(this.this$0).add(this.$cellKey, this.$renderKey, this.$debugMicroTask.getProcessTime() + "ms (" + this.$debugMicroTask.getMaxResumeTime() + "ms)");
            }
        }));
        return debugMicroTask;
    }

    public static final /* synthetic */ SystemTime access$getMySystemTime$p(DebugTileDataRenderer $this) {
        return $this.mySystemTime;
    }

    public static final /* synthetic */ StatisticsComponent access$getMyStats$p(DebugTileDataRenderer $this) {
        return $this.myStats;
    }
}

