/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.camera;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.animation.Animation;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.AnimationComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.util.EasingFunctions;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.camera.CameraComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\f0\bj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/camera/CameraScale;", "", "()V", "setAnimation", "", "cameraEntity", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "scaleOrigin", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "Lorg/jetbrains/letsPlot/livemap/ClientPoint;", "viewportPosition", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/WorldPoint;", "delta", "", "CameraScaleEffectComponent", "CameraScaleEffectSystem", "livemap"})
@SourceDebugExtension(value={"SMAP\nCameraScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraScale.kt\norg/jetbrains/letsPlot/livemap/mapengine/camera/CameraScale\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n*L\n1#1,86:1\n24#2,2:87\n*S KotlinDebug\n*F\n+ 1 CameraScale.kt\norg/jetbrains/letsPlot/livemap/mapengine/camera/CameraScale\n*L\n19#1:87,2\n*E\n"})
public final class CameraScale {
    @NotNull
    public static final CameraScale INSTANCE = new CameraScale();

    private CameraScale() {
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnimation(@NotNull EcsEntity cameraEntity, @NotNull Vec<? extends Client> scaleOrigin, @NotNull Vec<? extends World> viewportPosition, double delta) {
        void $this$setAnimation_u24lambda_u240;
        AnimationComponent animationComponent;
        Intrinsics.checkNotNullParameter((Object)cameraEntity, (String)"cameraEntity");
        Intrinsics.checkNotNullParameter(scaleOrigin, (String)"scaleOrigin");
        Intrinsics.checkNotNullParameter(viewportPosition, (String)"viewportPosition");
        EcsEntity this_$iv = cameraEntity;
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (CameraComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(CameraComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CameraComponent.class).getSimpleName() + " is not found");
        }
        CameraComponent camera2 = (CameraComponent)ecsComponent;
        if (!(camera2.getZoom() % 1.0 == 0.0)) {
            return;
        }
        AnimationComponent animationComponent2 = animationComponent = new AnimationComponent();
        EcsEntity ecsEntity = cameraEntity.getComponentManager().createEntity("camera_scale_animation");
        boolean bl = false;
        $this$setAnimation_u24lambda_u240.setDuration(250.0);
        $this$setAnimation_u24lambda_u240.setEasingFunction(EasingFunctions.INSTANCE.getEASE_OUT_QUAD());
        $this$setAnimation_u24lambda_u240.setLoop(Animation.Loop.DISABLED);
        $this$setAnimation_u24lambda_u240.setDirection(Animation.Direction.FORWARD);
        EcsEntity animation = ecsEntity.add(animationComponent);
        cameraEntity.setComponent((EcsComponent)new CameraScaleEffectComponent(animation.getId$livemap(), scaleOrigin, viewportPosition, delta, camera2.getZoom()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u001b\u0010\b\u001a\f\u0012\u0004\u0012\u00020\t0\u0005j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/camera/CameraScale$CameraScaleEffectComponent;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponent;", "animationId", "", "scaleOrigin", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "Lorg/jetbrains/letsPlot/livemap/ClientPoint;", "viewportPosition", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/WorldPoint;", "delta", "", "startZoom", "(ILorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;DD)V", "getAnimationId", "()I", "currentScale", "getCurrentScale", "()D", "setCurrentScale", "(D)V", "getDelta", "getScaleOrigin", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "getStartZoom", "getViewportPosition", "livemap"})
    public static final class CameraScaleEffectComponent
    implements EcsComponent {
        private final int animationId;
        @NotNull
        private final Vec<Client> scaleOrigin;
        @NotNull
        private final Vec<World> viewportPosition;
        private final double delta;
        private final double startZoom;
        private double currentScale;

        public CameraScaleEffectComponent(int animationId, @NotNull Vec<? extends Client> scaleOrigin, @NotNull Vec<? extends World> viewportPosition, double delta, double startZoom) {
            Intrinsics.checkNotNullParameter(scaleOrigin, (String)"scaleOrigin");
            Intrinsics.checkNotNullParameter(viewportPosition, (String)"viewportPosition");
            this.animationId = animationId;
            this.scaleOrigin = scaleOrigin;
            this.viewportPosition = viewportPosition;
            this.delta = delta;
            this.startZoom = startZoom;
            this.currentScale = 1.0;
        }

        public final int getAnimationId() {
            return this.animationId;
        }

        @NotNull
        public final Vec<Client> getScaleOrigin() {
            return this.scaleOrigin;
        }

        @NotNull
        public final Vec<World> getViewportPosition() {
            return this.viewportPosition;
        }

        public final double getDelta() {
            return this.delta;
        }

        public final double getStartZoom() {
            return this.startZoom;
        }

        public final double getCurrentScale() {
            return this.currentScale;
        }

        public final void setCurrentScale(double d) {
            this.currentScale = d;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/camera/CameraScale$CameraScaleEffectSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;)V", "updateImpl", "", "context", "dt", "", "livemap"})
    @SourceDebugExtension(value={"SMAP\nCameraScale.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraScale.kt\norg/jetbrains/letsPlot/livemap/mapengine/camera/CameraScale$CameraScaleEffectSystem\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n28#2,2:87\n24#2,8:89\n24#2,2:97\n70#2:99\n1#3:100\n*S KotlinDebug\n*F\n+ 1 CameraScale.kt\norg/jetbrains/letsPlot/livemap/mapengine/camera/CameraScale$CameraScaleEffectSystem\n*L\n54#1:87,2\n54#1:89,8\n57#1:97,2\n69#1:99\n69#1:100\n*E\n"})
    public static final class CameraScaleEffectSystem
    extends AbstractSystem<LiveMapContext> {
        public CameraScaleEffectSystem(@NotNull EcsComponentManager componentManager) {
            Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
            super(componentManager);
        }

        @Override
        protected void updateImpl(@NotNull LiveMapContext context, double dt) {
            block6: {
                EcsEntity animation;
                EcsComponent ecsComponent;
                EcsEntity cameraEntity;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                EcsEntity this_$iv = cameraEntity = this.getSingletonEntity((KClass<EcsComponent>)Reflection.getOrCreateKotlinClass(CameraComponent.class));
                boolean $i$f$tryGet = false;
                if (this_$iv.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CameraScaleEffectComponent.class))) {
                    EcsEntity this_$iv$iv = this_$iv;
                    boolean $i$f$get = false;
                    ecsComponent = (CameraScaleEffectComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(CameraScaleEffectComponent.class));
                    if (ecsComponent == null) {
                        throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CameraScaleEffectComponent.class).getSimpleName() + " is not found");
                    }
                } else {
                    ecsComponent = null;
                }
                CameraScaleEffectComponent cameraScaleEffectComponent = (CameraScaleEffectComponent)ecsComponent;
                if (cameraScaleEffectComponent == null) break block6;
                CameraScaleEffectComponent scaleEffect = cameraScaleEffectComponent;
                boolean bl = false;
                EcsEntity ecsEntity = this.getEntityById(scaleEffect.getAnimationId());
                if (ecsEntity == null) {
                    return;
                }
                EcsEntity this_$iv2 = animation = ecsEntity;
                boolean $i$f$get = false;
                EcsComponent ecsComponent2 = (AnimationComponent)this_$iv2.getComponentManager().getComponents(this_$iv2).get(Reflection.getOrCreateKotlinClass(AnimationComponent.class));
                if (ecsComponent2 == null) {
                    throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(AnimationComponent.class).getSimpleName() + " is not found");
                }
                double progress = ((AnimationComponent)ecsComponent2).getProgress();
                double deltaZoom = scaleEffect.getDelta() * progress;
                scaleEffect.setCurrentScale(Math.signum(scaleEffect.getDelta()) == -1.0 ? 1.0 + deltaZoom / (double)2 : 1.0 + deltaZoom);
                context.getCamera().setAnimationValue(scaleEffect.getStartZoom() + deltaZoom);
                if (progress == 1.0) {
                    EcsEntity ecsEntity2;
                    context.getCamera().requestPosition(scaleEffect.getViewportPosition());
                    EcsEntity this_$iv3 = cameraEntity;
                    boolean $i$f$remove = false;
                    EcsEntity $this$remove_u24lambda_u242$iv = ecsEntity2 = this_$iv3;
                    boolean bl2 = false;
                    $this$remove_u24lambda_u242$iv.removeComponent((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CameraScaleEffectComponent.class));
                }
            }
        }
    }
}

