/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.viewport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.Transform;
import org.jetbrains.letsPlot.livemap.core.Transforms;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.ViewportHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u001b\b\u0016\u0018\u0000 >2\u00020\u0001:\u0001>B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ \u00101\u001a\b\u0012\u0004\u0012\u00020\u00130$2\u0012\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130$03J\"\u00104\u001a\f\u0012\u0004\u0012\u00020\u00130\u0005j\u0002`\u00142\u0010\u00105\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007J\u0016\u00106\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u000703J\"\u00107\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\u0010\u00108\u001a\f\u0012\u0004\u0012\u00020\u00130\u0005j\u0002`\u0014J\"\u00109\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u00072\u0010\u0010:\u001a\f\u0012\u0004\u0012\u00020\u00130\u0005j\u0002`\u0014J\"\u0010;\u001a\f\u0012\u0004\u0012\u00020\u00130\u0005j\u0002`\u00142\u0010\u0010:\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007J\b\u0010<\u001a\u00020=H\u0002R\u001b\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R8\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00130\u0005j\u0002`\u00142\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00130\u0005j\u0002`\u0014@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR$\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00130\u001fj\u0002` 0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R2\u0010&\u001a\f\u0012\u0004\u0012\u00020\u00130$j\u0002`%2\u0010\u0010#\u001a\f\u0012\u0004\u0012\u00020\u00130$j\u0002`%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0010\"\u0004\b-\u0010.R&\u0010/\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000500X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "", "helper", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/ViewportHelper;", "size", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "Lorg/jetbrains/letsPlot/livemap/ClientPoint;", "minZoom", "", "maxZoom", "(Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/ViewportHelper;Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;II)V", "center", "getCenter", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "getMaxZoom", "()I", "getMinZoom", "value", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/WorldPoint;", "position", "getPosition", "setPosition", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;)V", "getSize", "viewportTransform", "org/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport$viewportTransform$1", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport$viewportTransform$1;", "visibleCells", "", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "getVisibleCells", "()Ljava/util/Set;", "<set-?>", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "Lorg/jetbrains/letsPlot/livemap/WorldRectangle;", "window", "getWindow", "()Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "windowOrigin", "windowSize", "zoom", "getZoom", "setZoom", "(I)V", "zoomTransform", "Lorg/jetbrains/letsPlot/livemap/core/Transform;", "calculateBoundingBox", "bBoxes", "", "getMapCoord", "viewCoord", "getMapOrigins", "getViewCoord", "mapCoord", "toClientDimension", "dimension", "toWorldDimension", "updateWindow", "", "Companion", "livemap"})
@SourceDebugExtension(value={"SMAP\nViewport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Viewport.kt\norg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1#2:99\n1549#3:100\n1620#3,3:101\n*S KotlinDebug\n*F\n+ 1 Viewport.kt\norg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport\n*L\n74#1:100\n74#1:101,3\n*E\n"})
public class Viewport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewportHelper helper;
    @NotNull
    private final Vec<Client> size;
    private final int minZoom;
    private final int maxZoom;
    @NotNull
    private final Transform<Vec<World>, Vec<Client>> zoomTransform;
    @NotNull
    private final viewportTransform.1 viewportTransform;
    @NotNull
    private final Vec<Client> center;
    @NotNull
    private Vec<? extends World> windowSize;
    @NotNull
    private Vec<? extends World> windowOrigin;
    @NotNull
    private Rect<World> window;
    private int zoom;
    @NotNull
    private Vec<? extends World> position;

    public Viewport(@NotNull ViewportHelper helper, @NotNull Vec<? extends Client> size, int minZoom, int maxZoom) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter(size, (String)"size");
        this.helper = helper;
        this.size = size;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.zoomTransform = Transforms.INSTANCE.zoom((Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ Viewport this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getZoom();
            }
        }));
        this.viewportTransform = new Transform<Vec<? extends World>, Vec<? extends Client>>(this){
            final /* synthetic */ Viewport this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Vec<Client> apply(@NotNull Vec<? extends World> v) {
                Intrinsics.checkNotNullParameter(v, (String)"v");
                return VecKt.plus((Vec)VecKt.minus((Vec)((Vec)Viewport.access$getZoomTransform$p(this.this$0).apply(v)), (Vec)((Vec)Viewport.access$getZoomTransform$p(this.this$0).apply(this.this$0.getPosition()))), this.this$0.getCenter());
            }

            @NotNull
            public Vec<World> invert(@NotNull Vec<? extends Client> v) {
                Intrinsics.checkNotNullParameter(v, (String)"v");
                return VecKt.plus((Vec)VecKt.minus((Vec)((Vec)Viewport.access$getZoomTransform$p(this.this$0).invert(v)), (Vec)((Vec)Viewport.access$getZoomTransform$p(this.this$0).invert(this.this$0.getCenter()))), this.this$0.getPosition());
            }
        };
        this.center = VecKt.div(this.size, (double)2.0);
        this.windowSize = World.Companion.getZERO_VEC();
        this.windowOrigin = World.Companion.getZERO_VEC();
        this.window = new Rect(World.Companion.getZERO_VEC(), World.Companion.getZERO_VEC());
        this.zoom = this.minZoom;
        this.position = World.Companion.getZERO_VEC();
        this.setZoom(1);
    }

    @NotNull
    public final Vec<Client> getSize() {
        return this.size;
    }

    public final int getMinZoom() {
        return this.minZoom;
    }

    public final int getMaxZoom() {
        return this.maxZoom;
    }

    @NotNull
    public final Vec<Client> getCenter() {
        return this.center;
    }

    @NotNull
    public final Rect<World> getWindow() {
        return this.window;
    }

    public final int getZoom() {
        return this.zoom;
    }

    public final void setZoom(int zoom) {
        this.zoom = Math.max(this.minZoom, Math.min(zoom, this.maxZoom));
        this.windowSize = this.zoomTransform.invert(this.size);
        this.windowOrigin = this.viewportTransform.invert(Client.Companion.getZERO_VEC());
        this.updateWindow();
    }

    @NotNull
    public Vec<World> getPosition() {
        return this.position;
    }

    public void setPosition(@NotNull Vec<? extends World> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.position = this.helper.normalize(value);
        this.windowOrigin = this.viewportTransform.invert(Client.Companion.getZERO_VEC());
        this.updateWindow();
    }

    @NotNull
    public Set<QuadKey<World>> getVisibleCells() {
        return this.helper.getCells(this.window, this.zoom);
    }

    @NotNull
    public final Vec<World> getMapCoord(@NotNull Vec<? extends Client> viewCoord) {
        Intrinsics.checkNotNullParameter(viewCoord, (String)"viewCoord");
        return this.helper.normalize(this.viewportTransform.invert(viewCoord));
    }

    @NotNull
    public final Vec<Client> getViewCoord(@NotNull Vec<? extends World> mapCoord) {
        Intrinsics.checkNotNullParameter(mapCoord, (String)"mapCoord");
        return this.viewportTransform.apply(mapCoord);
    }

    @NotNull
    public final Vec<Client> toClientDimension(@NotNull Vec<? extends World> dimension) {
        Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
        return this.zoomTransform.apply(dimension);
    }

    @NotNull
    public final Vec<World> toWorldDimension(@NotNull Vec<? extends Client> dimension) {
        Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
        return this.zoomTransform.invert(dimension);
    }

    @NotNull
    public final Rect<World> calculateBoundingBox(@NotNull List<Rect<World>> bBoxes) {
        Intrinsics.checkNotNullParameter(bBoxes, (String)"bBoxes");
        return this.helper.calculateBoundingBox(bBoxes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vec<Client>> getMapOrigins() {
        void $this$mapTo$iv$iv;
        Vec<Client> origin = this.getViewCoord(World.Companion.getZERO_VEC());
        Vec<Client> dim = this.toClientDimension((Vec<? extends World>)World.Companion.getDOMAIN().getDimension());
        Rect it = Rect.Companion.LTRB(this.viewportTransform.invert(origin), this.viewportTransform.invert((Vec<? extends Client>)VecKt.plus(origin, dim)));
        boolean $i$a$-let-Viewport$getMapOrigins$22 = false;
        Iterable $this$map$iv = this.helper.getOrigins$livemap((Rect<World>)it, this.window);
        boolean $i$f$map = false;
        Iterable $i$a$-let-Viewport$getMapOrigins$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Vec vec = (Vec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getViewCoord((Vec<? extends World>)p0));
        }
        return (List)destination$iv$iv;
    }

    private final void updateWindow() {
        this.window = new Rect(this.windowOrigin, this.windowSize);
    }

    public static final /* synthetic */ Transform access$getZoomTransform$p(Viewport $this) {
        return $this.zoomTransform;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\f0\bj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ*\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n2\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\f0\bj\u0002`\r2\u0006\u0010\u0013\u001a\u00020\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "helper", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/ViewportHelper;", "size", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "Lorg/jetbrains/letsPlot/livemap/ClientPoint;", "position", "Lorg/jetbrains/letsPlot/livemap/World;", "Lorg/jetbrains/letsPlot/livemap/WorldPoint;", "minZoom", "", "maxZoom", "toClientDimension", "dimension", "zoom", "livemap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Viewport create(@NotNull ViewportHelper helper, @NotNull Vec<? extends Client> size, @NotNull Vec<? extends World> position, int minZoom, int maxZoom) {
            Viewport viewport;
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter(size, (String)"size");
            Intrinsics.checkNotNullParameter(position, (String)"position");
            Viewport $this$create_u24lambda_u240 = viewport = new Viewport(helper, size, minZoom, maxZoom);
            boolean bl = false;
            $this$create_u24lambda_u240.setPosition(position);
            return viewport;
        }

        @NotNull
        public final Vec<Client> toClientDimension(@NotNull Vec<? extends World> dimension, int zoom) {
            Intrinsics.checkNotNullParameter(dimension, (String)"dimension");
            return Transforms.INSTANCE.zoom((Function0<Integer>)((Function0)new Function0<Integer>(zoom){
                final /* synthetic */ int $zoom;
                {
                    this.$zoom = $zoom;
                    super(0);
                }

                @NotNull
                public final Integer invoke() {
                    return this.$zoom;
                }
            })).apply(dimension);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

