/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.mapengine.viewport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculator;
import org.jetbrains.letsPlot.commons.intern.spatial.GeoBoundingBoxCalculatorKt;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadKey;
import org.jetbrains.letsPlot.commons.intern.spatial.QuadsKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Rect;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.RectKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.VecKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.livemap.World;
import org.jetbrains.letsPlot.livemap.core.MapRuler;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.ViewportHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J0\u0010\u0015\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00020\u0017j\u0002`\u00180\u00162\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00020\u0004j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJA\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00020\u001ej\u0002`\u001f0\u000b2\u0010\u0010 \u001a\f\u0012\u0004\u0012\u00020\u00020\u0004j\u0002`\u001a2\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u00020\u0004j\u0002`\u001aH\u0000\u00a2\u0006\u0002\b!J \u0010\"\u001a\b\u0012\u0004\u0012\u0002H#0\u001e\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0\u001eJ&\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00040\u000b2\u0010\u0010&\u001a\f\u0012\u0004\u0012\u00020\u00020\u0004j\u0002`\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/ViewportHelper;", "Lorg/jetbrains/letsPlot/livemap/core/MapRuler;", "Lorg/jetbrains/letsPlot/livemap/World;", "myMapRect", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;", "myLoopX", "", "myLoopY", "(Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Rect;ZZ)V", "calculateBoundingBox", "xyRects", "", "deltaOnLoop", "", "x1", "x2", "length", "distanceX", "distanceY", "y1", "y2", "getCells", "", "Lorg/jetbrains/letsPlot/commons/intern/spatial/QuadKey;", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/CellKey;", "viewRect", "Lorg/jetbrains/letsPlot/livemap/WorldRectangle;", "cellLevel", "", "getOrigins", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/WorldPoint;", "objRect", "getOrigins$livemap", "normalize", "T", "v", "splitRect", "rect", "livemap"})
@SourceDebugExtension(value={"SMAP\nViewportHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewportHelper.kt\norg/jetbrains/letsPlot/livemap/mapengine/viewport/ViewportHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1#2:183\n1549#3:184\n1620#3,3:185\n1855#3:188\n1855#3,2:189\n1856#3:191\n*S KotlinDebug\n*F\n+ 1 ViewportHelper.kt\norg/jetbrains/letsPlot/livemap/mapengine/viewport/ViewportHelper\n*L\n114#1:184\n114#1:185,3\n152#1:188\n153#1:189,2\n152#1:191\n*E\n"})
public final class ViewportHelper
implements MapRuler<World> {
    @NotNull
    private final Rect<World> myMapRect;
    private final boolean myLoopX;
    private final boolean myLoopY;

    public ViewportHelper(@NotNull Rect<World> myMapRect, boolean myLoopX, boolean myLoopY) {
        Intrinsics.checkNotNullParameter(myMapRect, (String)"myMapRect");
        this.myMapRect = myMapRect;
        this.myLoopX = myLoopX;
        this.myLoopY = myLoopY;
    }

    @NotNull
    public final <T> Vec<T> normalize(@NotNull Vec<? extends T> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return VecKt.explicitVec((double)ViewportHelper.normalize$normalize(v.getX(), RectKt.getLeft(this.myMapRect), RectKt.getRight(this.myMapRect), this.myLoopX), (double)ViewportHelper.normalize$normalize(v.getY(), RectKt.getTop(this.myMapRect), RectKt.getBottom(this.myMapRect), this.myLoopY));
    }

    @Override
    public double distanceX(double x1, double x2) {
        double d;
        boolean bl = this.myLoopX;
        if (bl) {
            d = this.deltaOnLoop(x1, x2, RectKt.getWidth(this.myMapRect));
        } else if (!bl) {
            d = x2 - x1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double p0 = d;
        boolean bl2 = false;
        return Math.abs(p0);
    }

    @Override
    public double distanceY(double y1, double y2) {
        double d;
        boolean bl = this.myLoopY;
        if (bl) {
            d = this.deltaOnLoop(y1, y2, RectKt.getHeight(this.myMapRect));
        } else if (!bl) {
            d = y2 - y1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double p0 = d;
        boolean bl2 = false;
        return Math.abs(p0);
    }

    @Override
    @NotNull
    public Rect<World> calculateBoundingBox(@NotNull List<Rect<World>> xyRects) {
        Intrinsics.checkNotNullParameter(xyRects, (String)"xyRects");
        return GeoBoundingBoxCalculatorKt.union((GeoBoundingBoxCalculator)new GeoBoundingBoxCalculator(this.myMapRect, this.myLoopX, this.myLoopY), xyRects);
    }

    @NotNull
    public final List<Vec<World>> getOrigins$livemap(@NotNull Rect<World> objRect, @NotNull Rect<World> viewRect) {
        Intrinsics.checkNotNullParameter(objRect, (String)"objRect");
        Intrinsics.checkNotNullParameter(viewRect, (String)"viewRect");
        List<Double> xOrigins = ViewportHelper.getOrigins$getOrigins(RectKt.xRange(objRect), RectKt.xRange(this.myMapRect), RectKt.xRange(viewRect), this.myLoopX);
        List<Double> yOrigins = ViewportHelper.getOrigins$getOrigins(RectKt.yRange(objRect), RectKt.yRange(this.myMapRect), RectKt.yRange(viewRect), this.myLoopY);
        ArrayList<Vec> result = new ArrayList<Vec>();
        Iterator<Double> iterator = xOrigins.iterator();
        while (iterator.hasNext()) {
            double xOrigin = ((Number)iterator.next()).doubleValue();
            Iterator<Double> iterator2 = yOrigins.iterator();
            while (iterator2.hasNext()) {
                double yOrigin = ((Number)iterator2.next()).doubleValue();
                result.add(VecKt.explicitVec((double)xOrigin, (double)yOrigin));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<QuadKey<World>> getCells(@NotNull Rect<World> viewRect, int cellLevel) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(viewRect, (String)"viewRect");
        Iterable $this$map$iv = this.splitRect(viewRect);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Rect rect2 = (Rect)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(QuadsKt.calculateQuadKeys(this.myMapRect, (Rect)it, (int)cellLevel, (Function1)getCells.1.1.INSTANCE));
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
    }

    private final List<Rect<World>> splitRect(Rect<World> rect2) {
        List<DoubleSpan> xRanges = ViewportHelper.splitRect$splitRange(RectKt.xRange(rect2), RectKt.xRange(this.myMapRect), this.myLoopX);
        List<DoubleSpan> yRanges = ViewportHelper.splitRect$splitRange(RectKt.yRange(rect2), RectKt.yRange(this.myMapRect), this.myLoopY);
        ArrayList<Rect> rects = new ArrayList<Rect>();
        Iterable $this$forEach$iv = xRanges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DoubleSpan xRange = (DoubleSpan)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = yRanges;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DoubleSpan yRange = (DoubleSpan)element$iv2;
                boolean bl2 = false;
                rects.add(Rect.Companion.XYWH(xRange.getLowerEnd().doubleValue(), yRange.getLowerEnd().doubleValue(), xRange.getLength(), yRange.getLength()));
            }
        }
        return rects;
    }

    private final double deltaOnLoop(double x1, double x2, double length) {
        double dist = Math.abs(x2 - x1);
        if (dist <= length - dist) {
            return x2 - x1;
        }
        double closestX2 = x2;
        closestX2 = x2 < x1 ? (closestX2 += length) : (closestX2 -= length);
        return closestX2 - x1;
    }

    private static final double normalize$normalize(double v, double min, double max, boolean loop) {
        if (!loop) {
            return Math.max(min, Math.min(v, max));
        }
        double len = max - min;
        double result = v - (double)((int)(v / len)) * len;
        if (result > max) {
            result -= len;
        }
        if (result < min) {
            result += len;
        }
        return result;
    }

    private static final List<Double> getOrigins$getOrigins(DoubleSpan objRange, DoubleSpan mapRange, DoubleSpan viewRange, boolean loop) {
        if (!loop) {
            return objRange.connected(viewRange) ? CollectionsKt.listOf((Object)objRange.getLowerEnd()) : CollectionsKt.emptyList();
        }
        double mapRangeLen = mapRange.getLength();
        int n = (int)Math.floor((viewRange.getLowerEnd() - mapRange.getLowerEnd()) / mapRangeLen);
        double origin = mapRange.getLowerEnd() + (double)n * mapRangeLen + objRange.getLowerEnd();
        if (origin + objRange.getLength() < viewRange.getLowerEnd()) {
            origin += mapRangeLen;
        }
        ArrayList<Double> result = new ArrayList<Double>();
        while (origin < viewRange.getUpperEnd()) {
            result.add(origin);
            origin += mapRangeLen;
        }
        return result;
    }

    private static final List<DoubleSpan> splitRect$splitRange(DoubleSpan range, DoubleSpan mapRange, boolean loop) {
        ArrayList<DoubleSpan> xRanges = new ArrayList<DoubleSpan>();
        double lower = range.getLowerEnd();
        double upper = range.getUpperEnd();
        if (lower < mapRange.getLowerEnd()) {
            if (loop && upper < mapRange.getUpperEnd()) {
                double newLeft = Math.max(lower + mapRange.getLength(), upper);
                xRanges.add(new DoubleSpan(newLeft, mapRange.getUpperEnd().doubleValue()));
            }
            lower = mapRange.getLowerEnd();
        }
        if (mapRange.getUpperEnd() < upper) {
            if (loop && mapRange.getLowerEnd() < lower) {
                double newRight = Math.min(upper - mapRange.getLength(), lower);
                xRanges.add(new DoubleSpan(mapRange.getLowerEnd().doubleValue(), newRight));
            }
            upper = mapRange.getUpperEnd();
        }
        xRanges.add(new DoubleSpan(lower, upper));
        return xRanges;
    }
}

