/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.FunctionsKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.livemap.LiveMapLocation;
import org.jetbrains.letsPlot.livemap.core.BusyStateComponent;
import org.jetbrains.letsPlot.livemap.core.Clipboard;
import org.jetbrains.letsPlot.livemap.core.ecs.AbstractSystem;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.core.graphics.Attribution;
import org.jetbrains.letsPlot.livemap.core.graphics.Button;
import org.jetbrains.letsPlot.livemap.core.graphics.Image;
import org.jetbrains.letsPlot.livemap.core.graphics.RenderBox;
import org.jetbrains.letsPlot.livemap.core.graphics.Spinner;
import org.jetbrains.letsPlot.livemap.core.input.InputMouseEvent;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputComponent;
import org.jetbrains.letsPlot.livemap.core.layers.CanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.LayerKind;
import org.jetbrains.letsPlot.livemap.core.layers.LayerManager;
import org.jetbrains.letsPlot.livemap.makegeometrywidget.MakeGeometryWidgetComponent;
import org.jetbrains.letsPlot.livemap.makegeometrywidget.MakeGeometryWidgetUtilsKt;
import org.jetbrains.letsPlot.livemap.mapengine.LayerEntitiesComponent;
import org.jetbrains.letsPlot.livemap.mapengine.LiveMapContext;
import org.jetbrains.letsPlot.livemap.mapengine.camera.Camera;
import org.jetbrains.letsPlot.livemap.mapengine.viewport.Viewport;
import org.jetbrains.letsPlot.livemap.ui.LiveMapUiSystem;
import org.jetbrains.letsPlot.livemap.ui.ResourceManager;
import org.jetbrains.letsPlot.livemap.ui.UiService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004()*+BS\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014J\b\u0010!\u001a\u00020\fH\u0002J\b\u0010\"\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0002H\u0014J\u0018\u0010%\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'H\u0014R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem;", "Lorg/jetbrains/letsPlot/livemap/core/ecs/AbstractSystem;", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "uiService", "Lorg/jetbrains/letsPlot/livemap/ui/UiService;", "myResourceManager", "Lorg/jetbrains/letsPlot/livemap/ui/ResourceManager;", "componentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "myMapLocationConsumer", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "", "myLayerManager", "Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;", "myAttribution", "", "showCoordPickTools", "", "showResetPositionAction", "(Lorg/jetbrains/letsPlot/livemap/ui/UiService;Lorg/jetbrains/letsPlot/livemap/ui/ResourceManager;Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/letsPlot/livemap/core/layers/LayerManager;Ljava/lang/String;ZZ)V", "myCamera", "Lorg/jetbrains/letsPlot/livemap/mapengine/camera/Camera;", "myLiveMapLocation", "Lorg/jetbrains/letsPlot/livemap/LiveMapLocation;", "myMakeGeometryButton", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Button;", "mySpinner", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Spinner;", "myUiState", "Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$UiState;", "myViewport", "Lorg/jetbrains/letsPlot/livemap/mapengine/viewport/Viewport;", "activateCreateWidget", "finishDrawing", "initImpl", "context", "updateImpl", "dt", "", "Companion", "Processing", "ResourcesLoading", "UiState", "livemap"})
@SourceDebugExtension(value={"SMAP\nLiveMapUiSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapUiSystem.kt\norg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,270:1\n24#2,2:271\n24#2,2:273\n24#2,2:278\n1#3:275\n1313#4,2:276\n*S KotlinDebug\n*F\n+ 1 LiveMapUiSystem.kt\norg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem\n*L\n71#1:271,2\n73#1:273,2\n77#1:278,2\n75#1:276,2\n*E\n"})
public final class LiveMapUiSystem
extends AbstractSystem<LiveMapContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UiService uiService;
    @NotNull
    private final ResourceManager myResourceManager;
    @NotNull
    private final Function1<DoubleRectangle, Unit> myMapLocationConsumer;
    @NotNull
    private final LayerManager myLayerManager;
    @Nullable
    private final String myAttribution;
    private final boolean showCoordPickTools;
    private final boolean showResetPositionAction;
    private Camera myCamera;
    private Button myMakeGeometryButton;
    private Spinner mySpinner;
    private LiveMapLocation myLiveMapLocation;
    private Viewport myViewport;
    @NotNull
    private UiState myUiState;
    private static final double iconSide = 26.0;
    @NotNull
    private static final DoubleVector iconSize = new DoubleVector(26.0, 26.0);

    public LiveMapUiSystem(@NotNull UiService uiService, @NotNull ResourceManager myResourceManager, @NotNull EcsComponentManager componentManager, @NotNull Function1<? super DoubleRectangle, Unit> myMapLocationConsumer, @NotNull LayerManager myLayerManager, @Nullable String myAttribution, boolean showCoordPickTools, boolean showResetPositionAction) {
        Intrinsics.checkNotNullParameter((Object)uiService, (String)"uiService");
        Intrinsics.checkNotNullParameter((Object)myResourceManager, (String)"myResourceManager");
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter(myMapLocationConsumer, (String)"myMapLocationConsumer");
        Intrinsics.checkNotNullParameter((Object)myLayerManager, (String)"myLayerManager");
        super(componentManager);
        this.uiService = uiService;
        this.myResourceManager = myResourceManager;
        this.myMapLocationConsumer = myMapLocationConsumer;
        this.myLayerManager = myLayerManager;
        this.myAttribution = myAttribution;
        this.showCoordPickTools = showCoordPickTools;
        this.showResetPositionAction = showResetPositionAction;
        this.myUiState = new ResourcesLoading();
    }

    @Override
    protected void updateImpl(@NotNull LiveMapContext context, double dt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.myUiState.update$livemap(context);
    }

    @Override
    protected void initImpl(@NotNull LiveMapContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.myViewport = context.getMapRenderContext().getViewport();
        this.myCamera = context.getCamera();
        Viewport viewport = this.myViewport;
        if (viewport == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
            viewport = null;
        }
        this.myLiveMapLocation = new LiveMapLocation(viewport, context.getMapProjection());
    }

    private final void finishDrawing() {
        EcsEntity widget;
        EcsEntity this_$iv = widget = this.getSingletonEntity((KClass<EcsComponent>)Reflection.getOrCreateKotlinClass(MakeGeometryWidgetComponent.class));
        boolean $i$f$get = false;
        EcsComponent ecsComponent = (MakeGeometryWidgetComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(MakeGeometryWidgetComponent.class));
        if (ecsComponent == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(MakeGeometryWidgetComponent.class).getSimpleName() + " is not found");
        }
        Clipboard.INSTANCE.copy(MakeGeometryWidgetUtilsKt.createFormattedGeometryString(((MakeGeometryWidgetComponent)ecsComponent).getPoints()));
        this_$iv = widget;
        $i$f$get = false;
        EcsComponent ecsComponent2 = (LayerEntitiesComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(LayerEntitiesComponent.class));
        if (ecsComponent2 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(LayerEntitiesComponent.class).getSimpleName() + " is not found");
        }
        Collection<Integer> p0 = ((LayerEntitiesComponent)ecsComponent2).getEntities();
        boolean bl = false;
        Sequence<EcsEntity> $this$forEach$iv = this.getEntitiesById(p0);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EcsEntity it = (EcsEntity)element$iv;
            boolean bl2 = false;
            it.remove();
        }
        this_$iv = widget;
        $i$f$get = false;
        EcsComponent ecsComponent3 = (CanvasLayerComponent)this_$iv.getComponentManager().getComponents(this_$iv).get(Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class));
        if (ecsComponent3 == null) {
            throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(CanvasLayerComponent.class).getSimpleName() + " is not found");
        }
        this.myLayerManager.removeLayer(((CanvasLayerComponent)ecsComponent3).getCanvasLayer());
        widget.remove();
    }

    private final void activateCreateWidget() {
        EcsEntityKt.addComponents(this.createEntity("make_geometry_widget"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this){
            final /* synthetic */ LiveMapUiSystem this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                $this$addComponents.unaryPlus(LiveMapUiSystem.access$getMyLayerManager$p(this.this$0).addLayer("make_geometry_layer", LayerKind.FEATURES));
                $this$addComponents.unaryPlus(new LayerEntitiesComponent());
                $this$addComponents.unaryPlus(new MouseInputComponent());
                $this$addComponents.unaryPlus(new MakeGeometryWidgetComponent());
            }
        }));
    }

    public static final /* synthetic */ LayerManager access$getMyLayerManager$p(LiveMapUiSystem $this) {
        return $this.myLayerManager;
    }

    public static final /* synthetic */ Camera access$getMyCamera$p(LiveMapUiSystem $this) {
        return $this.myCamera;
    }

    public static final /* synthetic */ LiveMapLocation access$getMyLiveMapLocation$p(LiveMapUiSystem $this) {
        return $this.myLiveMapLocation;
    }

    public static final /* synthetic */ Function1 access$getMyMapLocationConsumer$p(LiveMapUiSystem $this) {
        return $this.myMapLocationConsumer;
    }

    public static final /* synthetic */ void access$finishDrawing(LiveMapUiSystem $this) {
        $this.finishDrawing();
    }

    public static final /* synthetic */ void access$activateCreateWidget(LiveMapUiSystem $this) {
        $this.activateCreateWidget();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$Companion;", "", "()V", "iconSide", "", "iconSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "livemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J@\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u001a\b\u0002\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000f0\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0002J\u0015\u0010#\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020\u000fH\u0002J\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$Processing;", "Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$UiState;", "(Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem;)V", "myGetCenterButton", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Button;", "myResetPositionButton", "myZoomMinusButton", "myZoomPlusButton", "shouldShowResetPosition", "", "shouldShowSpinner", "verticalPanel", "", "Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", "initialize", "", "context", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "loadIcon", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Image;", "key", "", "dim", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "newAttribution", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Attribution;", "newButton", "name", "enabledVisualKey", "disabledVisualKey", "clickHandler", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/livemap/core/input/InputMouseEvent;", "newSpinner", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Spinner;", "update", "update$livemap", "updateVerticalPanel", "updateZoomButtons", "zoom", "", "livemap"})
    @SourceDebugExtension(value={"SMAP\nLiveMapUiSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapUiSystem.kt\norg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$Processing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EcsComponentManager.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1855#2,2:271\n1855#2,2:273\n1855#2,2:275\n152#3:277\n1#4:278\n*S KotlinDebug\n*F\n+ 1 LiveMapUiSystem.kt\norg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$Processing\n*L\n177#1:271,2\n198#1:273,2\n204#1:275,2\n213#1:277\n*E\n"})
    private final class Processing
    extends UiState {
        private boolean shouldShowSpinner;
        private boolean shouldShowResetPosition;
        @NotNull
        private final List<RenderBox> verticalPanel = new ArrayList();
        private Button myZoomPlusButton;
        private Button myZoomMinusButton;
        private Button myResetPositionButton;
        private Button myGetCenterButton;

        public final void initialize(@NotNull LiveMapContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            LiveMapUiSystem.this.mySpinner = this.newSpinner();
            this.myZoomPlusButton = this.newButton("zoom_plus", "img_plus", "img_plus_disable", (Function2<? super Button, ? super InputMouseEvent, Unit>)((Function2)new Function2<Button, InputMouseEvent, Unit>(LiveMapUiSystem.this){
                final /* synthetic */ LiveMapUiSystem this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull Button button, @NotNull InputMouseEvent inputMouseEvent) {
                    Camera camera2;
                    Intrinsics.checkNotNullParameter((Object)button, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)inputMouseEvent, (String)"<anonymous parameter 1>");
                    Camera camera3 = LiveMapUiSystem.access$getMyCamera$p(this.this$0);
                    if (camera3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myCamera");
                        camera3 = null;
                    }
                    if ((camera2 = LiveMapUiSystem.access$getMyCamera$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myCamera");
                        camera2 = null;
                    }
                    Double d = camera2.getZoom() + 1.0;
                    Viewport viewport = LiveMapUiSystem.access$getMyViewport$p(this.this$0);
                    if (viewport == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                        viewport = null;
                    }
                    camera3.animate(d, viewport.getPosition());
                }
            }));
            this.myZoomMinusButton = this.newButton("zoom_minus", "img_minus", "img_minus_disable", (Function2<? super Button, ? super InputMouseEvent, Unit>)((Function2)new Function2<Button, InputMouseEvent, Unit>(LiveMapUiSystem.this){
                final /* synthetic */ LiveMapUiSystem this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull Button button, @NotNull InputMouseEvent inputMouseEvent) {
                    Camera camera2;
                    Intrinsics.checkNotNullParameter((Object)button, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)inputMouseEvent, (String)"<anonymous parameter 1>");
                    Camera camera3 = LiveMapUiSystem.access$getMyCamera$p(this.this$0);
                    if (camera3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myCamera");
                        camera3 = null;
                    }
                    if ((camera2 = LiveMapUiSystem.access$getMyCamera$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myCamera");
                        camera2 = null;
                    }
                    Double d = camera2.getZoom() - 1.0;
                    Viewport viewport = LiveMapUiSystem.access$getMyViewport$p(this.this$0);
                    if (viewport == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                        viewport = null;
                    }
                    camera3.animate(d, viewport.getPosition());
                }
            }));
            this.myResetPositionButton = Processing.newButton$default(this, "reset_position", "img_reset_position", null, (Function2)new Function2<Button, InputMouseEvent, Unit>(LiveMapUiSystem.this){
                final /* synthetic */ LiveMapUiSystem this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull Button button, @NotNull InputMouseEvent inputMouseEvent) {
                    Intrinsics.checkNotNullParameter((Object)button, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)inputMouseEvent, (String)"<anonymous parameter 1>");
                    Camera camera2 = LiveMapUiSystem.access$getMyCamera$p(this.this$0);
                    if (camera2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myCamera");
                        camera2 = null;
                    }
                    camera2.reset();
                }
            }, 4, null);
            this.myGetCenterButton = Processing.newButton$default(this, "get_map_position", "img_get_center", null, (Function2)new Function2<Button, InputMouseEvent, Unit>(LiveMapUiSystem.this){
                final /* synthetic */ LiveMapUiSystem this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull Button button, @NotNull InputMouseEvent inputMouseEvent) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)button, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)inputMouseEvent, (String)"<anonymous parameter 1>");
                        LiveMapLocation liveMapLocation = LiveMapUiSystem.access$getMyLiveMapLocation$p(this.this$0);
                        if (liveMapLocation == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"myLiveMapLocation");
                            liveMapLocation = null;
                        }
                        DoubleRectangle doubleRectangle = liveMapLocation.getViewLonLatRect();
                        if (doubleRectangle == null) break block1;
                        DoubleRectangle doubleRectangle2 = doubleRectangle;
                        LiveMapUiSystem liveMapUiSystem = this.this$0;
                        DoubleRectangle it = doubleRectangle2;
                        boolean bl = false;
                        LiveMapUiSystem.access$getMyMapLocationConsumer$p(liveMapUiSystem).invoke((Object)it);
                    }
                }
            }, 4, null);
            LiveMapUiSystem.this.myMakeGeometryButton = Processing.newButton$default(this, "path_painter", "img_create_geometry", null, (Function2)new Function2<Button, InputMouseEvent, Unit>(LiveMapUiSystem.this, this){
                final /* synthetic */ LiveMapUiSystem this$0;
                final /* synthetic */ Processing this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2);
                }

                public final void invoke(@NotNull Button source, @NotNull InputMouseEvent inputMouseEvent) {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)inputMouseEvent, (String)"<anonymous parameter 1>");
                    if (this.this$0.containsEntity((KClass<EcsComponent>)Reflection.getOrCreateKotlinClass(MakeGeometryWidgetComponent.class))) {
                        LiveMapUiSystem.access$finishDrawing(this.this$0);
                        source.setEnabledVisual(Processing.loadIcon$default(this.this$1, "img_create_geometry", null, 2, null));
                    } else {
                        LiveMapUiSystem.access$activateCreateWidget(this.this$0);
                        source.setEnabledVisual(Processing.loadIcon$default(this.this$1, "img_create_geometry_active", null, 2, null));
                    }
                }
            }, 4, null);
            if (LiveMapUiSystem.this.myAttribution != null) {
                Attribution attribution = this.newAttribution();
                LiveMapUiSystem liveMapUiSystem = LiveMapUiSystem.this;
                Attribution $this$initialize_u24lambda_u240 = attribution;
                boolean bl = false;
                $this$initialize_u24lambda_u240.setText(liveMapUiSystem.myAttribution);
                Viewport viewport = liveMapUiSystem.myViewport;
                if (viewport == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                    viewport = null;
                }
                $this$initialize_u24lambda_u240.setOrigin(FunctionsKt.toDoubleVector(viewport.getSize()));
                $this$initialize_u24lambda_u240.setBackground(new Color(200, 200, 200, 179));
                $this$initialize_u24lambda_u240.setPadding(2.0);
                $this$initialize_u24lambda_u240.setHorizontalAlignment(Attribution.Alignment.HorizontalAlignment.LEFT);
                $this$initialize_u24lambda_u240.setVerticalAlignment(Attribution.Alignment.VerticalAlignment.BOTTOM);
                Attribution attribution2 = attribution;
                LiveMapUiSystem.this.uiService.addToRenderer(attribution2);
            }
            this.updateVerticalPanel();
            this.updateZoomButtons(context.getCamera().getZoom());
        }

        private final void updateVerticalPanel() {
            RenderBox p0;
            Iterable $this$forEach$iv;
            Iterable iterable = this.verticalPanel;
            UiService uiService = LiveMapUiSystem.this.uiService;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (RenderBox)element$iv;
                boolean bl = false;
                uiService.removeFromRenderer(p0);
            }
            this.verticalPanel.clear();
            Button button = this.myZoomPlusButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myZoomPlusButton");
                button = null;
            }
            this.verticalPanel.add(button);
            Button button2 = this.myZoomMinusButton;
            if (button2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myZoomMinusButton");
                button2 = null;
            }
            this.verticalPanel.add(button2);
            if (LiveMapUiSystem.this.showResetPositionAction && this.shouldShowResetPosition) {
                Button button3 = this.myResetPositionButton;
                if (button3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myResetPositionButton");
                    button3 = null;
                }
                this.verticalPanel.add(button3);
            }
            if (LiveMapUiSystem.this.showCoordPickTools) {
                Button button4 = this.myGetCenterButton;
                if (button4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myGetCenterButton");
                    button4 = null;
                }
                this.verticalPanel.add(button4);
                Button button5 = LiveMapUiSystem.this.myMakeGeometryButton;
                if (button5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myMakeGeometryButton");
                    button5 = null;
                }
                this.verticalPanel.add(button5);
            }
            if (this.shouldShowSpinner) {
                Spinner spinner = LiveMapUiSystem.this.mySpinner;
                if (spinner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mySpinner");
                    spinner = null;
                }
                spinner.runAnimation();
                Spinner spinner2 = LiveMapUiSystem.this.mySpinner;
                if (spinner2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mySpinner");
                    spinner2 = null;
                }
                this.verticalPanel.add(spinner2);
            } else {
                Spinner spinner = LiveMapUiSystem.this.mySpinner;
                if (spinner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mySpinner");
                    spinner = null;
                }
                spinner.stopAnimation();
            }
            $this$forEach$iv = this.verticalPanel;
            uiService = LiveMapUiSystem.this.uiService;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (RenderBox)element$iv;
                boolean bl = false;
                uiService.addToRenderer(p0);
            }
            double padding = 13.0;
            DoubleVector step = new DoubleVector(0.0, padding + iconSize.getY());
            DoubleVector p = null;
            p = new DoubleVector(padding, padding);
            Iterable $this$forEach$iv2 = this.verticalPanel;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                RenderBox it = (RenderBox)element$iv;
                boolean bl = false;
                it.setOrigin(p);
                p = p.add(step);
            }
            LiveMapUiSystem.this.uiService.repaint();
        }

        @Override
        public void update$livemap(@NotNull LiveMapContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.shouldShowResetPosition = context.getCamera().getCanReset();
            EcsComponentManager this_$iv = LiveMapUiSystem.this.getComponentManager();
            boolean $i$f$containsEntity = false;
            this.shouldShowSpinner = this_$iv.containsEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(BusyStateComponent.class));
            Button button = this.myResetPositionButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myResetPositionButton");
                button = null;
            }
            if (this.shouldShowResetPosition != this.verticalPanel.contains(button)) {
                this.updateVerticalPanel();
            } else {
                Spinner spinner = LiveMapUiSystem.this.mySpinner;
                if (spinner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mySpinner");
                    spinner = null;
                }
                if (this.shouldShowSpinner != this.verticalPanel.contains(spinner)) {
                    this.updateVerticalPanel();
                }
            }
            this.updateZoomButtons(context.getCamera().getZoom());
        }

        public final void updateZoomButtons(double zoom) {
            Viewport viewport;
            Viewport viewport2;
            Button button = this.myZoomPlusButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myZoomPlusButton");
                button = null;
            }
            if ((viewport2 = LiveMapUiSystem.this.myViewport) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                viewport2 = null;
            }
            button.setEnabled(!(zoom == (double)viewport2.getMaxZoom()));
            Button button2 = this.myZoomMinusButton;
            if (button2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myZoomMinusButton");
                button2 = null;
            }
            if ((viewport = LiveMapUiSystem.this.myViewport) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myViewport");
                viewport = null;
            }
            button2.setEnabled(!(zoom == (double)viewport.getMinZoom()));
        }

        private final Image loadIcon(String key, DoubleVector dim) {
            Image image;
            Canvas.Snapshot snapshot = LiveMapUiSystem.this.myResourceManager.get(key);
            LiveMapUiSystem liveMapUiSystem = LiveMapUiSystem.this;
            Canvas.Snapshot it = snapshot;
            boolean bl = false;
            Image $this$loadIcon_u24lambda_u244_u24lambda_u243 = image = new Image();
            boolean bl2 = false;
            $this$loadIcon_u24lambda_u244_u24lambda_u243.attach(liveMapUiSystem.uiService);
            $this$loadIcon_u24lambda_u244_u24lambda_u243.setSnapshot(it);
            $this$loadIcon_u24lambda_u244_u24lambda_u243.setDimension(dim);
            return image;
        }

        static /* synthetic */ Image loadIcon$default(Processing processing, String string, DoubleVector doubleVector, int n, Object object) {
            if ((n & 2) != 0) {
                doubleVector = iconSize;
            }
            return processing.loadIcon(string, doubleVector);
        }

        private final Button newButton(String name, String enabledVisualKey, String disabledVisualKey, Function2<? super Button, ? super InputMouseEvent, Unit> clickHandler) {
            Image image;
            Button button = new Button(name);
            LiveMapUiSystem liveMapUiSystem = LiveMapUiSystem.this;
            Button $this$newButton_u24lambda_u246 = button;
            boolean bl = false;
            $this$newButton_u24lambda_u246.attach(liveMapUiSystem.uiService);
            $this$newButton_u24lambda_u246.setEnabledVisual(Processing.loadIcon$default(this, enabledVisualKey, null, 2, null));
            Button button2 = $this$newButton_u24lambda_u246;
            String string = disabledVisualKey;
            if (string != null) {
                String string2 = string;
                Button button3 = button2;
                boolean bl2 = false;
                image = Processing.loadIcon$default(this, disabledVisualKey, null, 2, null);
                button2 = button3;
            } else {
                image = null;
            }
            button2.setDisabledVisual(image);
            $this$newButton_u24lambda_u246.setDimension(iconSize);
            $this$newButton_u24lambda_u246.setOnDoubleClick((Function1<? super InputMouseEvent, Unit>)((Function1)newButton.2.2.INSTANCE));
            $this$newButton_u24lambda_u246.setOnClick((Function1<? super InputMouseEvent, Unit>)((Function1)new Function1<InputMouseEvent, Unit>(clickHandler, $this$newButton_u24lambda_u246){
                final /* synthetic */ Function2<Button, InputMouseEvent, Unit> $clickHandler;
                final /* synthetic */ Button $this_apply;
                {
                    this.$clickHandler = $clickHandler;
                    this.$this_apply = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull InputMouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    e.stopPropagation();
                    this.$clickHandler.invoke((Object)this.$this_apply, (Object)e);
                }
            }));
            return button;
        }

        static /* synthetic */ Button newButton$default(Processing processing, String string, String string2, String string3, Function2 function2, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                function2 = newButton.1.INSTANCE;
            }
            return processing.newButton(string, string2, string3, (Function2<? super Button, ? super InputMouseEvent, Unit>)function2);
        }

        private final Spinner newSpinner() {
            Spinner spinner = new Spinner();
            LiveMapUiSystem liveMapUiSystem = LiveMapUiSystem.this;
            Spinner $this$newSpinner_u24lambda_u247 = spinner;
            boolean bl = false;
            $this$newSpinner_u24lambda_u247.attach(liveMapUiSystem.uiService);
            $this$newSpinner_u24lambda_u247.setSize(26.0);
            return spinner;
        }

        private final Attribution newAttribution() {
            Attribution attribution = new Attribution();
            LiveMapUiSystem liveMapUiSystem = LiveMapUiSystem.this;
            Attribution $this$newAttribution_u24lambda_u248 = attribution;
            boolean bl = false;
            $this$newAttribution_u24lambda_u248.attach(liveMapUiSystem.uiService);
            return attribution;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$ResourcesLoading;", "Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$UiState;", "(Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem;)V", "update", "", "context", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "update$livemap", "livemap"})
    @SourceDebugExtension(value={"SMAP\nLiveMapUiSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveMapUiSystem.kt\norg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$ResourcesLoading\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
    private final class ResourcesLoading
    extends UiState {
        /*
         * WARNING - void declaration
         */
        @Override
        public void update$livemap(@NotNull LiveMapContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (LiveMapUiSystem.this.myResourceManager.isReady()) {
                void $this$update_u24lambda_u240;
                Processing processing;
                Processing processing2 = processing = new Processing();
                LiveMapUiSystem liveMapUiSystem = LiveMapUiSystem.this;
                boolean bl = false;
                $this$update_u24lambda_u240.initialize(context);
                liveMapUiSystem.myUiState = processing;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H \u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/livemap/ui/LiveMapUiSystem$UiState;", "", "()V", "update", "", "context", "Lorg/jetbrains/letsPlot/livemap/mapengine/LiveMapContext;", "update$livemap", "livemap"})
    public static abstract class UiState {
        public abstract void update$livemap(@NotNull LiveMapContext var1);
    }
}

