/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.livemap.ui;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.livemap.Client;
import org.jetbrains.letsPlot.livemap.core.animation.Animation;
import org.jetbrains.letsPlot.livemap.core.ecs.AnimationObjectComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.ComponentsList;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponent;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsComponentManager;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntity;
import org.jetbrains.letsPlot.livemap.core.ecs.EcsEntityKt;
import org.jetbrains.letsPlot.livemap.core.graphics.Button;
import org.jetbrains.letsPlot.livemap.core.graphics.GraphicsService;
import org.jetbrains.letsPlot.livemap.core.graphics.RenderBox;
import org.jetbrains.letsPlot.livemap.core.graphics.TextMeasurer;
import org.jetbrains.letsPlot.livemap.core.input.ClickableComponent;
import org.jetbrains.letsPlot.livemap.core.input.CursorStyle;
import org.jetbrains.letsPlot.livemap.core.input.CursorStyleComponent;
import org.jetbrains.letsPlot.livemap.core.input.EventListenerComponent;
import org.jetbrains.letsPlot.livemap.core.input.InputMouseEvent;
import org.jetbrains.letsPlot.livemap.core.input.MouseInputComponent;
import org.jetbrains.letsPlot.livemap.core.layers.DirtyCanvasLayerComponent;
import org.jetbrains.letsPlot.livemap.core.layers.ParentLayerComponent;
import org.jetbrains.letsPlot.livemap.core.util.Geometries;
import org.jetbrains.letsPlot.livemap.ui.UiEntitiesRenderingSystem;
import org.jetbrains.letsPlot.livemap.ui.UiRenderComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u001e\u0010&\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00170'H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010)\u001a\u00020\u0017H\u0016J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/livemap/ui/UiService;", "Lorg/jetbrains/letsPlot/livemap/core/graphics/GraphicsService;", "myComponentManager", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;", "textMeasurer", "Lorg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer;", "(Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsComponentManager;Lorg/jetbrains/letsPlot/livemap/core/graphics/TextMeasurer;)V", "addAnimation", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "animation", "Lorg/jetbrains/letsPlot/livemap/core/animation/Animation;", "addButton", "Lorg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity;", "button", "Lorg/jetbrains/letsPlot/livemap/core/graphics/Button;", "addParentLayerComponent", "entity", "renderBox", "Lorg/jetbrains/letsPlot/livemap/core/graphics/RenderBox;", "addRenderable", "name", "", "addToRenderer", "", "obj", "containsElementAtCoord", "", "p", "Lorg/jetbrains/letsPlot/commons/intern/typedGeometry/Vec;", "Lorg/jetbrains/letsPlot/livemap/Client;", "createEntityCleanupRegistration", "defaultCursor", "findEntity", "measure", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "text", "font", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "onClick", "Lkotlin/Function0;", "removeFromRenderer", "repaint", "setCursor", "cursorStyle", "Lorg/jetbrains/letsPlot/livemap/core/input/CursorStyle;", "livemap"})
@SourceDebugExtension(value={"SMAP\nUiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiService.kt\norg/jetbrains/letsPlot/livemap/ui/UiService\n+ 2 EcsEntity.kt\norg/jetbrains/letsPlot/livemap/core/ecs/EcsEntity\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Extensions.kt\norg/jetbrains/letsPlot/livemap/core/ecs/ExtensionsKt\n*L\n1#1,141:1\n71#2:142\n33#2,2:143\n24#2,12:145\n36#2:158\n24#2,2:161\n70#2:165\n24#2,2:169\n1#3:157\n1#3:164\n1#3:166\n29#4,2:159\n32#4:163\n29#4,2:167\n32#4:171\n*S KotlinDebug\n*F\n+ 1 UiService.kt\norg/jetbrains/letsPlot/livemap/ui/UiService\n*L\n32#1:142\n32#1:143,2\n32#1:145,12\n32#1:158\n62#1:161,2\n80#1:165\n133#1:169,2\n32#1:157\n80#1:166\n62#1:159,2\n62#1:163\n133#1:167,2\n133#1:171\n*E\n"})
public final class UiService
implements GraphicsService {
    @NotNull
    private final EcsComponentManager myComponentManager;
    @NotNull
    private final TextMeasurer textMeasurer;

    public UiService(@NotNull EcsComponentManager myComponentManager, @NotNull TextMeasurer textMeasurer) {
        Intrinsics.checkNotNullParameter((Object)myComponentManager, (String)"myComponentManager");
        Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
        this.myComponentManager = myComponentManager;
        this.textMeasurer = textMeasurer;
    }

    @Override
    @NotNull
    public DoubleVector measure(@NotNull String text, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return this.textMeasurer.measure(text, font);
    }

    @Override
    public void repaint() {
        EcsComponent ecsComponent;
        int uiLayerEntityId = this.myComponentManager.getEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(UiEntitiesRenderingSystem.UiLayerComponent.class)).getId$livemap();
        EcsEntity this_$iv = this.myComponentManager.getEntityById(uiLayerEntityId);
        boolean $i$f$tag = false;
        EcsEntity this_$iv$iv = this_$iv;
        boolean $i$f$provide = false;
        if (this_$iv$iv.contains((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(DirtyCanvasLayerComponent.class))) {
            EcsEntity this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$get = false;
            ecsComponent = (DirtyCanvasLayerComponent)this_$iv$iv$iv.getComponentManager().getComponents(this_$iv$iv$iv).get(Reflection.getOrCreateKotlinClass(DirtyCanvasLayerComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(DirtyCanvasLayerComponent.class).getSimpleName() + " is not found");
            }
        } else {
            boolean bl = false;
            DirtyCanvasLayerComponent dirtyCanvasLayerComponent = new DirtyCanvasLayerComponent();
            EcsComponent it$iv$iv = dirtyCanvasLayerComponent;
            boolean bl2 = false;
            this_$iv$iv.add(it$iv$iv);
            ecsComponent = dirtyCanvasLayerComponent;
        }
    }

    @Override
    public void addToRenderer(@NotNull RenderBox obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (!obj.getAttached()) {
            obj.attach(this);
        }
        if (obj instanceof Button) {
            this.addButton((Button)obj);
        } else {
            UiService.addRenderable$default(this, obj, null, 2, null);
        }
    }

    @Override
    @NotNull
    public Registration onClick(@NotNull RenderBox renderBox, @NotNull Function0<Unit> onClick2) {
        Intrinsics.checkNotNullParameter((Object)renderBox, (String)"renderBox");
        Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
        EcsEntity entity2 = EcsEntityKt.addComponents(this.myComponentManager.createEntity("ui_link"), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this, renderBox, onClick2){
            final /* synthetic */ UiService this$0;
            final /* synthetic */ RenderBox $renderBox;
            final /* synthetic */ Function0<Unit> $onClick;
            {
                this.this$0 = $receiver;
                this.$renderBox = $renderBox;
                this.$onClick = $onClick;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                $this$addComponents.unaryPlus(new ParentLayerComponent(UiService.access$getMyComponentManager$p(this.this$0).getEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(UiEntitiesRenderingSystem.UiLayerComponent.class)).getId$livemap()));
                $this$addComponents.unaryPlus(new CursorStyleComponent(CursorStyle.POINTER));
                $this$addComponents.unaryPlus(new ClickableComponent(this.$renderBox));
                $this$addComponents.unaryPlus(new MouseInputComponent());
                EventListenerComponent eventListenerComponent = new EventListenerComponent();
                Function0<Unit> function0 = this.$onClick;
                EventListenerComponent eventListenerComponent2 = eventListenerComponent;
                ComponentsList componentsList = $this$addComponents;
                boolean bl = false;
                $this$invoke_u24lambda_u240.addClickListener((Function1<? super InputMouseEvent, Unit>)((Function1)new Function1<InputMouseEvent, Unit>(function0){
                    final /* synthetic */ Function0<Unit> $onClick;
                    {
                        this.$onClick = $onClick;
                        super(1);
                    }

                    public final void invoke(@NotNull InputMouseEvent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$onClick.invoke();
                    }
                }));
                componentsList.unaryPlus(eventListenerComponent);
            }
        }));
        return this.createEntityCleanupRegistration(entity2);
    }

    /*
     * WARNING - void declaration
     */
    private final EcsEntity findEntity(RenderBox obj) {
        EcsComponentManager $this$onEachEntity$iv = this.myComponentManager;
        boolean $i$f$onEachEntity = false;
        Iterator iterator = $this$onEachEntity$iv.getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(UiRenderComponent.class)).iterator();
        while (iterator.hasNext()) {
            void uiComponent;
            EcsEntity entity$iv;
            EcsEntity this_$iv$iv = entity$iv = (EcsEntity)iterator.next();
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (UiRenderComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(UiRenderComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(UiRenderComponent.class).getSimpleName() + " is not found");
            }
            UiRenderComponent uiRenderComponent = (UiRenderComponent)ecsComponent;
            EcsEntity entity2 = entity$iv;
            boolean bl = false;
            if (uiComponent.getRenderBox$livemap() != obj) continue;
            return entity2;
        }
        return null;
    }

    @Override
    public void removeFromRenderer(@NotNull RenderBox obj) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            EcsEntity ecsEntity = this.findEntity(obj);
            if (ecsEntity == null) break block0;
            EcsEntity ecsEntity2 = ecsEntity;
            EcsComponentManager ecsComponentManager = this.myComponentManager;
            EcsEntity p0 = ecsEntity2;
            boolean bl = false;
            ecsComponentManager.removeEntity$livemap(p0);
        }
    }

    @Override
    public void setCursor(@NotNull RenderBox obj, @NotNull CursorStyle cursorStyle) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            Intrinsics.checkNotNullParameter((Object)((Object)cursorStyle), (String)"cursorStyle");
            EcsEntity ecsEntity = this.findEntity(obj);
            if (ecsEntity == null) break block0;
            ecsEntity.setComponent((EcsComponent)new CursorStyleComponent(cursorStyle));
        }
    }

    @Override
    public void defaultCursor(@NotNull RenderBox obj) {
        block0: {
            EcsEntity ecsEntity;
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            EcsEntity ecsEntity2 = this.findEntity(obj);
            if (ecsEntity2 == null) break block0;
            EcsEntity this_$iv = ecsEntity2;
            boolean $i$f$remove = false;
            EcsEntity $this$remove_u24lambda_u242$iv = ecsEntity = this_$iv;
            boolean bl = false;
            $this$remove_u24lambda_u242$iv.removeComponent((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(CursorStyleComponent.class));
        }
    }

    @Override
    @NotNull
    public Registration addAnimation(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        StringBuilder stringBuilder = new StringBuilder().append("animation_");
        String string = Integer.toString(animation.hashCode(), CharsKt.checkRadix((int)32));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        EcsEntity animationEntity2 = EcsEntityKt.addComponents(this.myComponentManager.createEntity(stringBuilder.append(string).toString()), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(animation){
            final /* synthetic */ Animation $animation;
            {
                this.$animation = $animation;
                super(1);
            }

            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                $this$addComponents.unaryPlus(new AnimationObjectComponent(this.$animation));
            }
        }));
        return this.createEntityCleanupRegistration(animationEntity2);
    }

    private final EcsEntity addRenderable(RenderBox renderBox, String name) {
        return this.addParentLayerComponent(this.myComponentManager.createEntity(name), renderBox);
    }

    static /* synthetic */ EcsEntity addRenderable$default(UiService uiService, RenderBox renderBox, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "ui_renderable";
        }
        return uiService.addRenderable(renderBox, string);
    }

    private final EcsEntity addButton(Button button) {
        return this.addParentLayerComponent(EcsEntityKt.addComponents(this.myComponentManager.createEntity(button.getName()), (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(button){
            final /* synthetic */ Button $button;
            {
                this.$button = $button;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                $this$addComponents.unaryPlus(new CursorStyleComponent(CursorStyle.POINTER));
                $this$addComponents.unaryPlus(new ClickableComponent(this.$button));
                $this$addComponents.unaryPlus(new MouseInputComponent());
                EventListenerComponent eventListenerComponent = new EventListenerComponent();
                Button button = this.$button;
                EventListenerComponent eventListenerComponent2 = eventListenerComponent;
                ComponentsList componentsList = $this$addComponents;
                boolean bl = false;
                $this$invoke_u24lambda_u240.addClickListener((Function1<? super InputMouseEvent, Unit>)((Function1)new Function1<InputMouseEvent, Unit>((Object)button){

                    public final void invoke(@NotNull InputMouseEvent p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((Button)this.receiver).dispatchClick(p0);
                    }
                }));
                $this$invoke_u24lambda_u240.addDoubleClickListener((Function1<? super InputMouseEvent, Unit>)((Function1)new Function1<InputMouseEvent, Unit>((Object)button){

                    public final void invoke(@NotNull InputMouseEvent p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((Button)this.receiver).dispatchDoubleClick(p0);
                    }
                }));
                componentsList.unaryPlus(eventListenerComponent);
            }
        })), button);
    }

    private final EcsEntity addParentLayerComponent(EcsEntity entity2, RenderBox renderBox) {
        return EcsEntityKt.addComponents(entity2, (Function1<? super ComponentsList, Unit>)((Function1)new Function1<ComponentsList, Unit>(this, renderBox){
            final /* synthetic */ UiService this$0;
            final /* synthetic */ RenderBox $renderBox;
            {
                this.this$0 = $receiver;
                this.$renderBox = $renderBox;
                super(1);
            }

            public final void invoke(@NotNull ComponentsList $this$addComponents) {
                Intrinsics.checkNotNullParameter((Object)$this$addComponents, (String)"$this$addComponents");
                $this$addComponents.unaryPlus(new ParentLayerComponent(UiService.access$getMyComponentManager$p(this.this$0).getEntity((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(UiEntitiesRenderingSystem.UiLayerComponent.class)).getId$livemap()));
                $this$addComponents.unaryPlus(new UiRenderComponent(this.$renderBox));
            }
        }));
    }

    private final Registration createEntityCleanupRegistration(EcsEntity entity2) {
        return new Registration(this, entity2){
            final /* synthetic */ UiService this$0;
            final /* synthetic */ EcsEntity $entity;
            {
                this.this$0 = $receiver;
                this.$entity = $entity;
            }

            protected void doRemove() {
                UiService.access$getMyComponentManager$p(this.this$0).removeEntity(this.$entity.getId$livemap());
            }
        };
    }

    public final boolean containsElementAtCoord(@NotNull Vec<? extends Client> p) {
        Intrinsics.checkNotNullParameter(p, (String)"p");
        EcsComponentManager $this$onEachEntity$iv = this.myComponentManager;
        boolean $i$f$onEachEntity = false;
        Iterator iterator = $this$onEachEntity$iv.getEntities((KClass<? extends EcsComponent>)Reflection.getOrCreateKotlinClass(UiRenderComponent.class)).iterator();
        while (iterator.hasNext()) {
            EcsEntity entity$iv;
            EcsEntity this_$iv$iv = entity$iv = (EcsEntity)iterator.next();
            boolean $i$f$get = false;
            EcsComponent ecsComponent = (UiRenderComponent)this_$iv$iv.getComponentManager().getComponents(this_$iv$iv).get(Reflection.getOrCreateKotlinClass(UiRenderComponent.class));
            if (ecsComponent == null) {
                throw new IllegalStateException("Component " + Reflection.getOrCreateKotlinClass(UiRenderComponent.class).getSimpleName() + " is not found");
            }
            UiRenderComponent uiElement = (UiRenderComponent)ecsComponent;
            boolean bl = false;
            if (!Geometries.INSTANCE.inside(p.getX(), p.getY(), uiElement.getOrigin(), uiElement.getDimension())) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ EcsComponentManager access$getMyComponentManager$p(UiService $this) {
        return $this.myComponentManager;
    }
}

