/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.plot;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.awt.plot.AwtLiveMapPanel;
import org.jetbrains.letsPlot.awt.plot.DisposableJPanel;
import org.jetbrains.letsPlot.awt.plot.FigureToAwt;
import org.jetbrains.letsPlot.awt.util.AwtEventUtil;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.registration.DisposingHub;
import org.jetbrains.letsPlot.core.plot.builder.FigureBuildInfo;
import org.jetbrains.letsPlot.core.plot.builder.FigureSvgRoot;
import org.jetbrains.letsPlot.core.plot.builder.PlotContainer;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgRoot;
import org.jetbrains.letsPlot.core.plot.builder.subPlots.CompositeFigureSvgRoot;
import org.jetbrains.letsPlot.core.plot.livemap.CursorServiceConfig;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015BJ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\r0\u0005\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/FigureToAwt;", "", "buildInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/FigureBuildInfo;", "svgComponentFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "Ljavax/swing/JComponent;", "executor", "Lkotlin/Function0;", "", "(Lorg/jetbrains/letsPlot/core/plot/builder/FigureBuildInfo;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "eval", "processCompositeFigure", "svgRoot", "Lorg/jetbrains/letsPlot/core/plot/builder/subPlots/CompositeFigureSvgRoot;", "processPlotFigure", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgRoot;", "Companion", "platf-awt"})
@SourceDebugExtension(value={"SMAP\nFigureToAwt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FigureToAwt.kt\norg/jetbrains/letsPlot/awt/plot/FigureToAwt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1855#2,2:224\n*S KotlinDebug\n*F\n+ 1 FigureToAwt.kt\norg/jetbrains/letsPlot/awt/plot/FigureToAwt\n*L\n118#1:224,2\n*E\n"})
public final class FigureToAwt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FigureBuildInfo buildInfo;
    @NotNull
    private final Function1<SvgSvgElement, JComponent> svgComponentFactory;
    @NotNull
    private final Function1<Function0<Unit>, Unit> executor;

    public FigureToAwt(@NotNull FigureBuildInfo buildInfo, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor) {
        Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.buildInfo = buildInfo;
        this.svgComponentFactory = svgComponentFactory;
        this.executor = executor;
    }

    @NotNull
    public final JComponent eval() {
        JComponent jComponent;
        FigureBuildInfo buildInfo = this.buildInfo.layoutedByOuterSize();
        buildInfo.injectLiveMapProvider((Function2)eval.1.INSTANCE);
        FigureSvgRoot svgRoot = buildInfo.createSvgRoot();
        if (svgRoot instanceof CompositeFigureSvgRoot) {
            jComponent = this.processCompositeFigure((CompositeFigureSvgRoot)svgRoot);
        } else {
            Intrinsics.checkNotNull((Object)svgRoot, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.builder.PlotSvgRoot");
            jComponent = this.processPlotFigure((PlotSvgRoot)svgRoot);
        }
        return jComponent;
    }

    private final JComponent processCompositeFigure(CompositeFigureSvgRoot svgRoot) {
        svgRoot.ensureContentBuilt();
        DisposableJPanel rootJPanel = new DisposableJPanel(null);
        rootJPanel.registerDisposable(new Disposable(svgRoot){
            final /* synthetic */ CompositeFigureSvgRoot $svgRoot;
            {
                this.$svgRoot = $svgRoot;
            }

            public void dispose() {
                this.$svgRoot.clearContent();
            }
        });
        rootJPanel.setBorder(null);
        rootJPanel.setOpaque(false);
        Rectangle rootJComponentBounds = FigureToAwt.processCompositeFigure$toJBounds(new DoubleRectangle(DoubleVector.Companion.getZERO(), svgRoot.getBounds().getDimension()));
        Dimension rootFigureDim = rootJComponentBounds.getSize();
        rootJPanel.setPreferredSize(rootFigureDim);
        rootJPanel.setMinimumSize(rootFigureDim);
        rootJPanel.setMaximumSize(rootFigureDim);
        JComponent rootJComponent = (JComponent)this.svgComponentFactory.invoke((Object)svgRoot.getSvg());
        rootJComponent.setBounds(rootJComponentBounds);
        rootJPanel.add(rootJComponent);
        ArrayList<JComponent> elementJComponents = new ArrayList<JComponent>();
        for (FigureSvgRoot element : svgRoot.getElements()) {
            JComponent comp;
            if (element instanceof PlotSvgRoot) {
                comp = this.processPlotFigure((PlotSvgRoot)element);
                comp.setBounds(FigureToAwt.processCompositeFigure$toJBounds(element.getBounds()));
                elementJComponents.add(comp);
                continue;
            }
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.builder.subPlots.CompositeFigureSvgRoot");
            comp = this.processCompositeFigure((CompositeFigureSvgRoot)element);
            comp.setBounds(FigureToAwt.processCompositeFigure$toJBounds(element.getBounds()));
            elementJComponents.add(comp);
        }
        Iterable $this$forEach$iv = elementJComponents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl = false;
            rootJComponent.add(it);
        }
        return rootJPanel;
    }

    private final JComponent processPlotFigure(PlotSvgRoot svgRoot) {
        JComponent jComponent;
        PlotContainer plotContainer = new PlotContainer(svgRoot);
        JComponent plotComponent = FigureToAwt.Companion.buildSinglePlotComponent(plotContainer, (Function1<? super SvgSvgElement, ? extends JComponent>)this.svgComponentFactory, (Function1<? super Function0<Unit>, Unit>)this.executor);
        if (svgRoot.isLiveMap()) {
            List list = svgRoot.getLiveMapFigures();
            Object object = svgRoot.getLiveMapCursorServiceConfig();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.livemap.CursorServiceConfig");
            jComponent = new AwtLiveMapPanel(list, plotComponent, this.executor, (CursorServiceConfig)object);
        } else {
            jComponent = plotComponent;
        }
        return jComponent;
    }

    private static final Rectangle processCompositeFigure$toJBounds(DoubleRectangle from) {
        return new Rectangle((int)from.getOrigin().getX(), (int)from.getOrigin().getY(), (int)from.getDimension().getX(), (int)from.getDimension().getY());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JM\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00040\b2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u000f0\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/awt/plot/FigureToAwt$Companion;", "", "()V", "buildSinglePlotComponent", "Ljavax/swing/JComponent;", "plotContainer", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotContainer;", "svgComponentFactory", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "executor", "Lkotlin/Function0;", "", "platf-awt"})
    public static final class Companion {
        private Companion() {
        }

        private final JComponent buildSinglePlotComponent(PlotContainer plotContainer, Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, Function1<? super Function0<Unit>, Unit> executor) {
            SvgSvgElement svg = plotContainer.getSvg();
            JComponent plotComponent = (JComponent)svgComponentFactory.invoke((Object)svg);
            Intrinsics.checkNotNull((Object)plotComponent, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.commons.registration.DisposingHub");
            ((DisposingHub)plotComponent).registerDisposable((Disposable)plotContainer);
            plotComponent.addMouseMotionListener(new MouseAdapter(executor, plotContainer){
                final /* synthetic */ Function1<Function0<Unit>, Unit> $executor;
                final /* synthetic */ PlotContainer $plotContainer;
                {
                    this.$executor = $executor;
                    this.$plotContainer = $plotContainer;
                }

                public void mouseMoved(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.mouseMoved(e);
                    this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                        final /* synthetic */ PlotContainer $plotContainer;
                        final /* synthetic */ MouseEvent $e;
                        {
                            this.$plotContainer = $plotContainer;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_MOVED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                        }
                    });
                }

                public void mouseDragged(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.mouseDragged(e);
                    this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                        final /* synthetic */ PlotContainer $plotContainer;
                        final /* synthetic */ MouseEvent $e;
                        {
                            this.$plotContainer = $plotContainer;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_DRAGGED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                        }
                    });
                }
            });
            plotComponent.addMouseListener(new MouseAdapter(executor, plotContainer){
                final /* synthetic */ Function1<Function0<Unit>, Unit> $executor;
                final /* synthetic */ PlotContainer $plotContainer;
                {
                    this.$executor = $executor;
                    this.$plotContainer = $plotContainer;
                }

                public void mouseExited(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.mouseExited(e);
                    this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                        final /* synthetic */ PlotContainer $plotContainer;
                        final /* synthetic */ MouseEvent $e;
                        {
                            this.$plotContainer = $plotContainer;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_LEFT, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                        }
                    });
                }

                public void mouseClicked(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.mouseClicked(e);
                    MouseEventSpec event = e.getClickCount() % 2 == 1 ? MouseEventSpec.MOUSE_CLICKED : MouseEventSpec.MOUSE_DOUBLE_CLICKED;
                    this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, event, e){
                        final /* synthetic */ PlotContainer $plotContainer;
                        final /* synthetic */ MouseEventSpec $event;
                        final /* synthetic */ MouseEvent $e;
                        {
                            this.$plotContainer = $plotContainer;
                            this.$event = $event;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$plotContainer.getMouseEventPeer().dispatch(this.$event, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                        }
                    });
                }

                public void mousePressed(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.mousePressed(e);
                    this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                        final /* synthetic */ PlotContainer $plotContainer;
                        final /* synthetic */ MouseEvent $e;
                        {
                            this.$plotContainer = $plotContainer;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_PRESSED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                        }
                    });
                }

                public void mouseReleased(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.mouseReleased(e);
                    this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                        final /* synthetic */ PlotContainer $plotContainer;
                        final /* synthetic */ MouseEvent $e;
                        {
                            this.$plotContainer = $plotContainer;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_RELEASED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                        }
                    });
                }

                public void mouseEntered(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    super.mouseEntered(e);
                    this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                        final /* synthetic */ PlotContainer $plotContainer;
                        final /* synthetic */ MouseEvent $e;
                        {
                            this.$plotContainer = $plotContainer;
                            this.$e = $e;
                            super(0);
                        }

                        public final void invoke() {
                            this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_ENTERED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                        }
                    });
                }
            });
            return plotComponent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

