/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.util.AwtEventUtil;
import org.jetbrains.letsPlot.commons.event.MouseEventPeer;
import org.jetbrains.letsPlot.commons.event.MouseEventSource;
import org.jetbrains.letsPlot.commons.event.MouseEventSpec;
import org.jetbrains.letsPlot.commons.geometry.Rectangle;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.observable.event.EventHandler;
import org.jetbrains.letsPlot.commons.registration.Registration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u00060\nR\u00020\u00002\n\u0010\t\u001a\u00060\nR\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSource;", "eventSource", "Ljava/awt/Component;", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/Rectangle;", "(Ljava/awt/Component;Lorg/jetbrains/letsPlot/commons/geometry/Rectangle;)V", "mouseEventPeer", "Lorg/jetbrains/letsPlot/commons/event/MouseEventPeer;", "value", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$MouseState;", "state", "setState", "(Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$MouseState;)V", "addEventHandler", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "eventSpec", "Lorg/jetbrains/letsPlot/commons/event/MouseEventSpec;", "eventHandler", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/EventHandler;", "Lorg/jetbrains/letsPlot/commons/event/MouseEvent;", "dispatch", "", "e", "Ljava/awt/event/MouseEvent;", "isHitWithinBounds", "", "event", "AwtMouseEventType", "ButtonDownState", "Dragging", "HoverState", "MouseState", "platf-awt"})
public final class AwtMouseEventMapper
implements MouseEventSource {
    @Nullable
    private final Rectangle bounds;
    @NotNull
    private final MouseEventPeer mouseEventPeer;
    @NotNull
    private MouseState state;

    public AwtMouseEventMapper(@NotNull Component eventSource, @Nullable Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        this.bounds = bounds;
        this.mouseEventPeer = new MouseEventPeer();
        this.state = new HoverState();
        eventSource.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                state.onMouseEvent(AwtMouseEventType.MOUSE_CLICKED, e);
            }

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                state.onMouseEvent(AwtMouseEventType.MOUSE_PRESSED, e);
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                state.onMouseEvent(AwtMouseEventType.MOUSE_RELEASED, e);
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                state.onMouseEvent(AwtMouseEventType.MOUSE_ENTERED, e);
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                state.onMouseEvent(AwtMouseEventType.MOUSE_EXITED, e);
            }
        });
        eventSource.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                state.onMouseEvent(AwtMouseEventType.MOUSE_DRAGGED, e);
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                state.onMouseEvent(AwtMouseEventType.MOUSE_MOVED, e);
            }
        });
        eventSource.addMouseWheelListener(arg_0 -> AwtMouseEventMapper._init_$lambda$0(this, arg_0));
    }

    public /* synthetic */ AwtMouseEventMapper(Component component, Rectangle rectangle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            rectangle = null;
        }
        this(component, rectangle);
    }

    private final void setState(MouseState value) {
        this.state = value;
    }

    private final void dispatch(MouseEventSpec eventSpec, MouseEvent e) {
        Rectangle rectangle = this.bounds;
        if (rectangle == null || (rectangle = rectangle.getOrigin()) == null) {
            rectangle = Vector.Companion.getZERO();
        }
        org.jetbrains.letsPlot.commons.event.MouseEvent mouseEvent = AwtEventUtil.INSTANCE.translate(e, (Vector)rectangle);
        this.mouseEventPeer.dispatch(eventSpec, mouseEvent);
    }

    private final boolean isHitWithinBounds(MouseEvent event) {
        Rectangle rectangle = this.bounds;
        return rectangle != null ? rectangle.contains(new Vector(event.getX(), event.getY())) : true;
    }

    @NotNull
    public Registration addEventHandler(@NotNull MouseEventSpec eventSpec, @NotNull EventHandler<? super org.jetbrains.letsPlot.commons.event.MouseEvent> eventHandler) {
        Intrinsics.checkNotNullParameter((Object)eventSpec, (String)"eventSpec");
        Intrinsics.checkNotNullParameter(eventHandler, (String)"eventHandler");
        return this.mouseEventPeer.addEventHandler(eventSpec, eventHandler);
    }

    @NotNull
    public Registration on(@NotNull MouseEventSpec eventSpec, @NotNull Function1<? super org.jetbrains.letsPlot.commons.event.MouseEvent, Unit> eventHandler) {
        return MouseEventSource.DefaultImpls.on((MouseEventSource)this, (MouseEventSpec)eventSpec, eventHandler);
    }

    private static final void _init_$lambda$0(AwtMouseEventMapper this$0, MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)e);
        MouseEvent mouseEvent = e;
        Rectangle rectangle = this$0.bounds;
        if (rectangle == null || (rectangle = rectangle.getOrigin()) == null) {
            rectangle = Vector.Companion.getZERO();
        }
        org.jetbrains.letsPlot.commons.event.MouseEvent mouseEvent2 = AwtEventUtil.INSTANCE.translate(mouseEvent, (Vector)rectangle);
        this$0.mouseEventPeer.dispatch(MouseEventSpec.MOUSE_WHEEL_ROTATED, mouseEvent2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$AwtMouseEventType;", "", "(Ljava/lang/String;I)V", "MOUSE_CLICKED", "MOUSE_PRESSED", "MOUSE_RELEASED", "MOUSE_ENTERED", "MOUSE_EXITED", "MOUSE_DRAGGED", "MOUSE_MOVED", "MOUSE_WHEEL_ROTATED", "platf-awt"})
    private static final class AwtMouseEventType
    extends Enum<AwtMouseEventType> {
        public static final /* enum */ AwtMouseEventType MOUSE_CLICKED = new AwtMouseEventType();
        public static final /* enum */ AwtMouseEventType MOUSE_PRESSED = new AwtMouseEventType();
        public static final /* enum */ AwtMouseEventType MOUSE_RELEASED = new AwtMouseEventType();
        public static final /* enum */ AwtMouseEventType MOUSE_ENTERED = new AwtMouseEventType();
        public static final /* enum */ AwtMouseEventType MOUSE_EXITED = new AwtMouseEventType();
        public static final /* enum */ AwtMouseEventType MOUSE_DRAGGED = new AwtMouseEventType();
        public static final /* enum */ AwtMouseEventType MOUSE_MOVED = new AwtMouseEventType();
        public static final /* enum */ AwtMouseEventType MOUSE_WHEEL_ROTATED = new AwtMouseEventType();
        private static final /* synthetic */ AwtMouseEventType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AwtMouseEventType[] values() {
            return (AwtMouseEventType[])$VALUES.clone();
        }

        public static AwtMouseEventType valueOf(String value) {
            return Enum.valueOf(AwtMouseEventType.class, value);
        }

        @NotNull
        public static EnumEntries<AwtMouseEventType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = awtMouseEventTypeArray = new AwtMouseEventType[]{AwtMouseEventType.MOUSE_CLICKED, AwtMouseEventType.MOUSE_PRESSED, AwtMouseEventType.MOUSE_RELEASED, AwtMouseEventType.MOUSE_ENTERED, AwtMouseEventType.MOUSE_EXITED, AwtMouseEventType.MOUSE_DRAGGED, AwtMouseEventType.MOUSE_MOVED, AwtMouseEventType.MOUSE_WHEEL_ROTATED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$ButtonDownState;", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$MouseState;", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;", "(Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;)V", "handleEvent", "", "type", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$AwtMouseEventType;", "e", "Ljava/awt/event/MouseEvent;", "platf-awt"})
    private final class ButtonDownState
    extends MouseState {
        public ButtonDownState() {
            super(AwtMouseEventMapper.this, "ButtonDownState", false, 2, null);
        }

        @Override
        public void handleEvent(@NotNull AwtMouseEventType type, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_RELEASED, e);
                    break;
                }
                case 2: {
                    switch (e.getClickCount()) {
                        case 1: {
                            AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_CLICKED, e);
                            break;
                        }
                        case 2: {
                            AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_DOUBLE_CLICKED, e);
                        }
                    }
                    AwtMouseEventMapper.this.setState(new HoverState());
                    break;
                }
                case 3: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_DRAGGED, e);
                    AwtMouseEventMapper.this.setState(new Dragging());
                    break;
                }
                default: {
                    AwtMouseEventMapper.this.setState(new HoverState());
                    throw new IllegalStateException(("ButtonDownState: unexpected event - " + (Object)((Object)type)).toString());
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AwtMouseEventType.values().length];
                try {
                    nArray[AwtMouseEventType.MOUSE_RELEASED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_CLICKED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_DRAGGED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$Dragging;", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$MouseState;", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;", "(Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;)V", "handleEvent", "", "type", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$AwtMouseEventType;", "e", "Ljava/awt/event/MouseEvent;", "platf-awt"})
    private final class Dragging
    extends MouseState {
        public Dragging() {
            super(AwtMouseEventMapper.this, "Dragging", true);
        }

        @Override
        public void handleEvent(@NotNull AwtMouseEventType type, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_DRAGGED, e);
                    break;
                }
                case 2: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_RELEASED, e);
                    AwtMouseEventMapper.this.setState(new HoverState());
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    AwtMouseEventMapper.this.setState(new HoverState());
                    throw new IllegalStateException(("Dragging: unexpected event - " + (Object)((Object)type)).toString());
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AwtMouseEventType.values().length];
                try {
                    nArray[AwtMouseEventType.MOUSE_DRAGGED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_RELEASED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_ENTERED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_EXITED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$HoverState;", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$MouseState;", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;", "(Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;)V", "handleEvent", "", "type", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$AwtMouseEventType;", "e", "Ljava/awt/event/MouseEvent;", "platf-awt"})
    private final class HoverState
    extends MouseState {
        public HoverState() {
            super(AwtMouseEventMapper.this, "HoverState", false, 2, null);
        }

        @Override
        public void handleEvent(@NotNull AwtMouseEventType type, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_PRESSED, e);
                    AwtMouseEventMapper.this.setState(new ButtonDownState());
                    break;
                }
                case 2: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_MOVED, e);
                    break;
                }
                case 3: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_LEFT, e);
                    break;
                }
                case 4: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_ENTERED, e);
                    break;
                }
                case 5: {
                    AwtMouseEventMapper.this.dispatch(MouseEventSpec.MOUSE_WHEEL_ROTATED, e);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AwtMouseEventType.values().length];
                try {
                    nArray[AwtMouseEventType.MOUSE_PRESSED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_MOVED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_EXITED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_ENTERED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_WHEEL_ROTATED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_DRAGGED.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_RELEASED.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AwtMouseEventType.MOUSE_CLICKED.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0003J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$MouseState;", "", "name", "", "canHandleOutsideOfBounds", "", "(Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper;Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "handleEvent", "", "type", "Lorg/jetbrains/letsPlot/awt/canvas/AwtMouseEventMapper$AwtMouseEventType;", "e", "Ljava/awt/event/MouseEvent;", "log", "str", "onMouseEvent", "platf-awt"})
    private abstract class MouseState {
        @NotNull
        private final String name;
        private final boolean canHandleOutsideOfBounds;
        final /* synthetic */ AwtMouseEventMapper this$0;

        public MouseState(@NotNull AwtMouseEventMapper this$0, String name, boolean canHandleOutsideOfBounds) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.this$0 = this$0;
            this.name = name;
            this.canHandleOutsideOfBounds = canHandleOutsideOfBounds;
        }

        public /* synthetic */ MouseState(AwtMouseEventMapper awtMouseEventMapper, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(awtMouseEventMapper, string, bl);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void onMouseEvent(@NotNull AwtMouseEventType type, @NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.canHandleOutsideOfBounds || this.this$0.isHitWithinBounds(e)) {
                this.log(type.name());
                this.handleEvent(type, e);
            }
        }

        public abstract void handleEvent(@NotNull AwtMouseEventType var1, @NotNull MouseEvent var2);

        public final void log(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        }
    }
}

