/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.batik.mapping.svg;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.dom.SVGOMTextContentElement;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.batik.mapping.svg.SvgNodeMapper;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.datamodel.mapping.framework.Mapper;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLocatable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPlatformPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextContent;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGTransformable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J&\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0016\u0010 \u001a\u0012\u0012\u0006\b\u0001\u0012\u00020\u0005\u0012\u0006\b\u0001\u0012\u00020\u00070!J \u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005RJ\u0010\u0003\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0005\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004j\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0005\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/batik/mapping/svg/SvgBatikPeer;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPlatformPeer;", "()V", "myMappingMap", "Ljava/util/HashMap;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "Lorg/jetbrains/letsPlot/datamodel/mapping/framework/Mapper;", "Lorg/w3c/dom/Node;", "Lkotlin/collections/HashMap;", "applyTransform", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "relative", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgLocatable;", "point", "ensureElementConsistency", "", "source", "target", "ensureLocatableConsistency", "ensureSourceRegistered", "ensureSourceTargetConsistency", "ensureTextContentConsistency", "ensureTransformableConsistency", "getBBox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "element", "getComputedTextLength", "", "node", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextContent;", "invertTransform", "registerMapper", "mapper", "Lorg/jetbrains/letsPlot/batik/mapping/svg/SvgNodeMapper;", "transformCoordinates", "inverse", "", "unregisterMapper", "platf-batik"})
public final class SvgBatikPeer
implements SvgPlatformPeer {
    @NotNull
    private final HashMap<SvgNode, Mapper<? extends SvgNode, ? extends Node>> myMappingMap = new HashMap();

    private final void ensureElementConsistency(SvgNode source, Node target) {
        if (source instanceof SvgElement && !(target instanceof SVGOMElement)) {
            throw new IllegalStateException("Target of SvgElement must be SVGOMElement");
        }
    }

    private final void ensureLocatableConsistency(SvgNode source, Node target) {
        if (source instanceof SvgLocatable && !(target instanceof SVGLocatable)) {
            throw new IllegalStateException("Target of SvgLocatable must be SVGLocatable");
        }
    }

    private final void ensureTextContentConsistency(SvgNode source, Node target) {
        if (source instanceof SvgTextContent && !(target instanceof SVGOMTextContentElement)) {
            throw new IllegalStateException("Target of SvgTextContent must be SVGOMTextContentElement");
        }
    }

    private final void ensureTransformableConsistency(SvgNode source, Node target) {
        if (source instanceof SvgTransformable && !(target instanceof SVGTransformable)) {
            throw new IllegalStateException("Target of SvgTransformable must be SVGTransformable");
        }
    }

    private final void ensureSourceTargetConsistency(SvgNode source, Node target) {
        this.ensureElementConsistency(source, target);
        this.ensureLocatableConsistency(source, target);
        this.ensureTextContentConsistency(source, target);
        this.ensureTransformableConsistency(source, target);
    }

    private final void ensureSourceRegistered(SvgNode source) {
        if (!this.myMappingMap.containsKey(source)) {
            throw new IllegalStateException("Trying to call platform peer method of unmapped node");
        }
    }

    public final void registerMapper(@NotNull SvgNode source, @NotNull SvgNodeMapper<? extends SvgNode, ? extends Node> mapper) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.ensureSourceTargetConsistency(source, (Node)mapper.getTarget());
        ((Map)this.myMappingMap).put(source, mapper);
    }

    public final void unregisterMapper(@NotNull SvgNode source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.myMappingMap.remove(source);
    }

    public double getComputedTextLength(@NotNull SvgTextContent node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.ensureSourceRegistered((SvgNode)node);
        Mapper<? extends SvgNode, ? extends Node> mapper = this.myMappingMap.get(node);
        Intrinsics.checkNotNull(mapper);
        Node target = (Node)mapper.getTarget();
        Intrinsics.checkNotNull((Object)target, (String)"null cannot be cast to non-null type org.apache.batik.anim.dom.SVGOMTextContentElement");
        return ((SVGOMTextContentElement)target).getComputedTextLength();
    }

    private final DoubleVector transformCoordinates(SvgLocatable relative, DoubleVector point, boolean inverse) {
        Intrinsics.checkNotNull((Object)relative, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode");
        this.ensureSourceRegistered((SvgNode)relative);
        Mapper<? extends SvgNode, ? extends Node> mapper = this.myMappingMap.get(relative);
        Intrinsics.checkNotNull(mapper);
        Node relativeTarget = (Node)mapper.getTarget();
        Intrinsics.checkNotNull((Object)relativeTarget, (String)"null cannot be cast to non-null type org.w3c.dom.svg.SVGLocatable");
        SVGMatrix matrix = ((SVGLocatable)relativeTarget).getTransformToElement((SVGElement)((SVGOMElement)relativeTarget).getOwnerSVGElement());
        if (inverse) {
            matrix = matrix.inverse();
        }
        SVGOMPoint pt = new SVGOMPoint((float)point.getX(), (float)point.getY());
        SVGPoint inversePt = pt.matrixTransform(matrix);
        return new DoubleVector((double)inversePt.getX(), (double)inversePt.getY());
    }

    @NotNull
    public DoubleVector invertTransform(@NotNull SvgLocatable relative, @NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.transformCoordinates(relative, point, true);
    }

    @NotNull
    public DoubleVector applyTransform(@NotNull SvgLocatable relative, @NotNull DoubleVector point) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.transformCoordinates(relative, point, false);
    }

    @NotNull
    public DoubleRectangle getBBox(@NotNull SvgLocatable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.ensureSourceRegistered((SvgNode)element);
        Mapper<? extends SvgNode, ? extends Node> mapper = this.myMappingMap.get(element);
        Intrinsics.checkNotNull(mapper);
        Node target = (Node)mapper.getTarget();
        Intrinsics.checkNotNull((Object)target, (String)"null cannot be cast to non-null type org.w3c.dom.svg.SVGLocatable");
        SVGRect bBox = ((SVGLocatable)target).getBBox();
        DoubleRectangle bbox = new DoubleRectangle((double)bBox.getX(), (double)bBox.getY(), (double)bBox.getWidth(), (double)bBox.getHeight());
        return bbox;
    }
}

