/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.enums.EnumInfo;
import jetbrains.datalore.base.enums.EnumInfoFactory;
import jetbrains.datalore.base.enums.EnumInfoImpl;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.FilledCircleLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import jetbrains.datalore.plot.base.stat.DotplotStat;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 D2\u00020\u0001:\u0003DEFB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u001aH\u0004J0\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\u0006\u0010'\u001a\u00020\u0004H\u0002J0\u00100\u001a\u00020*2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010%\u001a\u00020&H\u0014J>\u00109\u001a\u00020*2\u0006\u00101\u001a\u0002022\f\u0010:\u001a\b\u0012\u0004\u0012\u00020,0;2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004H\u0002J8\u0010<\u001a\u00020=2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/H\u0002J\u0014\u0010?\u001a\u00020@2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030BH\u0016J\b\u0010C\u001a\u00020\u001aH\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0006\"\u0004\b!\u0010\b\u00a8\u0006G"}, d2={"Ljetbrains/datalore/plot/base/geom/DotplotGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "dotSize", "", "getDotSize", "()D", "setDotSize", "(D)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "method", "Ljetbrains/datalore/plot/base/stat/DotplotStat$Method;", "getMethod", "()Ljetbrains/datalore/plot/base/stat/DotplotStat$Method;", "setMethod", "(Ljetbrains/datalore/plot/base/stat/DotplotStat$Method;)V", "stackDir", "Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir;", "getStackDir", "()Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir;", "setStackDir", "(Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir;)V", "stackGroups", "", "getStackGroups", "()Z", "setStackGroups", "(Z)V", "stackRatio", "getStackRatio", "setStackRatio", "boundedStackSize", "", "stackSize", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "binWidthPx", "stacksAreVertical", "buildHint", "", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "dotId", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "buildStack", "dataPoints", "", "getDotCenter", "Ljetbrains/datalore/base/geometry/DoubleVector;", "flip", "preferableNullDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "aes", "Ljetbrains/datalore/plot/base/Aes;", "stackDotsAcrossGroups", "Companion", "DotHelper", "Stackdir", "plot-base-portable"})
public class DotplotGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double dotSize = 1.0;
    private double stackRatio = 1.0;
    private boolean stackGroups;
    @NotNull
    private Stackdir stackDir = DEF_STACKDIR;
    @NotNull
    private DotplotStat.Method method = DEF_METHOD;
    public static final double DEF_DOTSIZE = 1.0;
    public static final double DEF_STACKRATIO = 1.0;
    public static final boolean DEF_STACKGROUPS = false;
    @NotNull
    private static final Stackdir DEF_STACKDIR = Stackdir.UP;
    @NotNull
    private static final DotplotStat.Method DEF_METHOD = DotplotStat.Method.DOTDENSITY;
    public static final boolean HANDLES_GROUPS = false;

    public final double getDotSize() {
        return this.dotSize;
    }

    public final void setDotSize(double d) {
        this.dotSize = d;
    }

    public final double getStackRatio() {
        return this.stackRatio;
    }

    public final void setStackRatio(double d) {
        this.stackRatio = d;
    }

    public final boolean getStackGroups() {
        return this.stackGroups;
    }

    public final void setStackGroups(boolean bl) {
        this.stackGroups = bl;
    }

    @NotNull
    public Stackdir getStackDir() {
        return this.stackDir;
    }

    public void setStackDir(@NotNull Stackdir stackdir) {
        Intrinsics.checkNotNullParameter((Object)((Object)stackdir), (String)"<set-?>");
        this.stackDir = stackdir;
    }

    @NotNull
    public final DotplotStat.Method getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull DotplotStat.Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"<set-?>");
        this.method = method;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new FilledCircleLegendKeyElementFactory();
    }

    @Override
    @NotNull
    public DoubleSpan preferableNullDomain(@NotNull Aes<?> aes) {
        DoubleSpan doubleSpan;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                if (!Intrinsics.areEqual(aes, Aes.Companion.getY())) break block5;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getStackDir().ordinal()]) {
                    case 1: {
                        doubleSpan = new DoubleSpan(0.0, 1.0);
                        break block6;
                    }
                    case 2: {
                        doubleSpan = new DoubleSpan(-1.0, 0.0);
                        break block6;
                    }
                    case 3: 
                    case 4: {
                        doubleSpan = new DoubleSpan(-0.5, 0.5);
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            doubleSpan = super.preferableNullDomain(aes);
        }
        return doubleSpan;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable<DataPointAesthetics> pointsWithBinWidth = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getBINWIDTH());
        if (!CollectionsKt.any(pointsWithBinWidth)) {
            return;
        }
        Double d = ((DataPointAesthetics)CollectionsKt.first(pointsWithBinWidth)).binwidth();
        Intrinsics.checkNotNull((Object)d);
        double binWidthPx = Math.max(d * ctx.getUnitResolution(Aes.Companion.getX()), 2.0);
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(pointsWithBinWidth, Aes.Companion.getX(), Aes.Companion.getSTACKSIZE());
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p0 = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Double key$iv$iv = p0.x();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            List dataPointStack = (List)entry.getValue();
            this.buildStack(root, dataPointStack, pos, coord, ctx, binWidthPx);
        }
    }

    private final void buildStack(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx, double binWidthPx) {
        DotHelper dotHelper = new DotHelper(pos, coord, ctx);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        int builtStackSize = 0;
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            Double d = dataPointAesthetics.stacksize();
            Intrinsics.checkNotNull((Object)d);
            int groupStackSize = this.boundedStackSize(builtStackSize + (int)d.doubleValue(), ctx, binWidthPx, ctx.getFlipped()) - builtStackSize;
            int dotId = -1;
            for (int i = 0; i < groupStackSize; ++i) {
                dotId = this.stackDotsAcrossGroups() ? builtStackSize + i : i;
                Double d2 = dataPointAesthetics.stacksize();
                Intrinsics.checkNotNull((Object)d2);
                LinePath path = dotHelper.createDot(dataPointAesthetics, this.getDotCenter(dataPointAesthetics, dotId, (int)d2.doubleValue(), binWidthPx, ctx.getFlipped(), geomHelper), this.dotSize * binWidthPx / (double)2);
                root.add((SvgNode)path.getRootGroup());
            }
            this.buildHint(dataPointAesthetics, dotId, ctx, geomHelper, binWidthPx);
            builtStackSize += groupStackSize;
        }
    }

    private final void buildHint(DataPointAesthetics p, int dotId, GeomContext ctx, GeomHelper geomHelper, double binWidthPx) {
        double dotRadius = this.dotSize * binWidthPx / 2.0;
        int stackDirSign = this.getStackDir() == Stackdir.DOWN ? -1 : 1;
        int flipSign = ctx.getFlipped() ? 1 : -1;
        Double d = p.stacksize();
        Intrinsics.checkNotNull((Object)d);
        DoubleVector center = this.getDotCenter(p, dotId, (int)d.doubleValue(), binWidthPx, ctx.getFlipped(), geomHelper);
        DoubleVector shiftToOrigin = new DoubleVector(-dotRadius, (double)(stackDirSign * flipSign) * dotRadius);
        DoubleVector dimension = new DoubleVector(2.0 * dotRadius, 0.0);
        DoubleRectangle rect = ctx.getFlipped() ? new DoubleRectangle(center.add(shiftToOrigin.flip()), dimension.flip()) : new DoubleRectangle(center.add(shiftToOrigin), dimension);
        Function1<DataPointAesthetics, List<Color>> colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.DOT_PLOT, ctx);
        ctx.getTargetCollector().addRectangle(p.index(), rect, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorMarkerMapper.invoke((Object)p), 7, null), ctx.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
    }

    private final DoubleVector getDotCenter(DataPointAesthetics p, int dotId, int stackSize, double binWidthPx, boolean flip, GeomHelper geomHelper) {
        double d;
        Double d2 = p.x();
        Intrinsics.checkNotNull((Object)d2);
        double x = d2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStackDir().ordinal()]) {
            case 1: {
                d = (double)dotId + 1.0 / (2.0 * this.stackRatio);
                break;
            }
            case 2: {
                d = (double)(-dotId) - 1.0 / (2.0 * this.stackRatio);
                break;
            }
            case 3: {
                d = (double)dotId + 0.5 - (double)stackSize / 2.0;
                break;
            }
            case 4: {
                double parityShift = stackSize % 2 == 0 ? 0.0 : 0.5;
                d = (double)dotId + parityShift - (double)stackSize / 2.0 + 1.0 / (2.0 * this.stackRatio);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double shiftedDotId = d;
        DoubleVector shift = new DoubleVector(0.0, shiftedDotId * this.dotSize * this.stackRatio * binWidthPx);
        return geomHelper.toClient(new DoubleVector(x, 0.0), p).add(flip ? shift.flip() : shift.negate());
    }

    protected final boolean stackDotsAcrossGroups() {
        return this.stackGroups && this.method == DotplotStat.Method.HISTODOT;
    }

    protected final int boundedStackSize(int stackSize, @NotNull GeomContext ctx, double binWidthPx, boolean stacksAreVertical) {
        double d;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        boolean bl = stacksAreVertical;
        if (bl) {
            d = ctx.getAesBounds().getWidth();
        } else if (!bl) {
            d = ctx.getAesBounds().getHeight();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        double it = d;
        boolean bl2 = false;
        int stackCapacity = (int)Math.ceil(it / (this.dotSize * this.stackRatio * binWidthPx)) + 1;
        int parityCorrectionTerm = stackSize % 2 == stackCapacity % 2 ? 0 : 1;
        return Math.min(stackSize, stackCapacity + parityCorrectionTerm);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/base/geom/DotplotGeom$DotHelper;", "Ljetbrains/datalore/plot/base/geom/util/LinesHelper;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "(Ljetbrains/datalore/plot/base/PositionAdjustment;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/base/GeomContext;)V", "createDot", "Ljetbrains/datalore/plot/base/render/svg/LinePath;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "center", "Ljetbrains/datalore/base/geometry/DoubleVector;", "r", "", "plot-base-portable"})
    protected static final class DotHelper
    extends LinesHelper {
        public DotHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            super(pos, coord, ctx);
        }

        @NotNull
        public final LinePath createDot(@NotNull DataPointAesthetics p, @NotNull DoubleVector center, double r) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            DoubleVector leftBound = center.add(new DoubleVector(-r, 0.0));
            DoubleVector rightBound = center.add(new DoubleVector(r, 0.0));
            SvgPathDataBuilder builder = new SvgPathDataBuilder(true);
            builder.moveTo(leftBound);
            builder.ellipticalArc(r, r, 0.0, false, false, rightBound);
            builder.ellipticalArc(r, r, 0.0, false, false, leftBound);
            builder.closePath();
            LinePath path = new LinePath(builder);
            this.decorate(path, p, true);
            return path;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir;", "", "(Ljava/lang/String;I)V", "UP", "DOWN", "CENTER", "CENTERWHOLE", "Companion", "plot-base-portable"})
    public static final class Stackdir
    extends Enum<Stackdir> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final EnumInfo<Stackdir> ENUM_INFO;
        public static final /* enum */ Stackdir UP;
        public static final /* enum */ Stackdir DOWN;
        public static final /* enum */ Stackdir CENTER;
        public static final /* enum */ Stackdir CENTERWHOLE;
        private static final /* synthetic */ Stackdir[] $VALUES;

        public static Stackdir[] values() {
            return (Stackdir[])$VALUES.clone();
        }

        public static Stackdir valueOf(String value) {
            return Enum.valueOf(Stackdir.class, value);
        }

        static {
            UP = new Stackdir();
            DOWN = new Stackdir();
            CENTER = new Stackdir();
            CENTERWHOLE = new Stackdir();
            $VALUES = stackdirArray = new Stackdir[]{Stackdir.UP, Stackdir.DOWN, Stackdir.CENTER, Stackdir.CENTERWHOLE};
            Companion = new Companion(null);
            EnumInfoFactory this_$iv = EnumInfoFactory.INSTANCE;
            boolean $i$f$createEnumInfo = false;
            ENUM_INFO = (EnumInfo)new EnumInfoImpl((Enum[])Stackdir.values());
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir$Companion;", "", "()V", "ENUM_INFO", "Ljetbrains/datalore/base/enums/EnumInfo;", "Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir;", "safeValueOf", "v", "", "plot-base-portable"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Stackdir safeValueOf(@NotNull String v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Stackdir stackdir = (Stackdir)ENUM_INFO.safeValueOf(v);
                if (stackdir == null) {
                    throw new IllegalArgumentException("Unsupported stackdir: '" + v + "'\nUse one of: up, down, center, centerwhole.");
                }
                return stackdir;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/base/geom/DotplotGeom$Companion;", "", "()V", "DEF_DOTSIZE", "", "DEF_METHOD", "Ljetbrains/datalore/plot/base/stat/DotplotStat$Method;", "getDEF_METHOD", "()Ljetbrains/datalore/plot/base/stat/DotplotStat$Method;", "DEF_STACKDIR", "Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir;", "getDEF_STACKDIR", "()Ljetbrains/datalore/plot/base/geom/DotplotGeom$Stackdir;", "DEF_STACKGROUPS", "", "DEF_STACKRATIO", "HANDLES_GROUPS", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Stackdir getDEF_STACKDIR() {
            return DEF_STACKDIR;
        }

        @NotNull
        public final DotplotStat.Method getDEF_METHOD() {
            return DEF_METHOD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Stackdir.values().length];
            nArray[Stackdir.UP.ordinal()] = 1;
            nArray[Stackdir.DOWN.ordinal()] = 2;
            nArray[Stackdir.CENTER.ordinal()] = 3;
            nArray[Stackdir.CENTERWHOLE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

