/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AestheticsBuilder;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.geom.util.MultiPointData;
import jetbrains.datalore.plot.base.geom.util.MultiPointDataConstructor;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u0010H\u0002J0\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0014J0\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002J6\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002J6\u0010 \u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002J+\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u0010$J0\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010(\u001a\u00020\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J3\u0010*\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ljetbrains/datalore/plot/base/geom/ViolinGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "drawQuantiles", "", "", "buildHints", "", "dataPoints", "", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "helper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "boundTransform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "p", "Ljetbrains/datalore/base/geometry/DoubleVector;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "buildLines", "buildQuantiles", "buildViolin", "calculateQuantiles", "group", "", "(Ljava/lang/Iterable;Ljava/lang/Integer;)Ljava/lang/Iterable;", "pwLinInterp", "x", "y", "setDrawQuantiles", "quantiles", "toLocationBound", "sign", "Companion", "plot-base-portable"})
public final class ViolinGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Double> drawQuantiles = DEF_DRAW_QUANTILES;
    @NotNull
    private static final List<Double> DEF_DRAW_QUANTILES = CollectionsKt.emptyList();
    public static final boolean HANDLES_GROUPS = true;

    public final void setDrawQuantiles(@NotNull List<Double> quantiles) {
        Intrinsics.checkNotNullParameter(quantiles, (String)"quantiles");
        this.drawQuantiles = quantiles;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.buildLines(root, aesthetics, pos, coord, ctx);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLines(SvgRoot root, Aesthetics aesthetics, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getVIOLINWIDTH(), Aes.Companion.getWIDTH());
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p0 = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Double key$iv$iv = p0.x();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            Double x = (Double)entry.getKey();
            List nonOrderedPoints = (List)entry.getValue();
            object.add(TuplesKt.to((Object)x, GeomUtil.INSTANCE.ordered_Y(nonOrderedPoints, false)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Iterable dataPoints2 = (Iterable)pair.component2();
            this.buildViolin(root, dataPoints2, pos, coord, ctx);
        }
    }

    private final void buildViolin(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx) {
        LinesHelper helper = new LinesHelper(pos, coord, ctx);
        Function1<DataPointAesthetics, DoubleVector> leftBoundTransform = this.toLocationBound(-1.0, ctx);
        Function1<DataPointAesthetics, DoubleVector> rightBoundTransform = this.toLocationBound(1.0, ctx);
        List<LinePath> paths = helper.createBands(dataPoints2, leftBoundTransform, rightBoundTransform);
        GeomBase.Companion.appendNodes(paths, root);
        helper.setAlphaEnabled(false);
        GeomBase.Companion.appendNodes(helper.createLines(dataPoints2, leftBoundTransform), root);
        GeomBase.Companion.appendNodes(helper.createLines(dataPoints2, rightBoundTransform), root);
        this.buildQuantiles(root, dataPoints2, pos, coord, ctx);
        this.buildHints(dataPoints2, ctx, helper, leftBoundTransform);
        this.buildHints(dataPoints2, ctx, helper, rightBoundTransform);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildQuantiles(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx) {
        void $this$groupByTo$iv$iv;
        if (this.drawQuantiles.isEmpty()) {
            return;
        }
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        GeomHelper.SvgElementHelper helper = geomHelper.createSvgElementHelper();
        Iterable<? extends DataPointAesthetics> $this$groupBy$iv = dataPoints2;
        boolean $i$f$groupBy = false;
        Iterable<? extends DataPointAesthetics> iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics it = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.group();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            Integer group = (Integer)entry.getKey();
            List dataPointsGroup = (List)entry.getValue();
            for (DataPointAesthetics p : this.calculateQuantiles(dataPointsGroup, group)) {
                double xmin = ((DoubleVector)this.toLocationBound(-1.0, ctx).invoke((Object)p)).getX();
                double xmax = ((DoubleVector)this.toLocationBound(1.0, ctx).invoke((Object)p)).getX();
                Double d = p.y();
                Intrinsics.checkNotNull((Object)d);
                DoubleVector start = new DoubleVector(xmin, d.doubleValue());
                Double d2 = p.y();
                Intrinsics.checkNotNull((Object)d2);
                DoubleVector end = new DoubleVector(xmax, d2.doubleValue());
                SvgLineElement line = helper.createLine(start, end, p);
                root.add((SvgNode)line);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<DataPointAesthetics> calculateQuantiles(Iterable<? extends DataPointAesthetics> dataPoints2, Integer group) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        double elem;
        List list2;
        void $this$mapTo$iv$iv4;
        Collection collection;
        void $this$mapTo$iv$iv5;
        Double d = ((DataPointAesthetics)CollectionsKt.first(dataPoints2)).x();
        Intrinsics.checkNotNull((Object)d);
        double x = d;
        Iterable<? extends DataPointAesthetics> $this$map$iv2 = dataPoints2;
        boolean $i$f$map = false;
        Iterable<? extends DataPointAesthetics> iterable = $this$map$iv2;
        Iterable<Object> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            void it;
            DataPointAesthetics dataPointAesthetics = (DataPointAesthetics)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Double d2 = it.violinwidth();
            Intrinsics.checkNotNull((Object)d2);
            collection.add(Double.valueOf(d2));
        }
        List vws = (List)destination$iv$iv;
        Iterable<? extends DataPointAesthetics> $this$map$iv3 = dataPoints2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            DataPointAesthetics bl = (DataPointAesthetics)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Double d3 = it.y();
            Intrinsics.checkNotNull((Object)d3);
            collection.add(Double.valueOf(d3));
        }
        List ys = (List)destination$iv$iv2;
        double vwsSum = CollectionsKt.sumOfDouble((Iterable)vws);
        Iterable $this$runningReduce$iv = vws;
        boolean $i$f$runningReduce = false;
        Iterator iterator$iv = $this$runningReduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list2 = CollectionsKt.emptyList();
        } else {
            ArrayList<Double> it;
            Double accumulator$iv = null;
            accumulator$iv = (Double)iterator$iv.next();
            ArrayList<Double> $this$runningReduce_u24lambda_u2d20$iv = it = new ArrayList<Double>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningReduce$iv, (int)10));
            boolean bl = false;
            $this$runningReduce_u24lambda_u2d20$iv.add(accumulator$iv);
            ArrayList<Double> result$iv = it;
            while (iterator$iv.hasNext()) {
                double d4 = ((Number)iterator$iv.next()).doubleValue();
                double cumSum = ((Number)accumulator$iv).doubleValue();
                boolean bl3 = false;
                accumulator$iv = cumSum + elem;
                result$iv.add(accumulator$iv);
            }
            list2 = result$iv;
        }
        $this$runningReduce$iv = list2;
        boolean $i$f$map3 = false;
        iterator$iv = $this$map$iv;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            double result$iv = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add((double)(it / vwsSum));
        }
        List dens = (List)destination$iv$iv3;
        Iterable $this$map$iv4 = this.drawQuantiles;
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            elem = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(((Number)this.pwLinInterp(dens, ys).invoke((Object)((double)it))).doubleValue());
        }
        List quantY = (List)destination$iv$iv4;
        Iterable $this$map$iv5 = quantY;
        boolean $i$f$map5 = false;
        destination$iv$iv4 = $this$map$iv5;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double bl = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv5;
            boolean bl4 = false;
            collection.add(((Number)this.pwLinInterp(ys, vws).invoke((Object)((double)it))).doubleValue());
        }
        List quantViolinWidth = (List)destination$iv$iv5;
        Color quantilesColor = ((DataPointAesthetics)CollectionsKt.first(dataPoints2)).color();
        Double quantilesSize = ((DataPointAesthetics)CollectionsKt.first(dataPoints2)).size();
        Integer n = group;
        return new AestheticsBuilder(quantY.size()).x(AestheticsBuilder.Companion.constant(x)).y(AestheticsBuilder.Companion.list(quantY)).violinwidth(AestheticsBuilder.Companion.list(quantViolinWidth)).group(AestheticsBuilder.Companion.constant(n != null ? n : 0)).color(AestheticsBuilder.Companion.constant(quantilesColor)).size(AestheticsBuilder.Companion.constant(quantilesSize)).build().dataPoints();
    }

    private final Function1<Double, Double> pwLinInterp(List<Double> x, List<Double> y) {
        return (Function1)new Function1<Double, Double>(x, y){
            final /* synthetic */ List<Double> $x;
            final /* synthetic */ List<Double> $y;
            {
                this.$x = $x;
                this.$y = $y;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                int i;
                block4: {
                    int n;
                    List<Double> $this$indexOfFirst$iv = this.$x;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Double item$iv : $this$indexOfFirst$iv) {
                        double it = ((Number)item$iv).doubleValue();
                        boolean bl = false;
                        if (it >= t) {
                            n = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n = i = -1;
                }
                if (i == 0) {
                    return (Double)CollectionsKt.first(this.$y);
                }
                if (i == -1) {
                    return (Double)CollectionsKt.last(this.$y);
                }
                double a = (((Number)this.$y.get(i)).doubleValue() - ((Number)this.$y.get(i - 1)).doubleValue()) / (((Number)this.$x.get(i)).doubleValue() - ((Number)this.$x.get(i - 1)).doubleValue());
                double b = ((Number)this.$y.get(i - 1)).doubleValue() - a * ((Number)this.$x.get(i - 1)).doubleValue();
                return a * t + b;
            }
        };
    }

    private final Function1<DataPointAesthetics, DoubleVector> toLocationBound(double sign, GeomContext ctx) {
        return (Function1)new Function1<DataPointAesthetics, DoubleVector>(ctx, sign){
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ double $sign;
            {
                this.$ctx = $ctx;
                this.$sign = $sign;
                super(1);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Double d = p.x();
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                double d3 = this.$ctx.getResolution(Aes.Companion.getX()) / (double)2 * this.$sign;
                Double d4 = p.width();
                Intrinsics.checkNotNull((Object)d4);
                double d5 = d3 * d4;
                Double d6 = p.violinwidth();
                Intrinsics.checkNotNull((Object)d6);
                double x = d2 + d5 * d6;
                Double d7 = p.y();
                Intrinsics.checkNotNull((Object)d7);
                double y = d7;
                return new DoubleVector(x, y);
            }
        };
    }

    private final void buildHints(Iterable<? extends DataPointAesthetics> dataPoints2, GeomContext ctx, GeomHelper helper, Function1<? super DataPointAesthetics, DoubleVector> boundTransform) {
        List<MultiPointData> multiPointDataList2 = MultiPointDataConstructor.INSTANCE.createMultiPointDataByGroup(dataPoints2, MultiPointDataConstructor.INSTANCE.singlePointAppender((Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(boundTransform, helper){
            final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $boundTransform;
            final /* synthetic */ GeomHelper $helper;
            {
                this.$boundTransform = $boundTransform;
                this.$helper = $helper;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Object object = this.$boundTransform.invoke((Object)p);
                GeomHelper geomHelper = this.$helper;
                DoubleVector it = (DoubleVector)object;
                boolean bl = false;
                return geomHelper.toClient(it, p);
            }
        })), MultiPointDataConstructor.INSTANCE.reducer(0.999, false));
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx);
        Function1<DataPointAesthetics, List<Color>> colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.VIOLIN, ctx);
        for (MultiPointData multiPointData : multiPointDataList2) {
            targetCollector.addPath(multiPointData.getPoints(), multiPointData.getLocalToGlobalIndex(), new GeomTargetCollector.TooltipParams(null, null, null, (List)colorMarkerMapper.invoke((Object)multiPointData.getAes()), 7, null), ctx.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/base/geom/ViolinGeom$Companion;", "", "()V", "DEF_DRAW_QUANTILES", "", "", "getDEF_DRAW_QUANTILES", "()Ljava/util/List;", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Double> getDEF_DRAW_QUANTILES() {
            return DEF_DRAW_QUANTILES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

