/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.enums.EnumInfo;
import jetbrains.datalore.base.enums.EnumInfoFactory;
import jetbrains.datalore.base.enums.EnumInfoImpl;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.DotplotGeom;
import jetbrains.datalore.plot.base.geom.FilledCircleLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J>\u0010#\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J8\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006,"}, d2={"Ljetbrains/datalore/plot/base/geom/YDotplotGeom;", "Ljetbrains/datalore/plot/base/geom/DotplotGeom;", "()V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "yStackDir", "Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir;", "getYStackDir", "()Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir;", "setYStackDir", "(Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir;)V", "buildHint", "", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "dotId", "", "stackSize", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "binWidthPx", "", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "buildStack", "dataPoints", "", "getDotCenter", "Ljetbrains/datalore/base/geometry/DoubleVector;", "flip", "", "Companion", "YStackdir", "plot-base-portable"})
public final class YDotplotGeom
extends DotplotGeom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private YStackdir yStackDir = DEF_YSTACKDIR;
    @NotNull
    private static final YStackdir DEF_YSTACKDIR = YStackdir.CENTER;
    public static final boolean HANDLES_GROUPS = true;

    @NotNull
    public final YStackdir getYStackDir() {
        return this.yStackDir;
    }

    public final void setYStackDir(@NotNull YStackdir yStackdir) {
        Intrinsics.checkNotNullParameter((Object)((Object)yStackdir), (String)"<set-?>");
        this.yStackDir = yStackdir;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new FilledCircleLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        void $this$forEach$iv;
        Iterable list$iv$iv;
        Double key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Iterable<DataPointAesthetics> pointsWithBinWidth = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getBINWIDTH());
        if (!CollectionsKt.any(pointsWithBinWidth)) {
            return;
        }
        Double d = ((DataPointAesthetics)CollectionsKt.first(pointsWithBinWidth)).binwidth();
        Intrinsics.checkNotNull((Object)d);
        double binWidthPx = Math.max(d * ctx.getUnitResolution(Aes.Companion.getY()), 2.0);
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(pointsWithBinWidth, Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getSTACKSIZE());
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p0 = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            key$iv$iv = p0.x();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            void $this$groupByTo$iv$iv2;
            Map $this$groupBy$iv2;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            List dataPointGroup = (List)entry.getValue();
            list$iv$iv = dataPointGroup;
            boolean $i$f$groupBy2 = false;
            key$iv$iv = $this$groupBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo2 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                Object object;
                DataPointAesthetics p0 = (DataPointAesthetics)element$iv$iv;
                boolean bl3 = false;
                Double key$iv$iv2 = p0.y();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv2 = (List)object;
                list$iv$iv2.add(element$iv$iv);
            }
            $this$groupBy$iv2 = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry2 = element$iv2 = iterator2.next();
                boolean bl5 = false;
                List dataPointStack = (List)entry2.getValue();
                this.buildStack(root, dataPointStack, pos, coord, ctx, binWidthPx);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildStack(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx, double binWidthPx) {
        void $this$mapTo$iv$iv;
        DotplotGeom.DotHelper dotHelper = new DotplotGeom.DotHelper(pos, coord, ctx);
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        Iterable<? extends DataPointAesthetics> $this$map$iv = dataPoints2;
        boolean $i$f$map = false;
        Iterable<? extends DataPointAesthetics> iterable = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataPointAesthetics dataPointAesthetics = (DataPointAesthetics)item$iv$iv;
            Collection collection2 = collection;
            boolean bl = false;
            Double d = it.stacksize();
            Intrinsics.checkNotNull((Object)d);
            collection2.add(Double.valueOf(d));
        }
        int fullStackSize = (int)CollectionsKt.sumOfDouble((Iterable)((List)collection));
        int stackSize = this.boundedStackSize(fullStackSize, ctx, binWidthPx, !ctx.getFlipped());
        int builtStackSize = 0;
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            Double d = dataPointAesthetics.stacksize();
            Intrinsics.checkNotNull((Object)d);
            int groupStackSize = this.boundedStackSize(builtStackSize + (int)d.doubleValue(), ctx, binWidthPx, !ctx.getFlipped()) - builtStackSize;
            int currentStackSize = this.stackDotsAcrossGroups() ? stackSize : groupStackSize;
            int dotId = -1;
            for (int i = 0; i < groupStackSize; ++i) {
                dotId = this.stackDotsAcrossGroups() ? builtStackSize + i : i;
                DoubleVector center = this.getDotCenter(dataPointAesthetics, dotId, currentStackSize, binWidthPx, ctx.getFlipped(), geomHelper);
                LinePath path = dotHelper.createDot(dataPointAesthetics, center, this.getDotSize() * binWidthPx / (double)2);
                root.add((SvgNode)path.getRootGroup());
            }
            this.buildHint(dataPointAesthetics, dotId, currentStackSize, ctx, geomHelper, binWidthPx);
            builtStackSize += groupStackSize;
        }
    }

    private final void buildHint(DataPointAesthetics p, int dotId, int stackSize, GeomContext ctx, GeomHelper geomHelper, double binWidthPx) {
        Double d = p.stacksize();
        Intrinsics.checkNotNull((Object)d);
        int currentStackSize = (int)d.doubleValue();
        if (currentStackSize == 0) {
            return;
        }
        DoubleVector center = this.getDotCenter(p, dotId, stackSize, binWidthPx, ctx.getFlipped(), geomHelper);
        double radius = this.getDotSize() * binWidthPx / 2.0;
        double width2 = 2.0 * radius;
        double height = 2.0 * radius * ((double)currentStackSize * this.getStackRatio() - (this.getStackRatio() - 1.0));
        double stackShift = this.yStackDir == YStackdir.LEFT ? -radius : -height + radius;
        DoubleRectangle rect = ctx.getFlipped() ? new DoubleRectangle(new DoubleVector(center.getX() - radius, center.getY() + stackShift), new DoubleVector(width2, height)) : new DoubleRectangle(new DoubleVector(center.getX() + stackShift, center.getY() - radius), new DoubleVector(height, width2));
        Function1<DataPointAesthetics, List<Color>> colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.Y_DOT_PLOT, ctx);
        ctx.getTargetCollector().addRectangle(p.index(), rect, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorMarkerMapper.invoke((Object)p), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
    }

    private final DoubleVector getDotCenter(DataPointAesthetics p, int dotId, int stackSize, double binWidthPx, boolean flip, GeomHelper geomHelper) {
        double d;
        Double d2 = p.x();
        Intrinsics.checkNotNull((Object)d2);
        double x = d2;
        Double d3 = p.y();
        Intrinsics.checkNotNull((Object)d3);
        double y = d3;
        switch (WhenMappings.$EnumSwitchMapping$0[this.yStackDir.ordinal()]) {
            case 1: {
                d = (double)(-dotId) - 1.0 / (2.0 * this.getStackRatio());
                break;
            }
            case 2: {
                d = (double)dotId + 1.0 / (2.0 * this.getStackRatio());
                break;
            }
            case 3: {
                d = (double)dotId + 0.5 - (double)stackSize / 2.0;
                break;
            }
            case 4: {
                double parityShift = stackSize % 2 == 0 ? 0.0 : 0.5;
                d = (double)dotId + parityShift - (double)stackSize / 2.0 + 1.0 / (2.0 * this.getStackRatio());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double shiftedDotId = d;
        DoubleVector shift = new DoubleVector(shiftedDotId * this.getDotSize() * this.getStackRatio() * binWidthPx, 0.0);
        return geomHelper.toClient(new DoubleVector(x, y), p).add(flip ? shift.flip() : shift);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "CENTER", "CENTERWHOLE", "Companion", "plot-base-portable"})
    public static final class YStackdir
    extends Enum<YStackdir> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final EnumInfo<YStackdir> ENUM_INFO;
        public static final /* enum */ YStackdir LEFT;
        public static final /* enum */ YStackdir RIGHT;
        public static final /* enum */ YStackdir CENTER;
        public static final /* enum */ YStackdir CENTERWHOLE;
        private static final /* synthetic */ YStackdir[] $VALUES;

        public static YStackdir[] values() {
            return (YStackdir[])$VALUES.clone();
        }

        public static YStackdir valueOf(String value) {
            return Enum.valueOf(YStackdir.class, value);
        }

        static {
            LEFT = new YStackdir();
            RIGHT = new YStackdir();
            CENTER = new YStackdir();
            CENTERWHOLE = new YStackdir();
            $VALUES = yStackdirArray = new YStackdir[]{YStackdir.LEFT, YStackdir.RIGHT, YStackdir.CENTER, YStackdir.CENTERWHOLE};
            Companion = new Companion(null);
            EnumInfoFactory this_$iv = EnumInfoFactory.INSTANCE;
            boolean $i$f$createEnumInfo = false;
            ENUM_INFO = (EnumInfo)new EnumInfoImpl((Enum[])YStackdir.values());
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir$Companion;", "", "()V", "ENUM_INFO", "Ljetbrains/datalore/base/enums/EnumInfo;", "Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir;", "safeValueOf", "v", "", "plot-base-portable"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final YStackdir safeValueOf(@NotNull String v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                YStackdir yStackdir = (YStackdir)ENUM_INFO.safeValueOf(v);
                if (yStackdir == null) {
                    throw new IllegalArgumentException("Unsupported stackdir: '" + v + "'\nUse one of: left, right, center, centerwhole.");
                }
                return yStackdir;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/YDotplotGeom$Companion;", "", "()V", "DEF_YSTACKDIR", "Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir;", "getDEF_YSTACKDIR", "()Ljetbrains/datalore/plot/base/geom/YDotplotGeom$YStackdir;", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final YStackdir getDEF_YSTACKDIR() {
            return DEF_YSTACKDIR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[YStackdir.values().length];
            nArray[YStackdir.LEFT.ordinal()] = 1;
            nArray[YStackdir.RIGHT.ordinal()] = 2;
            nArray[YStackdir.CENTER.ordinal()] = 3;
            nArray[YStackdir.CENTERWHOLE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

