/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/geom/util/CrossBarLegendKeyElementFactory;", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "whiskers", "", "(Z)V", "getWhiskers", "()Z", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-base-portable"})
final class CrossBarLegendKeyElementFactory
implements LegendKeyElementFactory {
    private final boolean whiskers;

    public CrossBarLegendKeyElementFactory(boolean whiskers) {
        this.whiskers = whiskers;
    }

    public final boolean getWhiskers() {
        return this.whiskers;
    }

    @Override
    @NotNull
    public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        double whiskerSize = 0.2;
        double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
        double width2 = (size.getX() - strokeWidth) * 0.8;
        double height = size.getY() - strokeWidth;
        double x = (size.getX() - width2) / (double)2;
        double y = strokeWidth / (double)2;
        double boxHeight = height;
        double boxY = y;
        if (this.whiskers) {
            boxHeight = height * (1.0 - (double)2 * whiskerSize);
            boxY = y + height * whiskerSize;
        }
        SvgRectElement rect = new SvgRectElement(x, boxY, width2, boxHeight);
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)rect, p, false, 4, null);
        double middleY = y + height * 0.5;
        SvgLineElement middle = new SvgLineElement(x, middleY, x + width2, middleY);
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)middle, p, false, 4, null);
        SvgGElement g = new SvgGElement();
        g.children().add((Object)rect);
        g.children().add((Object)middle);
        if (this.whiskers) {
            double middleX = x + width2 * 0.5;
            SvgLineElement lowerWhisker = new SvgLineElement(middleX, y + height * (1.0 - whiskerSize), middleX, y + height);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)lowerWhisker, p, false, 4, null);
            SvgLineElement upperWhisker = new SvgLineElement(middleX, y, middleX, y + height * whiskerSize);
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)upperWhisker, p, false, 4, null);
            g.children().add((Object)lowerWhisker);
            g.children().add((Object)upperWhisker);
        }
        return g;
    }

    @Override
    @NotNull
    public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
        return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
    }
}

