/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.pos;

import java.util.HashMap;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.pos.PositionAdjustments;
import jetbrains.datalore.plot.base.pos.StackPos;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/pos/FillPos;", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "aes", "Ljetbrains/datalore/plot/base/Aesthetics;", "(Ljetbrains/datalore/plot/base/Aesthetics;)V", "myScalerByIndex", "", "", "", "myStackPosHelper", "handlesGroups", "", "mapIndexToScaler", "translate", "Ljetbrains/datalore/base/geometry/DoubleVector;", "v", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "plot-base-portable"})
public final class FillPos
implements PositionAdjustment {
    @NotNull
    private final PositionAdjustment myStackPosHelper;
    @NotNull
    private final Map<Integer, Double> myScalerByIndex;

    public FillPos(@NotNull Aesthetics aes) {
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        this.myStackPosHelper = StackPos.Companion.splitPositiveNegative(aes);
        this.myScalerByIndex = this.mapIndexToScaler(aes);
    }

    private final Map<Integer, Double> mapIndexToScaler(Aesthetics aes) {
        HashMap posMaxByBin = new HashMap();
        HashMap negMaxByBin = new HashMap();
        int n = aes.dataPointCount();
        for (int i = 0; i < n; ++i) {
            Double y;
            DataPointAesthetics dataPoint = aes.dataPointAt(i);
            Double x = dataPoint.x();
            if (!SeriesUtil.INSTANCE.isFinite(x)) continue;
            if (!((Map)posMaxByBin).containsKey(x)) {
                Map map = posMaxByBin;
                Double d = x;
                Intrinsics.checkNotNull((Object)d);
                map.put(d, 0.0);
                ((Map)negMaxByBin).put(x, 0.0);
            }
            if (!SeriesUtil.INSTANCE.isFinite(y = dataPoint.y())) continue;
            Double d = y;
            Intrinsics.checkNotNull((Object)d);
            if (d >= 0.0) {
                Map map = posMaxByBin;
                Double d2 = x;
                Intrinsics.checkNotNull((Object)d2);
                Object v = posMaxByBin.get(x);
                Intrinsics.checkNotNull(v);
                map.put(d2, ((Number)v).doubleValue() + y);
                continue;
            }
            Map map = negMaxByBin;
            Double d3 = x;
            Intrinsics.checkNotNull((Object)d3);
            Object v = negMaxByBin.get(x);
            Intrinsics.checkNotNull(v);
            map.put(d3, ((Number)v).doubleValue() - y);
        }
        HashMap scalerByIndex = new HashMap();
        int n2 = aes.dataPointCount();
        for (int i = 0; i < n2; ++i) {
            Integer n3;
            DataPointAesthetics dataPoint = aes.dataPointAt(i);
            Double x = dataPoint.x();
            Double y = dataPoint.y();
            if (((Map)posMaxByBin).containsKey(x) && SeriesUtil.INSTANCE.isFinite(y)) {
                Double d = y;
                Intrinsics.checkNotNull((Object)d);
                if (d >= 0.0) {
                    Object v = ((Map)posMaxByBin).get(x);
                    Intrinsics.checkNotNull(v);
                    if (((Number)v).doubleValue() > 0.0) {
                        n3 = i;
                        Map map = scalerByIndex;
                        Object v2 = ((Map)posMaxByBin).get(x);
                        Intrinsics.checkNotNull(v2);
                        map.put(n3, 1.0 / ((Number)v2).doubleValue());
                        continue;
                    }
                }
                if (y < 0.0) {
                    Object v = ((Map)negMaxByBin).get(x);
                    Intrinsics.checkNotNull(v);
                    if (((Number)v).doubleValue() > 0.0) {
                        n3 = i;
                        Map map = scalerByIndex;
                        Object v3 = ((Map)negMaxByBin).get(x);
                        Intrinsics.checkNotNull(v3);
                        map.put(n3, 1.0 / ((Number)v3).doubleValue());
                        continue;
                    }
                }
                n3 = i;
                ((Map)scalerByIndex).put(n3, 1.0);
                continue;
            }
            n3 = i;
            ((Map)scalerByIndex).put(n3, 1.0);
        }
        return scalerByIndex;
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        DoubleVector newLoc = this.myStackPosHelper.translate(v, p, ctx);
        double d = newLoc.getX();
        double d2 = newLoc.getY();
        Double d3 = this.myScalerByIndex.get(p.index());
        Intrinsics.checkNotNull((Object)d3);
        return new DoubleVector(d, d2 * ((Number)d3).doubleValue() * ctx.getUnitResolution(Aes.Companion.getY()));
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.FILL.handlesGroups();
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }
}

