/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.render.point;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.render.point.NamedShape;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.plot.base.render.point.TinyPointShape;
import jetbrains.datalore.plot.base.render.point.symbol.Glyph;
import jetbrains.datalore.plot.base.render.point.symbol.Glyphs;
import jetbrains.datalore.vis.svg.slim.SvgSlimElements;
import jetbrains.datalore.vis.svg.slim.SvgSlimObject;
import jetbrains.datalore.vis.svg.slim.SvgSlimShape;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/render/point/PointShapeSvg;", "", "()V", "create", "Ljetbrains/datalore/vis/svg/slim/SvgSlimObject;", "shape", "Ljetbrains/datalore/plot/base/render/point/PointShape;", "location", "Ljetbrains/datalore/base/geometry/DoubleVector;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "fatten", "", "createNamedShape", "Ljetbrains/datalore/plot/base/render/point/NamedShape;", "createSlimGlyph", "Ljetbrains/datalore/plot/base/render/point/symbol/Glyph;", "size", "createTinyDotShape", "plot-base-portable"})
public final class PointShapeSvg {
    @NotNull
    public static final PointShapeSvg INSTANCE = new PointShapeSvg();

    private PointShapeSvg() {
    }

    @NotNull
    public final SvgSlimObject create(@NotNull PointShape shape, @NotNull DoubleVector location, @NotNull DataPointAesthetics p, double fatten) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (Intrinsics.areEqual((Object)shape, (Object)TinyPointShape.INSTANCE)) {
            return this.createTinyDotShape(location, p);
        }
        if (shape instanceof NamedShape) {
            return this.createNamedShape((NamedShape)shape, location, p, fatten);
        }
        throw new IllegalArgumentException("Unsupported point shape code " + shape.getCode() + ' ' + Reflection.getOrCreateKotlinClass(shape.getClass()).getSimpleName());
    }

    public static /* synthetic */ SvgSlimObject create$default(PointShapeSvg pointShapeSvg, PointShape pointShape, DoubleVector doubleVector, DataPointAesthetics dataPointAesthetics, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        return pointShapeSvg.create(pointShape, doubleVector, dataPointAesthetics, d);
    }

    private final SvgSlimObject createTinyDotShape(DoubleVector location, DataPointAesthetics p) {
        SvgSlimShape r = SvgSlimElements.INSTANCE.rect(location.getX() - 0.5, location.getY() - 0.5, 1.0, 1.0);
        Color color = p.color();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        double alpha = AestheticsUtil.INSTANCE.alpha(color2, p);
        r.setFill(color2, alpha);
        r.setStrokeWidth(0.0);
        return (SvgSlimObject)r;
    }

    private final SvgSlimObject createNamedShape(NamedShape shape, DoubleVector location, DataPointAesthetics p, double fatten) {
        Glyph glyph = this.createSlimGlyph(shape, location, shape.size(p) * fatten);
        AestheticsUtil.INSTANCE.decorate(glyph, shape.isFilled(), shape.isSolid(), p, shape.strokeWidth(p));
        return glyph;
    }

    private final Glyph createSlimGlyph(NamedShape shape, DoubleVector location, double size) {
        switch (WhenMappings.$EnumSwitchMapping$0[shape.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return Glyphs.INSTANCE.square(location, size);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Glyphs.INSTANCE.circle(location, size);
            }
            case 9: 
            case 10: 
            case 11: {
                return Glyphs.INSTANCE.triangleUp(location, size);
            }
            case 12: 
            case 13: {
                return Glyphs.INSTANCE.triangleDown(location, size);
            }
            case 14: 
            case 15: 
            case 16: {
                return Glyphs.INSTANCE.diamond(location, size);
            }
            case 17: {
                return Glyphs.INSTANCE.stickPlus(location, size);
            }
            case 18: {
                return Glyphs.INSTANCE.stickCross(location, size);
            }
            case 19: {
                return Glyphs.INSTANCE.stickSquareCross(location, size);
            }
            case 20: {
                return Glyphs.INSTANCE.stickStar(location, size);
            }
            case 21: {
                return Glyphs.INSTANCE.stickDiamondPlus(location, size);
            }
            case 22: {
                return Glyphs.INSTANCE.stickCirclePlus(location, size);
            }
            case 23: {
                return Glyphs.INSTANCE.stickTriangleUpDown(location, size);
            }
            case 24: {
                return Glyphs.INSTANCE.stickSquarePlus(location, size);
            }
            case 25: {
                return Glyphs.INSTANCE.stickCircleCross(location, size);
            }
            case 26: {
                return Glyphs.INSTANCE.stickSquareTriangleUp(location, size);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NamedShape.values().length];
            nArray[NamedShape.STICK_SQUARE.ordinal()] = 1;
            nArray[NamedShape.SOLID_SQUARE.ordinal()] = 2;
            nArray[NamedShape.FILLED_SQUARE.ordinal()] = 3;
            nArray[NamedShape.STICK_CIRCLE.ordinal()] = 4;
            nArray[NamedShape.SOLID_CIRCLE.ordinal()] = 5;
            nArray[NamedShape.SOLID_CIRCLE_2.ordinal()] = 6;
            nArray[NamedShape.BULLET.ordinal()] = 7;
            nArray[NamedShape.FILLED_CIRCLE.ordinal()] = 8;
            nArray[NamedShape.STICK_TRIANGLE_UP.ordinal()] = 9;
            nArray[NamedShape.SOLID_TRIANGLE_UP.ordinal()] = 10;
            nArray[NamedShape.FILLED_TRIANGLE_UP.ordinal()] = 11;
            nArray[NamedShape.STICK_TRIANGLE_DOWN.ordinal()] = 12;
            nArray[NamedShape.FILLED_TRIANGLE_DOWN.ordinal()] = 13;
            nArray[NamedShape.STICK_DIAMOND.ordinal()] = 14;
            nArray[NamedShape.SOLID_DIAMOND.ordinal()] = 15;
            nArray[NamedShape.FILLED_DIAMOND.ordinal()] = 16;
            nArray[NamedShape.STICK_PLUS.ordinal()] = 17;
            nArray[NamedShape.STICK_CROSS.ordinal()] = 18;
            nArray[NamedShape.STICK_SQUARE_CROSS.ordinal()] = 19;
            nArray[NamedShape.STICK_STAR.ordinal()] = 20;
            nArray[NamedShape.STICK_DIAMOND_PLUS.ordinal()] = 21;
            nArray[NamedShape.STICK_CIRCLE_PLUS.ordinal()] = 22;
            nArray[NamedShape.STICK_TRIANGLE_UP_DOWN.ordinal()] = 23;
            nArray[NamedShape.STICK_SQUARE_PLUS.ordinal()] = 24;
            nArray[NamedShape.STICK_CIRCLE_CROSS.ordinal()] = 25;
            nArray[NamedShape.STICK_SQUARE_TRIANGLE_UP.ordinal()] = 26;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

