/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.render.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.vis.svg.SvgTSpanElement;
import jetbrains.datalore.vis.svg.SvgTextElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001e\u001a\u00020\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0007J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0007J\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0)J\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070)J\b\u0010+\u001a\u00020\u0010H\u0002J\b\u0010,\u001a\u00020\u0010H\u0002J\r\u0010%\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010-J\r\u0010'\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010-R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ljetbrains/datalore/plot/base/render/svg/MultilineLabel;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "text", "", "(Ljava/lang/String;)V", "myFontFamily", "myFontSize", "", "myFontStyle", "myFontWeight", "myLineHeight", "myText", "Ljetbrains/datalore/vis/svg/SvgTextElement;", "myTextColor", "Ljetbrains/datalore/base/values/Color;", "addClassName", "", "className", "addTSpanElements", "lines", "", "buildComponent", "linesCount", "", "setFontFamily", "fontFamily", "setFontSize", "px", "setFontStyle", "cssName", "setFontWeight", "setHorizontalAnchor", "anchor", "Ljetbrains/datalore/plot/base/render/svg/Text$HorizontalAnchor;", "setLineHeight", "v", "setX", "x", "setY", "y", "textColor", "Ljetbrains/datalore/base/observable/property/WritableProperty;", "textOpacity", "updatePositions", "updateStyleAttribute", "()Ljava/lang/Double;", "plot-base-portable"})
public final class MultilineLabel
extends SvgComponent {
    @NotNull
    private final SvgTextElement myText;
    @Nullable
    private Color myTextColor;
    private double myFontSize;
    @Nullable
    private String myFontWeight;
    @Nullable
    private String myFontFamily;
    @Nullable
    private String myFontStyle;
    private double myLineHeight;

    public MultilineLabel(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.myText = new SvgTextElement();
        char[] cArray = new char[]{'\n'};
        this.addTSpanElements(StringsKt.split$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null));
        this.getRootGroup().children().add((Object)this.myText);
    }

    @Override
    protected void buildComponent() {
    }

    @Override
    public void addClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.myText.addClass(className);
    }

    @NotNull
    public final WritableProperty<Color> textColor() {
        return (WritableProperty)new WritableProperty<Color>(this){
            final /* synthetic */ MultilineLabel this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(@Nullable Color value) {
                MultilineLabel.access$getMyText$p(this.this$0).fillColor();
                MultilineLabel.access$setMyTextColor$p(this.this$0, value);
                MultilineLabel.access$updateStyleAttribute(this.this$0);
            }
        };
    }

    @NotNull
    public final WritableProperty<Double> textOpacity() {
        return (WritableProperty)this.myText.fillOpacity();
    }

    @Nullable
    public final Double x() {
        return (Double)this.myText.x().get();
    }

    @Nullable
    public final Double y() {
        return (Double)this.myText.y().get();
    }

    public final void setHorizontalAnchor(@NotNull Text.HorizontalAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchor), (String)"anchor");
        this.myText.setAttribute("text-anchor", Text.INSTANCE.toTextAnchor$plot_base_portable(anchor));
    }

    public final void setFontSize(double px) {
        this.myFontSize = px;
        this.updateStyleAttribute();
    }

    public final void setFontWeight(@Nullable String cssName) {
        this.myFontWeight = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontStyle(@Nullable String cssName) {
        this.myFontStyle = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontFamily(@Nullable String fontFamily) {
        this.myFontFamily = fontFamily;
        this.updateStyleAttribute();
    }

    private final void updateStyleAttribute() {
        String styleAttr = Text.INSTANCE.buildStyle$plot_base_portable(this.myTextColor, this.myFontSize, this.myFontWeight, this.myFontFamily, this.myFontStyle);
        this.myText.setAttribute("style", styleAttr);
    }

    private final void addTSpanElements(List<String> lines) {
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            this.myText.addTSpan(line);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setX(double x) {
        void $this$filterIsInstanceTo$iv$iv;
        this.myText.x().set((Object)x);
        Iterable $this$filterIsInstance$iv = (Iterable)this.myText.children();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SvgTSpanElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTSpanElement tspan = (SvgTSpanElement)element$iv;
            boolean bl = false;
            tspan.x().set((Object)x);
        }
    }

    public final void setY(double y) {
        this.myText.y().set((Object)y);
        this.updatePositions();
    }

    public final void setLineHeight(double v) {
        this.myLineHeight = v;
        this.updatePositions();
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePositions() {
        void $this$filterIsInstanceTo$iv$iv;
        Double d = this.y();
        double y = d != null ? d : 0.0;
        Iterable $this$filterIsInstance$iv = (Iterable)this.myText.children();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SvgTSpanElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEachIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void tspan;
            int n;
            Object element$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (SvgTSpanElement)item$iv;
            int index = n;
            boolean bl = false;
            tspan.y().set((Object)(y + this.myLineHeight * (double)index));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int linesCount() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = (Iterable)this.myText.children();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SvgTSpanElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    public static final /* synthetic */ SvgTextElement access$getMyText$p(MultilineLabel $this) {
        return $this.myText;
    }

    public static final /* synthetic */ void access$setMyTextColor$p(MultilineLabel $this, Color color) {
        $this.myTextColor = color;
    }

    public static final /* synthetic */ void access$updateStyleAttribute(MultilineLabel $this) {
        $this.updateStyleAttribute();
    }
}

