/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.plot.base.scale.breaks.BreaksHelperBase;
import jetbrains.datalore.plot.base.scale.breaks.LinearBreaksHelper;
import jetbrains.datalore.plot.base.scale.breaks.TimeScaleTickFormatterFactory;
import jetbrains.datalore.plot.common.time.TimeUtil;
import jetbrains.datalore.plot.common.time.interval.NiceTimeInterval;
import jetbrains.datalore.plot.common.time.interval.TimeInterval;
import jetbrains.datalore.plot.common.time.interval.YearInterval;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/base/scale/breaks/DateTimeBreaksHelper;", "Ljetbrains/datalore/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "count", "", "minInterval", "Ljetbrains/datalore/plot/common/time/interval/TimeInterval;", "(DDILjetbrains/datalore/plot/common/time/interval/TimeInterval;)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "formatter", "Lkotlin/Function1;", "", "", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "plot-base-portable"})
public final class DateTimeBreaksHelper
extends BreaksHelperBase {
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> formatter;

    public DateTimeBreaksHelper(double rangeStart, double rangeEnd, int count, @Nullable TimeInterval minInterval) {
        super(rangeStart, rangeEnd, count);
        double step = this.getTargetStep();
        if (step < 1000.0) {
            this.formatter = new TimeScaleTickFormatterFactory(minInterval).getFormatter(step);
            this.breaks = new LinearBreaksHelper(rangeStart, rangeEnd, count, false, 8, null).getBreaks();
        } else {
            double start = this.getNormalStart();
            double end = this.getNormalEnd();
            List ticks = null;
            if (minInterval != null) {
                ticks = CollectionsKt.toMutableList((Collection)minInterval.range(start, end));
            }
            if (ticks != null && ticks.size() <= count) {
                TimeInterval timeInterval = minInterval;
                Intrinsics.checkNotNull((Object)timeInterval);
                this.formatter = timeInterval.getTickFormatter();
            } else if (step > 3.1536E10) {
                int startYear;
                this.formatter = YearInterval.Companion.getTICK_FORMATTER();
                ticks = new ArrayList();
                DateTime startDateTime = TimeUtil.INSTANCE.asDateTimeUTC(start);
                if (startDateTime.isAfter(TimeUtil.INSTANCE.yearStart(startYear = startDateTime.getYear()))) {
                    ++startYear;
                }
                int endYear = TimeUtil.INSTANCE.asDateTimeUTC(end).getYear();
                LinearBreaksHelper helper = new LinearBreaksHelper(startYear, endYear, count, false, 8, null);
                Iterator<Double> iterator = helper.getBreaks().iterator();
                while (iterator.hasNext()) {
                    double tickYear = ((Number)iterator.next()).doubleValue();
                    DateTime tickDate = TimeUtil.INSTANCE.yearStart((int)Math.rint(tickYear));
                    ((ArrayList)ticks).add(Double.valueOf(TimeUtil.INSTANCE.asInstantUTC(tickDate)));
                }
            } else {
                TimeInterval interval = NiceTimeInterval.INSTANCE.forMillis(step);
                this.formatter = interval.getTickFormatter();
                ticks = CollectionsKt.toMutableList((Collection)interval.range(start, end));
            }
            if (this.isReversed()) {
                CollectionsKt.reverse((List)ticks);
            }
            this.breaks = ticks;
        }
    }

    public /* synthetic */ DateTimeBreaksHelper(double d, double d2, int n, TimeInterval timeInterval, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            timeInterval = null;
        }
        this(d, d2, n, timeInterval);
    }

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }
}

