/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.scale.breaks.WithFiniteOrderedOutput;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\nH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ\u0017\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u0013\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/base/scale/breaks/QuantizeScale;", "T", "Ljetbrains/datalore/plot/base/scale/breaks/WithFiniteOrderedOutput;", "()V", "domainQuantized", "", "Ljetbrains/datalore/base/interval/DoubleSpan;", "getDomainQuantized", "()Ljava/util/List;", "myDomainEnd", "", "myDomainStart", "myHasDomain", "", "myOutputValues", "outputValues", "getOutputValues", "bucketSize", "domain", "start", "end", "getOutputValue", "domainValue", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOutputValueIndex", "", "outputIndex", "v", "quantize", "(D)Ljava/lang/Object;", "range", "values", "", "plot-base-portable"})
public final class QuantizeScale<T>
implements WithFiniteOrderedOutput<T> {
    private boolean myHasDomain;
    private double myDomainStart;
    private double myDomainEnd;
    private List<? extends T> myOutputValues;

    @Override
    @NotNull
    public List<T> getOutputValues() {
        List<T> list2 = this.myOutputValues;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myOutputValues");
            list2 = null;
        }
        return list2;
    }

    @NotNull
    public final List<DoubleSpan> getDomainQuantized() {
        if (this.myDomainStart == this.myDomainEnd) {
            return CollectionsKt.listOf((Object)new DoubleSpan(this.myDomainStart, this.myDomainEnd));
        }
        ArrayList<DoubleSpan> list2 = new ArrayList<DoubleSpan>();
        List<T> list3 = this.myOutputValues;
        if (list3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myOutputValues");
            list3 = null;
        }
        int numBuckets = list3.size();
        double bucketSize = this.bucketSize();
        int n = numBuckets - 1;
        for (int i = 0; i < n; ++i) {
            DoubleSpan bucket = new DoubleSpan(this.myDomainStart + bucketSize * (double)i, this.myDomainStart + bucketSize * (double)(i + 1));
            list2.add(bucket);
        }
        DoubleSpan bucket = new DoubleSpan(this.myDomainStart + bucketSize * (double)(numBuckets - 1), this.myDomainEnd);
        list2.add(bucket);
        return list2;
    }

    @NotNull
    public final QuantizeScale<T> domain(double start, double end) {
        if (!(start <= end)) {
            boolean bl = false;
            String string = "Domain start must be less then domain end: " + start + " > " + end;
            throw new IllegalArgumentException(string.toString());
        }
        this.myHasDomain = true;
        this.myDomainStart = start;
        this.myDomainEnd = end;
        return this;
    }

    @NotNull
    public final QuantizeScale<T> range(@NotNull Collection<? extends T> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.myOutputValues = new ArrayList<T>(values);
        return this;
    }

    public final T quantize(double v) {
        int i = this.outputIndex(v);
        List<T> list2 = this.myOutputValues;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myOutputValues");
            list2 = null;
        }
        return list2.get(i);
    }

    /*
     * Unable to fully structure code
     */
    private final int outputIndex(double v) {
        if (!this.myHasDomain) {
            $i$a$-check-QuantizeScale$outputIndex$1 = false;
            $i$a$-check-QuantizeScale$outputIndex$1 = "Domain not defined.";
            throw new IllegalStateException($i$a$-check-QuantizeScale$outputIndex$1.toString());
        }
        if (this.myOutputValues == null) ** GOTO lbl-1000
        v0 = this.myOutputValues;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myOutputValues");
            v0 = null;
        }
        if (((Collection)v0).isEmpty() == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (!v1) {
            $i$a$-check-QuantizeScale$outputIndex$3 = false;
            var4_5 = "Output values are not defined.";
            throw new IllegalStateException(var4_5.toString());
        }
        bucketSize = this.bucketSize();
        index = (int)((v - this.myDomainStart) / bucketSize);
        v2 = this.myOutputValues;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myOutputValues");
            v2 = null;
        }
        maxIndex = v2.size() - 1;
        return Math.max(0, Math.min(maxIndex, index));
    }

    @Override
    public int getOutputValueIndex(@NotNull Object domainValue) {
        Intrinsics.checkNotNullParameter((Object)domainValue, (String)"domainValue");
        return domainValue instanceof Number ? this.outputIndex(((Number)domainValue).doubleValue()) : -1;
    }

    @Override
    @Nullable
    public T getOutputValue(@NotNull Object domainValue) {
        Intrinsics.checkNotNullParameter((Object)domainValue, (String)"domainValue");
        return domainValue instanceof Number ? (T)this.quantize(((Number)domainValue).doubleValue()) : null;
    }

    private final double bucketSize() {
        List<T> list2 = this.myOutputValues;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myOutputValues");
            list2 = null;
        }
        return (this.myDomainEnd - this.myDomainStart) / (double)list2.size();
    }
}

