/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.breaks;

import jetbrains.datalore.plot.common.text.Formatter;
import jetbrains.datalore.plot.common.time.interval.NiceTimeInterval;
import jetbrains.datalore.plot.common.time.interval.TimeInterval;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/scale/breaks/TimeScaleTickFormatterFactory;", "", "minInterval", "Ljetbrains/datalore/plot/common/time/interval/TimeInterval;", "(Ljetbrains/datalore/plot/common/time/interval/TimeInterval;)V", "formatPattern", "", "step", "", "getFormatter", "Lkotlin/Function1;", "plot-base-portable"})
public final class TimeScaleTickFormatterFactory {
    @Nullable
    private final TimeInterval minInterval;

    public TimeScaleTickFormatterFactory(@Nullable TimeInterval minInterval) {
        this.minInterval = minInterval;
    }

    @NotNull
    public final Function1<Object, String> getFormatter(double step) {
        return Formatter.INSTANCE.time(this.formatPattern(step));
    }

    private final String formatPattern(double step) {
        double end;
        double start;
        int intervalCount;
        int stepCount;
        if (step < 1000.0) {
            return TimeInterval.Companion.milliseconds(1).getTickFormatPattern();
        }
        if (this.minInterval != null && (stepCount = 100) >= (intervalCount = this.minInterval.range(start = 0.0, end = step * (double)stepCount).size())) {
            return this.minInterval.getTickFormatPattern();
        }
        if (step > 3.1536E10) {
            return "%Y";
        }
        TimeInterval interval = NiceTimeInterval.INSTANCE.forMillis(step);
        return interval.getTickFormatPattern();
    }
}

