/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.transform;

import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.scale.transform.FunTransform;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0017\u0010\r\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/Log10Transform;", "Ljetbrains/datalore/plot/base/scale/transform/FunTransform;", "()V", "apply", "", "v", "(Ljava/lang/Double;)Ljava/lang/Double;", "createApplicableDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "middle", "(Ljava/lang/Double;)Ljetbrains/datalore/base/interval/DoubleSpan;", "hasDomainLimits", "", "isInDomain", "(Ljava/lang/Double;)Z", "isZero", "toApplicableDomain", "range", "Companion", "plot-base-portable"})
public final class Log10Transform
extends FunTransform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final double LOWER_LIM_TRANSFOTMED = -1.7976931348623158E307;
    public static final double LOWER_LIM_DOMAIN = 4.9E-323;

    public Log10Transform() {
        super((Function1<? super Double, Double>)((Function1)1.INSTANCE), (Function1<? super Double, Double>)((Function1)2.INSTANCE));
    }

    @Override
    public boolean hasDomainLimits() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInDomain(@Nullable Double v) {
        if (!SeriesUtil.INSTANCE.isFinite(v)) return false;
        Double d = v;
        Intrinsics.checkNotNull((Object)d);
        if (!(d >= 4.9E-323)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isZero(Double v) {
        if (!SeriesUtil.INSTANCE.isFinite(v)) return false;
        Double d = v;
        Intrinsics.checkNotNull((Object)d);
        if (!(d >= 0.0)) return false;
        if (!(v < 4.9E-323)) return false;
        return true;
    }

    @Override
    @Nullable
    public Double apply(@Nullable Double v) {
        return Log10Transform.Companion.trimInfinity(super.apply(v));
    }

    @Override
    @NotNull
    public DoubleSpan createApplicableDomain(@Nullable Double middle) {
        double d;
        if (this.isInDomain(middle)) {
            Double d2 = middle;
            Intrinsics.checkNotNull((Object)d2);
            d = Math.max(d2, 4.9E-323);
        } else {
            d = this.isZero(middle) ? 4.9E-323 : 1.0;
        }
        double middle2 = d;
        double lower = middle2 < 1.0 ? middle2 / (double)2 : middle2 - 0.5;
        return new DoubleSpan(Math.max(lower, 4.9E-323), middle2 + 0.5);
    }

    @Override
    @NotNull
    public DoubleSpan toApplicableDomain(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        double lower = Math.max(range.getLowerEnd(), 4.9E-323);
        double upper = Math.max(range.getUpperEnd(), lower);
        return new DoubleSpan(lower, upper);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/Log10Transform$Companion;", "", "()V", "LOWER_LIM_DOMAIN", "", "LOWER_LIM_TRANSFOTMED", "trimInfinity", "v", "(Ljava/lang/Double;)Ljava/lang/Double;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final Double trimInfinity(Double v) {
            Double d;
            if (v == null) {
                d = null;
            } else if (Double.isNaN(v)) {
                d = Double.NaN;
            } else {
                double d2 = v;
                d = Math.max(-1.7976931348623158E307, d2);
            }
            return d;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

