/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.transform;

import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.scale.transform.FunTransform;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0017\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/SqrtTransform;", "Ljetbrains/datalore/plot/base/scale/transform/FunTransform;", "()V", "createApplicableDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "middle", "", "(Ljava/lang/Double;)Ljetbrains/datalore/base/interval/DoubleSpan;", "hasDomainLimits", "", "isInDomain", "v", "(Ljava/lang/Double;)Z", "toApplicableDomain", "range", "plot-base-portable"})
public final class SqrtTransform
extends FunTransform {
    public SqrtTransform() {
        super((Function1<? super Double, Double>)((Function1)1.INSTANCE), (Function1<? super Double, Double>)((Function1)2.INSTANCE));
    }

    @Override
    public boolean hasDomainLimits() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInDomain(@Nullable Double v) {
        if (!SeriesUtil.INSTANCE.isFinite(v)) return false;
        Double d = v;
        Intrinsics.checkNotNull((Object)d);
        if (!(d >= 0.0)) return false;
        return true;
    }

    @Override
    @NotNull
    public DoubleSpan createApplicableDomain(@Nullable Double middle) {
        double d;
        if (this.isInDomain(middle)) {
            Double d2 = middle;
            Intrinsics.checkNotNull((Object)d2);
            d = Math.max(d2, 0.0);
        } else {
            d = 1.0;
        }
        double middle2 = d;
        return new DoubleSpan(Math.max(middle2 - 0.5, 0.0), middle2 + 0.5);
    }

    @Override
    @NotNull
    public DoubleSpan toApplicableDomain(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        double lower = Math.max(range.getLowerEnd(), 0.0);
        double upper = Math.max(range.getUpperEnd(), 0.0);
        return new DoubleSpan(lower, upper);
    }
}

