/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.BreaksGenerator;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.base.scale.transform.ContinuousTransformWithLimits;
import jetbrains.datalore.plot.base.scale.transform.IdentityTransform;
import jetbrains.datalore.plot.base.scale.transform.LinearBreaksGen;
import jetbrains.datalore.plot.base.scale.transform.Log10Transform;
import jetbrains.datalore.plot.base.scale.transform.NonlinearBreaksGen;
import jetbrains.datalore.plot.base.scale.transform.ReverseTransform;
import jetbrains.datalore.plot.base.scale.transform.SqrtTransform;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0016\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0016\b\u0002\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/Transforms;", "", "()V", "IDENTITY", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "getIDENTITY", "()Ljetbrains/datalore/plot/base/ContinuousTransform;", "LOG10", "getLOG10", "REVERSE", "getREVERSE", "SQRT", "getSQRT", "continuousWithLimits", "actual", "limits", "Lkotlin/Pair;", "", "createBreaksGeneratorForTransformedDomain", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "transform", "labelFormatter", "Lkotlin/Function1;", "", "ensureApplicableDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "dataRange", "BreaksGeneratorForTransformedDomain", "plot-base-portable"})
public final class Transforms {
    @NotNull
    public static final Transforms INSTANCE = new Transforms();
    @NotNull
    private static final ContinuousTransform IDENTITY = new IdentityTransform();
    @NotNull
    private static final ContinuousTransform REVERSE = new ReverseTransform();
    @NotNull
    private static final ContinuousTransform SQRT = new SqrtTransform();
    @NotNull
    private static final ContinuousTransform LOG10 = new Log10Transform();

    private Transforms() {
    }

    @NotNull
    public final ContinuousTransform getIDENTITY() {
        return IDENTITY;
    }

    @NotNull
    public final ContinuousTransform getREVERSE() {
        return REVERSE;
    }

    @NotNull
    public final ContinuousTransform getSQRT() {
        return SQRT;
    }

    @NotNull
    public final ContinuousTransform getLOG10() {
        return LOG10;
    }

    @NotNull
    public final ContinuousTransform continuousWithLimits(@NotNull ContinuousTransform actual, @NotNull Pair<Double, Double> limits) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(limits, (String)"limits");
        return new ContinuousTransformWithLimits(actual, (Double)limits.getFirst(), (Double)limits.getSecond());
    }

    @NotNull
    public final BreaksGenerator createBreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform, @Nullable Function1<Object, String> labelFormatter) {
        BreaksGenerator breaksGenerator;
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Transform transform2 = transform.unwrap();
        if (Intrinsics.areEqual((Object)transform2, (Object)IDENTITY)) {
            breaksGenerator = new LinearBreaksGen(labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)REVERSE)) {
            breaksGenerator = new LinearBreaksGen(labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)SQRT)) {
            breaksGenerator = new NonlinearBreaksGen(SQRT, labelFormatter);
        } else if (Intrinsics.areEqual((Object)transform2, (Object)LOG10)) {
            breaksGenerator = new NonlinearBreaksGen(LOG10, labelFormatter);
        } else {
            throw new IllegalStateException("Unexpected 'transform' type: " + Reflection.getOrCreateKotlinClass(transform.getClass()).getSimpleName());
        }
        BreaksGenerator breaksGenerator2 = breaksGenerator;
        return new BreaksGeneratorForTransformedDomain(transform, breaksGenerator2);
    }

    public static /* synthetic */ BreaksGenerator createBreaksGeneratorForTransformedDomain$default(Transforms transforms, ContinuousTransform continuousTransform, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return transforms.createBreaksGeneratorForTransformedDomain(continuousTransform, (Function1<Object, String>)function1);
    }

    @NotNull
    public final DoubleSpan ensureApplicableDomain(@Nullable DoubleSpan dataRange, @NotNull ContinuousTransform transform) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        if (dataRange == null) {
            return ContinuousTransform.DefaultImpls.createApplicableDomain$default(transform, null, 1, null);
        }
        DoubleSpan domain = transform.toApplicableDomain(dataRange);
        boolean bl = SeriesUtil.INSTANCE.isBeyondPrecision(domain);
        if (bl) {
            doubleSpan = transform.createApplicableDomain(domain.getUpperEnd());
        } else if (!bl) {
            doubleSpan = domain;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return doubleSpan;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/scale/transform/Transforms$BreaksGeneratorForTransformedDomain;", "Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "transform", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "breaksGenerator", "(Ljetbrains/datalore/plot/base/ContinuousTransform;Ljetbrains/datalore/plot/base/scale/BreaksGenerator;)V", "getBreaksGenerator", "()Ljetbrains/datalore/plot/base/scale/BreaksGenerator;", "defaultFormatter", "Lkotlin/Function1;", "", "", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "targetCount", "", "generateBreaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "labelFormatter", "plot-base-portable"})
    public static final class BreaksGeneratorForTransformedDomain
    implements BreaksGenerator {
        @NotNull
        private final ContinuousTransform transform;
        @NotNull
        private final BreaksGenerator breaksGenerator;

        public BreaksGeneratorForTransformedDomain(@NotNull ContinuousTransform transform, @NotNull BreaksGenerator breaksGenerator) {
            Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
            Intrinsics.checkNotNullParameter((Object)breaksGenerator, (String)"breaksGenerator");
            this.transform = transform;
            this.breaksGenerator = breaksGenerator;
        }

        @NotNull
        public final BreaksGenerator getBreaksGenerator() {
            return this.breaksGenerator;
        }

        @Override
        @NotNull
        public Function1<Object, String> labelFormatter(@NotNull DoubleSpan domain, int targetCount) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            return this.breaksGenerator.labelFormatter(domainBeforeTransform, targetCount);
        }

        @Override
        @NotNull
        public Function1<Object, String> defaultFormatter(@NotNull DoubleSpan domain, int targetCount) {
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            return this.breaksGenerator.defaultFormatter(domainBeforeTransform, targetCount);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ScaleBreaks generateBreaks(@NotNull DoubleSpan domain, int targetCount) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            DoubleSpan domainBeforeTransform = ScaleUtil.INSTANCE.applyInverseTransform(domain, this.transform);
            ScaleBreaks scaleBreaks = this.breaksGenerator.generateBreaks(domainBeforeTransform, targetCount);
            List<Object> originalBreaks = scaleBreaks.getDomainValues();
            Iterable $this$map$iv = this.transform.apply(originalBreaks);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Double d = (Double)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = it;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                }
                collection.add(v0.doubleValue());
            }
            List transformedBreaks = (List)destination$iv$iv;
            return new ScaleBreaks(originalBreaks, transformedBreaks, scaleBreaks.getLabels());
        }
    }
}

