/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.FiveNumberSummary;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J;\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\rH\u0016J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0016J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0014\u0010\u0019\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/base/stat/BoxplotStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "whiskerIQRRatio", "", "computeWidth", "", "(DZ)V", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "getDefaultMapping", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "aes", "hasDefaultMapping", "Companion", "plot-base-portable"})
public final class BoxplotStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double whiskerIQRRatio;
    private final boolean computeWidth;
    public static final double DEF_WHISKER_IQR_RATIO = 1.5;
    public static final boolean DEF_COMPUTE_WIDTH = false;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public BoxplotStat(double whiskerIQRRatio, boolean computeWidth) {
        super(DEF_MAPPING);
        this.whiskerIQRRatio = whiskerIQRRatio;
        this.computeWidth = computeWidth;
    }

    @Override
    public boolean hasDefaultMapping(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return super.hasDefaultMapping(aes) || Intrinsics.areEqual(aes, Aes.Companion.getWIDTH()) && this.computeWidth;
    }

    @Override
    @NotNull
    public DataFrame.Variable getDefaultMapping(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return Intrinsics.areEqual(aes, Aes.Companion.getWIDTH()) ? Stats.INSTANCE.getWIDTH() : super.getDefaultMapping(aes);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        int maxCountPerBin;
        Collection<Double> collection;
        List list2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getY()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> ys = data.getNumeric(TransformVar.INSTANCE.getY());
        if (data.has(TransformVar.INSTANCE.getX())) {
            list2 = data.getNumeric(TransformVar.INSTANCE.getX());
        } else {
            int n = ys.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                collection = arrayList;
                boolean bl = false;
                ((ArrayList)collection).add(0.0);
            }
            list2 = arrayList;
        }
        List xs = list2;
        Map<DataFrame.Variable, List<Double>> statData = Companion.buildStat(xs, ys, this.whiskerIQRRatio);
        List<Double> statCount = statData.remove(Stats.INSTANCE.getCOUNT());
        List<Double> list3 = statCount;
        int n = list3 != null && (list3 = CollectionsKt.maxOrNull((Iterable)list3)) != null ? (int)((Double)((Object)list3)).doubleValue() : (maxCountPerBin = 0);
        if (maxCountPerBin == 0) {
            return this.withEmptyStatValues();
        }
        if (this.computeWidth) {
            void $this$mapTo$iv$iv;
            double norm = Math.sqrt(maxCountPerBin);
            List<Double> list4 = statCount;
            Intrinsics.checkNotNull(list4);
            Iterable $this$map$iv = list4;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void count;
                double d = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Math.sqrt((double)count) / norm);
            }
            List statWidth = (List)destination$iv$iv;
            statData.put(Stats.INSTANCE.getWIDTH(), statWidth);
        }
        DataFrame.Builder builder = new DataFrame.Builder();
        for (Map.Entry<DataFrame.Variable, List<Double>> entry : statData.entrySet()) {
            DataFrame.Variable variable = entry.getKey();
            List<Double> series = entry.getValue();
            builder.putNumeric(variable, series);
        }
        return builder.build();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getYMIN(), (Object)Stats.INSTANCE.getY_MIN()), TuplesKt.to(Aes.Companion.getYMAX(), (Object)Stats.INSTANCE.getY_MAX()), TuplesKt.to(Aes.Companion.getLOWER(), (Object)Stats.INSTANCE.getLOWER()), TuplesKt.to(Aes.Companion.getMIDDLE(), (Object)Stats.INSTANCE.getMIDDLE()), TuplesKt.to(Aes.Companion.getUPPER(), (Object)Stats.INSTANCE.getUPPER())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r0\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\r2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\r2\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/base/stat/BoxplotStat$Companion;", "", "()V", "DEF_COMPUTE_WIDTH", "", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_WHISKER_IQR_RATIO", "", "buildStat", "", "", "xs", "ys", "whiskerIQRRatio", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<DataFrame.Variable, List<Double>> buildStat(@NotNull List<Double> xs, @NotNull List<Double> ys, double whiskerIQRRatio) {
            Pair $this$filterTo$iv$iv2;
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            Iterable $this$filter$iv = CollectionsKt.zip((Iterable)xs, (Iterable)ys);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Double y;
                Pair pair = (Pair)element$iv$iv;
                boolean bl = false;
                Double x = (Double)pair.component1();
                if (!SeriesUtil.INSTANCE.allFinite(x, y = (Double)pair.component2())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List xyPairs = (List)destination$iv$iv;
            if (xyPairs.isEmpty()) {
                return new LinkedHashMap();
            }
            Map binnedData = new HashMap();
            for (Pair $this$filterTo$iv$iv2 : xyPairs) {
                Object object;
                Double key$iv;
                void $this$getOrPut$iv;
                Double x = (Double)$this$filterTo$iv$iv2.component1();
                Double y = (Double)$this$filterTo$iv$iv2.component2();
                Map map = binnedData;
                Intrinsics.checkNotNull((Object)x);
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List list2 = (List)object;
                Double d = y;
                Intrinsics.checkNotNull((Object)d);
                list2.add(d);
            }
            ArrayList<Double> statX = new ArrayList<Double>();
            ArrayList<Double> statY = new ArrayList<Double>();
            ArrayList<Double> statMiddle = new ArrayList<Double>();
            ArrayList<Double> statLower = new ArrayList<Double>();
            ArrayList<Double> statUpper = new ArrayList<Double>();
            ArrayList<Double> statMin = new ArrayList<Double>();
            ArrayList<Double> statMax = new ArrayList<Double>();
            ArrayList<Double> statCount = new ArrayList<Double>();
            for (Map.Entry entry : binnedData.entrySet()) {
                double y;
                Iterable $this$filterTo$iv$iv3;
                boolean $i$f$filterTo2;
                Collection destination$iv$iv2;
                boolean $i$f$filter2;
                Iterable $this$filter$iv2;
                double x = ((Number)entry.getKey()).doubleValue();
                List bin = (List)entry.getValue();
                double count = bin.size();
                FiveNumberSummary summary = new FiveNumberSummary(bin);
                double middle = summary.getMedian();
                double lowerHinge = summary.getFirstQuartile();
                double upperHinge = summary.getThirdQuartile();
                double IQR = upperHinge - lowerHinge;
                double lowerFence = lowerHinge - IQR * whiskerIQRRatio;
                double upperFence = upperHinge + IQR * whiskerIQRRatio;
                double lowerWhisker = lowerFence;
                double upperWhisker = upperFence;
                if (SeriesUtil.INSTANCE.allFinite(Double.valueOf(lowerFence), Double.valueOf(upperFence))) {
                    $this$filter$iv2 = bin;
                    $i$f$filter2 = false;
                    Iterable iterable2 = $this$filter$iv2;
                    destination$iv$iv2 = new ArrayList();
                    $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                        y = ((Number)element$iv$iv).doubleValue();
                        boolean bl = false;
                        if (!(y >= lowerFence && y <= upperFence)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List boxed = (List)destination$iv$iv2;
                    DoubleSpan range = SeriesUtil.INSTANCE.range((Iterable)boxed);
                    if (range != null) {
                        lowerWhisker = range.getLowerEnd();
                        upperWhisker = range.getUpperEnd();
                    }
                }
                $this$filter$iv2 = bin;
                $i$f$filter2 = false;
                $this$filterTo$iv$iv3 = $this$filter$iv2;
                destination$iv$iv2 = new ArrayList();
                $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    y = ((Number)element$iv$iv).doubleValue();
                    boolean bl = false;
                    if (!(y < lowerFence || y > upperFence)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List outliers = (List)destination$iv$iv2;
                Iterator iterator = outliers.iterator();
                while (iterator.hasNext()) {
                    double y2 = ((Number)iterator.next()).doubleValue();
                    statX.add(x);
                    statY.add(y2);
                    statMiddle.add(Double.NaN);
                    statLower.add(Double.NaN);
                    statUpper.add(Double.NaN);
                    statMin.add(Double.NaN);
                    statMax.add(Double.NaN);
                    statCount.add(count);
                }
                statX.add(x);
                statY.add(Double.NaN);
                statMiddle.add(middle);
                statLower.add(lowerHinge);
                statUpper.add(upperHinge);
                statMin.add(lowerWhisker);
                statMax.add(upperWhisker);
                statCount.add(count);
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), statX), TuplesKt.to((Object)Stats.INSTANCE.getY(), statY), TuplesKt.to((Object)Stats.INSTANCE.getMIDDLE(), statMiddle), TuplesKt.to((Object)Stats.INSTANCE.getLOWER(), statLower), TuplesKt.to((Object)Stats.INSTANCE.getUPPER(), statUpper), TuplesKt.to((Object)Stats.INSTANCE.getY_MIN(), statMin), TuplesKt.to((Object)Stats.INSTANCE.getY_MAX(), statMax), TuplesKt.to((Object)Stats.INSTANCE.getCOUNT(), statCount)};
            return MapsKt.mutableMapOf((Pair[])pairArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

