/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.stat.ContourStatUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005JJ\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002J6\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00102\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002JT\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u00102\u001e\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\r0\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\rJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourFillHelper;", "", "xRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "yRange", "(Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/base/interval/DoubleSpan;)V", "myLowLeft", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myLowRight", "myUpLeft", "myUpRight", "createClosedPolygonLevels", "", "", "openLevels", "outerMap", "", "cornerPoints", "createOuterMap", "paths", "createPolygons", "", "pathByLevels", "levels", "fillLevels", "getKind", "Ljetbrains/datalore/plot/base/stat/ContourFillHelper$BorderKind;", "point", "BorderKind", "Companion", "plot-base-portable"})
public final class ContourFillHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector myLowLeft;
    @NotNull
    private final DoubleVector myLowRight;
    @NotNull
    private final DoubleVector myUpLeft;
    @NotNull
    private final DoubleVector myUpRight;

    public ContourFillHelper(@NotNull DoubleSpan xRange, @NotNull DoubleSpan yRange) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        double xMin = xRange.getLowerEnd();
        double xMax = xRange.getUpperEnd();
        double yMin = yRange.getLowerEnd();
        double yMax = yRange.getUpperEnd();
        this.myLowLeft = new DoubleVector(xMin, yMin);
        this.myLowRight = new DoubleVector(xMax, yMin);
        this.myUpLeft = new DoubleVector(xMin, yMax);
        this.myUpRight = new DoubleVector(xMax, yMax);
    }

    @NotNull
    public final Map<Double, List<DoubleVector>> createPolygons(@NotNull Map<Double, ? extends List<? extends List<DoubleVector>>> pathByLevels, @NotNull List<Double> levels, @NotNull List<Double> fillLevels) {
        Intrinsics.checkNotNullParameter(pathByLevels, (String)"pathByLevels");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        Intrinsics.checkNotNullParameter(fillLevels, (String)"fillLevels");
        HashMap result = new HashMap();
        ArrayList allPaths = new ArrayList();
        for (List<? extends List<DoubleVector>> list2 : pathByLevels.values()) {
            allPaths.addAll(list2);
        }
        ArrayList cornerPoints = new ArrayList();
        Map<DoubleVector, DoubleVector> map = this.createOuterMap(allPaths, cornerPoints);
        int n = pathByLevels.keySet().size();
        int n2 = n + 1;
        for (int i = 0; i < n2; ++i) {
            List<List<DoubleVector>> polygonPieces = new ArrayList();
            ArrayList value = new ArrayList();
            if (i > 0) {
                List<? extends List<DoubleVector>> list3 = pathByLevels.get(levels.get(i - 1));
                Intrinsics.checkNotNull(list3);
                polygonPieces.addAll(ContourFillHelper.Companion.reverseAll(list3));
            }
            if (i < n) {
                List<? extends List<DoubleVector>> list4 = pathByLevels.get(levels.get(i));
                Intrinsics.checkNotNull(list4);
                polygonPieces.addAll((Collection<List<DoubleVector>>)list4);
            }
            polygonPieces = this.createClosedPolygonLevels((List<? extends List<DoubleVector>>)polygonPieces, map, cornerPoints);
            for (List<DoubleVector> path : polygonPieces) {
                value.addAll(path);
            }
            ((Map)result).put(fillLevels.get(i), value);
        }
        return result;
    }

    private final List<List<DoubleVector>> createClosedPolygonLevels(List<? extends List<DoubleVector>> openLevels, Map<DoubleVector, DoubleVector> outerMap, List<DoubleVector> cornerPoints) {
        DoubleVector p1;
        DoubleVector p0;
        ArrayList<List> result = new ArrayList<List>();
        HashSet donePath = new HashSet();
        for (List<DoubleVector> list2 : openLevels) {
            DoubleVector pi2;
            ArrayList<DoubleVector> arrayList = new ArrayList<DoubleVector>((Collection)list2);
            p0 = (DoubleVector)arrayList.get(0);
            if (Intrinsics.areEqual((Object)p0, (Object)(p1 = (DoubleVector)arrayList.get(arrayList.size() - 1)))) {
                result.add(arrayList);
                continue;
            }
            Intrinsics.checkNotNull((Object)outerMap.get(p1));
            arrayList.add(pi2);
            p1 = pi2;
            while (cornerPoints.contains(p1)) {
                Intrinsics.checkNotNull((Object)outerMap.get(p1));
                arrayList.add(pi2);
                p1 = pi2;
            }
            donePath.add(arrayList);
        }
        HashMap pathByEndPoint = new HashMap();
        for (List list3 : donePath) {
            p0 = (DoubleVector)list3.get(0);
            if (Intrinsics.areEqual((Object)p0, (Object)(p1 = (DoubleVector)list3.get(list3.size() - 1)))) {
                result.add(list3);
                continue;
            }
            if (pathByEndPoint.containsKey(p0) || pathByEndPoint.containsKey(p1)) {
                List path0 = (List)pathByEndPoint.get(p0);
                List path1 = (List)pathByEndPoint.get(p1);
                ContourStatUtil.INSTANCE.removePathByEndpoints$plot_base_portable(path0, pathByEndPoint);
                ContourStatUtil.INSTANCE.removePathByEndpoints$plot_base_portable(path1, pathByEndPoint);
                List longPath = null;
                if (path0 == path1) {
                    List list4 = path0;
                    Intrinsics.checkNotNull((Object)list4);
                    list4.addAll(list3.subList(1, list3.size()));
                    result.add(path0);
                    continue;
                }
                if (path0 != null && path1 != null) {
                    longPath = path0;
                    longPath.addAll(list3.subList(1, list3.size() - 1));
                    longPath.addAll(path1);
                } else if (path0 == null) {
                    List list5 = path1;
                    Intrinsics.checkNotNull((Object)list5);
                    longPath = list5;
                    longPath.addAll(0, list3.subList(0, list3.size() - 1));
                } else {
                    longPath = path0;
                    longPath.addAll(list3.subList(1, list3.size()));
                }
                ((Map)pathByEndPoint).put(longPath.get(0), longPath);
                ((Map)pathByEndPoint).put(longPath.get(longPath.size() - 1), longPath);
                continue;
            }
            Map map = pathByEndPoint;
            Object e = list3.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"path");
            map.put(e, list3);
            ((Map)pathByEndPoint).put(list3.get(list3.size() - 1), list3);
        }
        if (!pathByEndPoint.keySet().isEmpty()) {
            throw new IllegalArgumentException("Some paths are not cleared yet there is something wrong!" + pathByEndPoint.keySet().size());
        }
        for (List list6 : result) {
            if (Intrinsics.areEqual(list6.get(0), list6.get(list6.size() - 1))) continue;
            throw new IllegalArgumentException("The polygons are not entirely closed!");
        }
        return result;
    }

    private final Map<DoubleVector, DoubleVector> createOuterMap(List<? extends List<DoubleVector>> paths, List<DoubleVector> cornerPoints) {
        ArrayList<DoubleVector> points2 = new ArrayList<DoubleVector>();
        for (List<DoubleVector> list2 : paths) {
            if (Intrinsics.areEqual((Object)list2.get(0), (Object)list2.get(list2.size() - 1))) continue;
            points2.add(list2.get(0));
            points2.add(list2.get(list2.size() - 1));
        }
        HashMap result = new HashMap();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            arrayList.add(new ArrayList());
        }
        for (DoubleVector point : points2) {
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"point");
            BorderKind kind = this.getKind(point);
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    ((List)arrayList.get(0)).add(point);
                    break;
                }
                case 2: {
                    ((List)arrayList.get(1)).add(point);
                    break;
                }
                case 3: {
                    ((List)arrayList.get(2)).add(point);
                    break;
                }
                case 4: {
                    ((List)arrayList.get(3)).add(point);
                }
            }
        }
        Object e = arrayList.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"list[0]");
        CollectionsKt.sortWith((List)((List)e), ContourFillHelper::createOuterMap$lambda-0);
        Object e2 = arrayList.get(1);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"list[1]");
        CollectionsKt.sortWith((List)((List)e2), ContourFillHelper::createOuterMap$lambda-1);
        Object e3 = arrayList.get(2);
        Intrinsics.checkNotNullExpressionValue(e3, (String)"list[2]");
        CollectionsKt.sortWith((List)((List)e3), ContourFillHelper::createOuterMap$lambda-2);
        Object e4 = arrayList.get(3);
        Intrinsics.checkNotNullExpressionValue(e4, (String)"list[3]");
        CollectionsKt.sortWith((List)((List)e4), ContourFillHelper::createOuterMap$lambda-3);
        ArrayList<Object> prepareMap = new ArrayList<Object>();
        if (!((List)arrayList.get(0)).contains(this.myLowLeft)) {
            prepareMap.add(this.myLowLeft);
            cornerPoints.add(this.myLowLeft);
        }
        prepareMap.addAll((Collection)arrayList.get(0));
        if (!((List)arrayList.get(0)).contains(this.myLowRight)) {
            prepareMap.add(this.myLowRight);
            cornerPoints.add(this.myLowRight);
        }
        prepareMap.addAll((Collection)arrayList.get(1));
        if (!((List)arrayList.get(1)).contains(this.myUpRight)) {
            prepareMap.add(this.myUpRight);
            cornerPoints.add(this.myUpRight);
        }
        prepareMap.addAll((Collection)arrayList.get(2));
        if (!((List)arrayList.get(3)).contains(this.myUpLeft)) {
            prepareMap.add(this.myUpLeft);
            cornerPoints.add(this.myUpLeft);
        }
        prepareMap.addAll((Collection)arrayList.get(3));
        prepareMap.add(prepareMap.get(0));
        int n = prepareMap.size() - 1;
        for (int i = 0; i < n; ++i) {
            Object e5;
            Object e6;
            Map map = result;
            Intrinsics.checkNotNullExpressionValue(prepareMap.get(i), (String)"prepareMap[i]");
            Intrinsics.checkNotNullExpressionValue(prepareMap.get(i + 1), (String)"prepareMap[i + 1]");
            map.put(e6, e5);
        }
        return result;
    }

    private final BorderKind getKind(DoubleVector point) {
        BorderKind borderKind;
        if (ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point) && ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point)) {
            borderKind = BorderKind.DOWN;
        } else if (ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point) && !ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point)) {
            borderKind = BorderKind.RIGHT;
        } else if (!ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point) && !ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point)) {
            borderKind = BorderKind.UP;
        } else if (!ContourFillHelper.Companion.belowOrOnLine(this.myLowLeft, this.myUpRight, point) && ContourFillHelper.Companion.belowOrOnLine(this.myUpLeft, this.myLowRight, point)) {
            borderKind = BorderKind.LEFT;
        } else {
            throw new IllegalArgumentException("The Contour Point is not on the border " + point);
        }
        return borderKind;
    }

    private static final int createOuterMap$lambda-0(DoubleVector o1, DoubleVector o2) {
        return Double.compare(o1.getX(), o2.getX());
    }

    private static final int createOuterMap$lambda-1(DoubleVector o1, DoubleVector o2) {
        return Double.compare(o1.getY(), o2.getY());
    }

    private static final int createOuterMap$lambda-2(DoubleVector o1, DoubleVector o2) {
        return Double.compare(o2.getX(), o1.getX());
    }

    private static final int createOuterMap$lambda-3(DoubleVector o1, DoubleVector o2) {
        return Double.compare(o2.getY(), o1.getY());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourFillHelper$BorderKind;", "", "(Ljava/lang/String;I)V", "DOWN", "RIGHT", "UP", "LEFT", "plot-base-portable"})
    private static final class BorderKind
    extends Enum<BorderKind> {
        public static final /* enum */ BorderKind DOWN = new BorderKind();
        public static final /* enum */ BorderKind RIGHT = new BorderKind();
        public static final /* enum */ BorderKind UP = new BorderKind();
        public static final /* enum */ BorderKind LEFT = new BorderKind();
        private static final /* synthetic */ BorderKind[] $VALUES;

        public static BorderKind[] values() {
            return (BorderKind[])$VALUES.clone();
        }

        public static BorderKind valueOf(String value) {
            return Enum.valueOf(BorderKind.class, value);
        }

        static {
            $VALUES = borderKindArray = new BorderKind[]{BorderKind.DOWN, BorderKind.RIGHT, BorderKind.UP, BorderKind.LEFT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ.\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\n0\n\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\n0\nH\u0002\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourFillHelper$Companion;", "", "()V", "belowOrOnLine", "", "a", "Ljetbrains/datalore/base/geometry/DoubleVector;", "b", "test", "computeFillLevels", "", "", "zRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "levels", "reverseAll", "E", "list", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Double> computeFillLevels(@NotNull DoubleSpan zRange, @NotNull List<Double> levels) {
            Intrinsics.checkNotNullParameter((Object)zRange, (String)"zRange");
            Intrinsics.checkNotNullParameter(levels, (String)"levels");
            ArrayList<Double> fillLevels = new ArrayList<Double>();
            fillLevels.add(zRange.getLowerEnd());
            int n = levels.size() - 1;
            for (int i = 0; i < n; ++i) {
                fillLevels.add((((Number)levels.get(i)).doubleValue() + ((Number)levels.get(i + 1)).doubleValue()) / 2.0);
            }
            fillLevels.add(zRange.getUpperEnd());
            return fillLevels;
        }

        private final <E> List<List<E>> reverseAll(List<? extends List<? extends E>> list2) {
            ArrayList result = new ArrayList();
            for (List<E> list3 : list2) {
                ArrayList copy = new ArrayList(list3);
                CollectionsKt.reverse((List)copy);
                result.add(copy);
            }
            return result;
        }

        private final boolean belowOrOnLine(DoubleVector a, DoubleVector b, DoubleVector test) {
            DoubleVector value = test.subtract(a);
            DoubleVector standard = b.subtract(a);
            return standard.getY() * value.getX() - value.getY() * standard.getX() >= 0.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BorderKind.values().length];
            nArray[BorderKind.DOWN.ordinal()] = 1;
            nArray[BorderKind.RIGHT.ordinal()] = 2;
            nArray[BorderKind.UP.ordinal()] = 3;
            nArray[BorderKind.LEFT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

