/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.AbstractDensity2dStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.stat.Contour;
import jetbrains.datalore.plot.base.stat.ContourStatUtil;
import jetbrains.datalore.plot.base.stat.DensityStat;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.stat.math3.BlockRealMatrix;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001BY\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018H\u0016\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/base/stat/Density2dStat;", "Ljetbrains/datalore/plot/base/stat/AbstractDensity2dStat;", "bandWidthX", "", "bandWidthY", "bandWidthMethod", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "adjust", "kernel", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "nX", "", "nY", "isContour", "", "binCount", "binWidth", "(Ljava/lang/Double;Ljava/lang/Double;Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;DLjetbrains/datalore/plot/base/stat/DensityStat$Kernel;IIZID)V", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "plot-base-portable"})
public final class Density2dStat
extends AbstractDensity2dStat {
    public Density2dStat(@Nullable Double bandWidthX, @Nullable Double bandWidthY, @NotNull DensityStat.BandWidthMethod bandWidthMethod, double adjust, @NotNull DensityStat.Kernel kernel2, int nX, int nY, boolean isContour, int binCount, double binWidth) {
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        super(bandWidthX, bandWidthY, bandWidthMethod, adjust, kernel2, nX, nY, isContour, binCount, binWidth);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> xVector = data.getNumeric(TransformVar.INSTANCE.getX());
        List<Double> yVector = data.getNumeric(TransformVar.INSTANCE.getY());
        if (xVector.isEmpty()) {
            return DataFrame.Builder.Companion.emptyFrame();
        }
        if (xVector.size() != yVector.size()) {
            throw new RuntimeException("len(x)= " + xVector.size() + " and len(y)= " + yVector.size() + " doesn't match!");
        }
        DoubleSpan xRange = statCtx.overallXRange();
        DoubleSpan yRange = statCtx.overallYRange();
        ArrayList<Double> statX = new ArrayList<Double>();
        ArrayList<Double> statY = new ArrayList<Double>();
        ArrayList<Double> statDensity = new ArrayList<Double>();
        double[] bandWidth = new double[]{this.getBandWidthX(xVector), this.getBandWidthY(yVector)};
        DoubleSpan doubleSpan = xRange;
        Intrinsics.checkNotNull((Object)doubleSpan);
        List<Double> stepsX = DensityStatUtil.INSTANCE.createStepValues(doubleSpan, this.getNX());
        DoubleSpan doubleSpan2 = yRange;
        Intrinsics.checkNotNull((Object)doubleSpan2);
        List<Double> stepsY = DensityStatUtil.INSTANCE.createStepValues(doubleSpan2, this.getNY());
        List<Double> groupWeight = BinStatUtil.INSTANCE.weightVector(xVector.size(), data);
        BlockRealMatrix matrixX = new BlockRealMatrix(DensityStatUtil.INSTANCE.createRawMatrix(xVector, stepsX, this.getKernelFun(), bandWidth[0], this.getAdjust(), groupWeight));
        BlockRealMatrix matrixY = new BlockRealMatrix(DensityStatUtil.INSTANCE.createRawMatrix(yVector, stepsY, this.getKernelFun(), bandWidth[1], this.getAdjust(), groupWeight));
        BlockRealMatrix matrixFinal = matrixY.multiply(matrixX.transpose());
        int n = this.getNY();
        for (int row = 0; row < n; ++row) {
            int n2 = this.getNX();
            for (int col = 0; col < n2; ++col) {
                statX.add(stepsX.get(col));
                statY.add(stepsY.get(row));
                statDensity.add(matrixFinal.getEntry(row, col) / SeriesUtil.INSTANCE.sum(groupWeight));
            }
        }
        if (this.isContour()) {
            DoubleSpan zRange = SeriesUtil.INSTANCE.range((Iterable)statDensity);
            List<Double> list2 = ContourStatUtil.INSTANCE.computeLevels(zRange, this.getBinOptions());
            if (list2 == null) {
                return DataFrame.Builder.Companion.emptyFrame();
            }
            List<Double> levels = list2;
            Map<Double, List<List<DoubleVector>>> pathListByLevel = ContourStatUtil.INSTANCE.computeContours(xRange, yRange, this.getNX(), this.getNY(), (List<Double>)statDensity, levels);
            return Contour.Companion.getPathDataFrame(levels, pathListByLevel);
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), (List<Double>)statX).putNumeric(Stats.INSTANCE.getY(), (List<Double>)statY).putNumeric(Stats.INSTANCE.getDENSITY(), (List<Double>)statDensity).build();
    }
}

