/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.stat.DensityStat;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.FiveNumberSummary;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tJc\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018Ja\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJY\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\"JY\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b$J\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u000f\u001a\u00020\u001cJ\u0016\u0010&\u001a\u00020\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0002J\u000e\u0010(\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020)J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStatUtil;", "", "()V", "DEF_STEP_SIZE", "", "bandWidth", "bw", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "valuesX", "", "createRawMatrix", "", "", "values", "list", "ker", "Lkotlin/Function1;", "ad", "weight", "(Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function1;DDLjava/util/List;)[[D", "createStepValues", "range", "Ljetbrains/datalore/base/interval/DoubleSpan;", "n", "", "densityFunction", "weights", "bwMethod", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "fullScanMax", "densityFunction$plot_base_portable", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Double;Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;DLjetbrains/datalore/plot/base/stat/DensityStat$Kernel;I)Lkotlin/jvm/functions/Function1;", "densityFunctionFast", "xs", "densityFunctionFast$plot_base_portable", "densityFunctionFullScan", "densityFunctionFullScan$plot_base_portable", "kernel", "stdDev", "data", "toBandWidthMethod", "", "toKernel", "method", "plot-base-portable"})
public final class DensityStatUtil {
    @NotNull
    public static final DensityStatUtil INSTANCE = new DensityStatUtil();
    private static final double DEF_STEP_SIZE = 0.5;

    private DensityStatUtil() {
    }

    private final double stdDev(List<Double> data) {
        double sum = 0.0;
        double counter = 0.0;
        Iterator<Double> iterator = data.iterator();
        while (iterator.hasNext()) {
            double i = ((Number)iterator.next()).doubleValue();
            sum += i;
        }
        double mean = sum / (double)data.size();
        Iterator<Double> iterator2 = data.iterator();
        while (iterator2.hasNext()) {
            double i = ((Number)iterator2.next()).doubleValue();
            counter += Math.pow(i - mean, 2.0);
        }
        return Math.sqrt(counter / (double)data.size());
    }

    /*
     * WARNING - void declaration
     */
    public final double bandWidth(@NotNull DensityStat.BandWidthMethod bw, @NotNull List<Double> valuesX) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)bw), (String)"bw");
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        int mySize = valuesX.size();
        Iterable $this$filter$iv = valuesX;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Double it = (Double)element$iv$iv;
            boolean bl = false;
            if (!SeriesUtil.INSTANCE.isFinite(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valuesXFinite = (List)destination$iv$iv;
        FiveNumberSummary dataSummary = new FiveNumberSummary(valuesXFinite);
        double myIQR = dataSummary.getThirdQuartile() - dataSummary.getFirstQuartile();
        double myStdD = this.stdDev(valuesXFinite);
        switch (WhenMappings.$EnumSwitchMapping$0[bw.ordinal()]) {
            case 1: {
                if (myIQR > 0.0) {
                    return 0.9 * Math.min(myStdD, myIQR / 1.34) * Math.pow(mySize, -0.2);
                }
                if (!(myStdD > 0.0)) break;
                return 0.9 * myStdD * Math.pow(mySize, -0.2);
            }
            case 2: {
                if (myIQR > 0.0) {
                    return 1.06 * Math.min(myStdD, myIQR / 1.34) * Math.pow(mySize, -0.2);
                }
                if (!(myStdD > 0.0)) break;
                return 1.06 * myStdD * Math.pow(mySize, -0.2);
            }
        }
        return 1.0;
    }

    @NotNull
    public final Function1<Double, Double> kernel(@NotNull DensityStat.Kernel ker) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)((Object)ker), (String)"ker");
        switch (WhenMappings.$EnumSwitchMapping$1[ker.ordinal()]) {
            case 1: {
                function1 = kernel.1.INSTANCE;
                break;
            }
            case 2: {
                function1 = kernel.2.INSTANCE;
                break;
            }
            case 3: {
                function1 = kernel.3.INSTANCE;
                break;
            }
            case 4: {
                function1 = kernel.4.INSTANCE;
                break;
            }
            case 5: {
                function1 = kernel.5.INSTANCE;
                break;
            }
            case 6: {
                function1 = kernel.6.INSTANCE;
                break;
            }
            default: {
                function1 = kernel.7.INSTANCE;
            }
        }
        return function1;
    }

    @NotNull
    public final Function1<Double, Double> densityFunction$plot_base_portable(@NotNull List<Double> values, @NotNull List<Double> weights, @Nullable Double bw, @NotNull DensityStat.BandWidthMethod bwMethod, double ad, @NotNull DensityStat.Kernel ker, int fullScanMax) {
        Function1<Double, Double> function1;
        boolean bl;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)((Object)bwMethod), (String)"bwMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)ker), (String)"ker");
        Double d = bw;
        double bandWidth = d != null ? d.doubleValue() : this.bandWidth(bwMethod, values);
        Function1<Double, Double> kernelFun = this.kernel(ker);
        boolean bl2 = bl = values.size() <= fullScanMax;
        if (bl) {
            function1 = this.densityFunctionFullScan$plot_base_portable(values, weights, kernelFun, bandWidth, ad);
        } else if (!bl) {
            function1 = this.densityFunctionFast$plot_base_portable(values, weights, kernelFun, bandWidth, ad);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return function1;
    }

    @NotNull
    public final Function1<Double, Double> densityFunctionFullScan$plot_base_portable(@NotNull List<Double> xs, @NotNull List<Double> weights, @NotNull Function1<? super Double, Double> ker, double bw, double ad) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        double h = bw * ad;
        return (Function1)new Function1<Double, Double>(xs, ker, h, weights){
            final /* synthetic */ List<Double> $xs;
            final /* synthetic */ Function1<Double, Double> $ker;
            final /* synthetic */ double $h;
            final /* synthetic */ List<Double> $weights;
            {
                this.$xs = $xs;
                this.$ker = $ker;
                this.$h = $h;
                this.$weights = $weights;
                super(1);
            }

            @NotNull
            public final Double invoke(double x) {
                double sum = 0.0;
                int n = this.$xs.size();
                for (int i = 0; i < n; ++i) {
                    sum += ((Number)this.$ker.invoke((Object)((x - ((Number)this.$xs.get(i)).doubleValue()) / this.$h))).doubleValue() * ((Number)this.$weights.get(i)).doubleValue();
                }
                return sum / this.$h;
            }
        };
    }

    @NotNull
    public final Function1<Double, Double> densityFunctionFast$plot_base_portable(@NotNull List<Double> xs, @NotNull List<Double> weights, @NotNull Function1<? super Double, Double> ker, double bw, double ad) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        double h = bw * ad;
        double cutoff = h * (double)5;
        return (Function1)new Function1<Double, Double>(xs, cutoff, ker, h, weights){
            final /* synthetic */ List<Double> $xs;
            final /* synthetic */ double $cutoff;
            final /* synthetic */ Function1<Double, Double> $ker;
            final /* synthetic */ double $h;
            final /* synthetic */ List<Double> $weights;
            {
                this.$xs = $xs;
                this.$cutoff = $cutoff;
                this.$ker = $ker;
                this.$h = $h;
                this.$weights = $weights;
                super(1);
            }

            @NotNull
            public final Double invoke(double x) {
                int to;
                double sum = 0.0;
                int from = CollectionsKt.binarySearch$default(this.$xs, (Comparable)Double.valueOf(x - this.$cutoff), (int)0, (int)0, (int)6, null);
                if (from < 0) {
                    from = -from - 1;
                }
                if ((to = CollectionsKt.binarySearch$default(this.$xs, (Comparable)Double.valueOf(x + this.$cutoff), (int)0, (int)0, (int)6, null)) < 0) {
                    to = -to - 1;
                }
                int n = to;
                for (int i = from; i < n; ++i) {
                    sum += ((Number)this.$ker.invoke((Object)((x - ((Number)this.$xs.get(i)).doubleValue()) / this.$h))).doubleValue() * ((Number)this.$weights.get(i)).doubleValue();
                }
                return sum / this.$h;
            }
        };
    }

    @NotNull
    public final List<Double> createStepValues(@NotNull DoubleSpan range, int n) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        ArrayList<Double> x = new ArrayList<Double>();
        double min = range.getLowerEnd();
        double max = range.getUpperEnd();
        double step = 0.0;
        if (max == min) {
            max += 0.5;
            min -= 0.5;
        }
        step = (max - min) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            x.add(min + step * (double)i);
        }
        return x;
    }

    @NotNull
    public final DensityStat.Kernel toKernel(@NotNull String method) {
        DensityStat.Kernel kernel2;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method) {
            case "gaussian": {
                kernel2 = DensityStat.Kernel.GAUSSIAN;
                break;
            }
            case "uniform": 
            case "rectangular": {
                kernel2 = DensityStat.Kernel.RECTANGULAR;
                break;
            }
            case "triangular": {
                kernel2 = DensityStat.Kernel.TRIANGULAR;
                break;
            }
            case "quartic": 
            case "biweight": {
                kernel2 = DensityStat.Kernel.BIWEIGHT;
                break;
            }
            case "epanechikov": 
            case "parabolic": {
                kernel2 = DensityStat.Kernel.EPANECHNIKOV;
                break;
            }
            case "optcosine": {
                kernel2 = DensityStat.Kernel.OPTCOSINE;
                break;
            }
            case "cosine": {
                kernel2 = DensityStat.Kernel.COSINE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported kernel method: '" + method + "'.\nUse one of: gaussian, rectangular, triangular, biweight, epanechikov, optcosine, cos.");
            }
        }
        return kernel2;
    }

    @NotNull
    public final DensityStat.BandWidthMethod toBandWidthMethod(@NotNull String bw) {
        DensityStat.BandWidthMethod bandWidthMethod;
        Intrinsics.checkNotNullParameter((Object)bw, (String)"bw");
        String string = bw;
        if (Intrinsics.areEqual((Object)string, (Object)"nrd0")) {
            bandWidthMethod = DensityStat.BandWidthMethod.NRD0;
        } else if (Intrinsics.areEqual((Object)string, (Object)"nrd")) {
            bandWidthMethod = DensityStat.BandWidthMethod.NRD;
        } else {
            throw new IllegalArgumentException("Unsupported bandwidth method: '" + bw + "'.\nUse one of: nrd0, nrd.");
        }
        return bandWidthMethod;
    }

    @NotNull
    public final double[][] createRawMatrix(@NotNull List<Double> values, @NotNull List<Double> list2, @NotNull Function1<? super Double, Double> ker, double bw, double ad, @NotNull List<Double> weight) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        Intrinsics.checkNotNullParameter(weight, (String)"weight");
        double a = bw * ad;
        int n = values.size();
        int x = list2.size();
        int n2 = 0;
        double[][] dArrayArray = new double[x][];
        while (n2 < x) {
            int n3 = n2++;
            dArrayArray[n3] = new double[n];
        }
        double[][] result = dArrayArray;
        for (int row = 0; row < x; ++row) {
            for (int col = 0; col < n; ++col) {
                double[] dArray = result[row];
                double d = ((Number)list2.get(row)).doubleValue();
                Double d2 = values.get(col);
                Intrinsics.checkNotNull((Object)d2);
                double d3 = ((Number)ker.invoke((Object)((d - ((Number)d2).doubleValue()) / a))).doubleValue();
                Double d4 = weight.get(col);
                Intrinsics.checkNotNull((Object)d4);
                dArray[col] = d3 * Math.sqrt(((Number)d4).doubleValue()) / a;
            }
        }
        return result;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DensityStat.BandWidthMethod.values().length];
            nArray[DensityStat.BandWidthMethod.NRD0.ordinal()] = 1;
            nArray[DensityStat.BandWidthMethod.NRD.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DensityStat.Kernel.values().length];
            nArray[DensityStat.Kernel.GAUSSIAN.ordinal()] = 1;
            nArray[DensityStat.Kernel.RECTANGULAR.ordinal()] = 2;
            nArray[DensityStat.Kernel.TRIANGULAR.ordinal()] = 3;
            nArray[DensityStat.Kernel.BIWEIGHT.ordinal()] = 4;
            nArray[DensityStat.Kernel.EPANECHNIKOV.ordinal()] = 5;
            nArray[DensityStat.Kernel.OPTCOSINE.ordinal()] = 6;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

