/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.QQStat;
import jetbrains.datalore.plot.base.stat.QQStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.stat.math3.AbstractRealDistribution;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ;\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010H\u0016J*\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00172\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/datalore/plot/base/stat/QQLineStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "distribution", "Ljetbrains/datalore/plot/base/stat/QQStat$Distribution;", "distributionParameters", "", "", "lineQuantiles", "Lkotlin/Pair;", "(Ljetbrains/datalore/plot/base/stat/QQStat$Distribution;Ljava/util/List;Lkotlin/Pair;)V", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "buildStat", "", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "sampleSeries", "consumes", "Ljetbrains/datalore/plot/base/Aes;", "Companion", "plot-base-portable"})
public final class QQLineStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QQStat.Distribution distribution;
    @NotNull
    private final List<Double> distributionParameters;
    @NotNull
    private final Pair<Double, Double> lineQuantiles;
    @NotNull
    private static final Pair<Double, Double> DEF_LINE_QUANTILES = new Pair((Object)0.25, (Object)0.75);
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public QQLineStat(@NotNull QQStat.Distribution distribution, @NotNull List<Double> distributionParameters, @NotNull Pair<Double, Double> lineQuantiles) {
        Intrinsics.checkNotNullParameter((Object)((Object)distribution), (String)"distribution");
        Intrinsics.checkNotNullParameter(distributionParameters, (String)"distributionParameters");
        Intrinsics.checkNotNullParameter(lineQuantiles, (String)"lineQuantiles");
        super(DEF_MAPPING);
        this.distribution = distribution;
        this.distributionParameters = distributionParameters;
        this.lineQuantiles = lineQuantiles;
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        return CollectionsKt.listOf(Aes.Companion.getSAMPLE());
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getSAMPLE()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        Map<DataFrame.Variable, List<Double>> statData = this.buildStat(data.getNumeric(TransformVar.INSTANCE.getSAMPLE()));
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getTHEORETICAL(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getTHEORETICAL())).putNumeric(Stats.INSTANCE.getSAMPLE(), (List)MapsKt.getValue(statData, (Object)Stats.INSTANCE.getSAMPLE())).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> buildStat(List<Double> sampleSeries) {
        Collection<Double> collection;
        void $this$mapTo$iv$iv;
        Object[] objectArray;
        Object[] objectArray2;
        void $this$mapTo$iv$iv2;
        boolean bl;
        Double it;
        Pair[] $this$filterTo$iv$iv;
        Iterable $this$filter$iv = sampleSeries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            double d;
            it = (Double)t;
            bl = false;
            Double d2 = it;
            boolean bl2 = d2 != null ? !Double.isInfinite(d = d2.doubleValue()) && !Double.isNaN(d) : false;
            if (!bl2) continue;
            destination$iv$iv.add(t);
        }
        Pair[] $this$map$iv2 = (Pair[])((List)destination$iv$iv);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo232 = false;
        for (Object t : $this$mapTo$iv$iv2) {
            it = (Double)t;
            objectArray2 = destination$iv$iv;
            bl = false;
            Double d = it;
            Intrinsics.checkNotNull((Object)d);
            objectArray2.add(Double.valueOf(d));
        }
        List sortedSample = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        if (!CollectionsKt.any((Iterable)sortedSample)) {
            $this$map$iv2 = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getTHEORETICAL(), (Object)CollectionsKt.emptyList()), TuplesKt.to((Object)Stats.INSTANCE.getSAMPLE(), (Object)CollectionsKt.emptyList())};
            return MapsKt.mutableMapOf((Pair[])$this$map$iv2);
        }
        Pair quantilesSample = new Pair((Object)QQStatUtil.INSTANCE.getEstimatedQuantile(sortedSample, ((Number)this.lineQuantiles.getFirst()).doubleValue()), (Object)QQStatUtil.INSTANCE.getEstimatedQuantile(sortedSample, ((Number)this.lineQuantiles.getSecond()).doubleValue()));
        AbstractRealDistribution dist = QQStatUtil.INSTANCE.getDistribution(this.distribution, this.distributionParameters);
        Pair quantilesTheoretical = new Pair((Object)dist.inverseCumulativeProbability(Math.max(0.5 / (double)sortedSample.size(), ((Number)this.lineQuantiles.getFirst()).doubleValue())), (Object)dist.inverseCumulativeProbability(Math.min(1.0 - 0.5 / (double)sortedSample.size(), ((Number)this.lineQuantiles.getSecond()).doubleValue())));
        Object[] $i$f$mapTo232 = new Double[]{dist.inverseCumulativeProbability(0.5 / (double)sortedSample.size()), dist.inverseCumulativeProbability(1.0 - 0.5 / (double)sortedSample.size())};
        List endpointsTheoretical = CollectionsKt.listOf((Object[])$i$f$mapTo232);
        if (((Number)quantilesTheoretical.getFirst()).doubleValue() == ((Number)quantilesTheoretical.getSecond()).doubleValue()) {
            $i$f$mapTo232 = new Pair[2];
            objectArray = new Double[]{(Double)quantilesTheoretical.getFirst(), (Double)quantilesTheoretical.getSecond()};
            $i$f$mapTo232[0] = TuplesKt.to((Object)Stats.INSTANCE.getTHEORETICAL(), (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new Double[]{(Double)CollectionsKt.first((List)sortedSample), (Double)CollectionsKt.last((List)sortedSample)};
            $i$f$mapTo232[1] = TuplesKt.to((Object)Stats.INSTANCE.getSAMPLE(), (Object)CollectionsKt.listOf((Object[])objectArray));
            return MapsKt.mutableMapOf((Pair[])$i$f$mapTo232);
        }
        Function1<Double, Double> line = QQStatUtil.INSTANCE.lineByPoints((Pair<Double, Double>)quantilesTheoretical, (Pair<Double, Double>)quantilesSample);
        objectArray = new Pair[2];
        objectArray[0] = TuplesKt.to((Object)Stats.INSTANCE.getTHEORETICAL(), (Object)endpointsTheoretical);
        Iterable iterable2 = endpointsTheoretical;
        DataFrame.Variable variable = Stats.INSTANCE.getSAMPLE();
        int n = 1;
        objectArray2 = objectArray;
        boolean $i$f$map2 = false;
        Iterable bl3 = iterable2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it2;
            double d = ((Number)item$iv$iv3).doubleValue();
            collection = destination$iv$iv2;
            boolean bl32 = false;
            collection.add(((Number)line.invoke((Object)((double)it2))).doubleValue());
        }
        collection = (List)destination$iv$iv2;
        objectArray2[n] = TuplesKt.to((Object)variable, (Object)collection);
        return MapsKt.mutableMapOf((Pair[])objectArray);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getTHEORETICAL()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getSAMPLE())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/stat/QQLineStat$Companion;", "", "()V", "DEF_LINE_QUANTILES", "Lkotlin/Pair;", "", "getDEF_LINE_QUANTILES", "()Lkotlin/Pair;", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<Double, Double> getDEF_LINE_QUANTILES() {
            return DEF_LINE_QUANTILES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

