/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.DensityStat;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.FiveNumberSummary;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0002)*BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J;\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u001d0\u0018H\u0016JJ\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070!0\u001f2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070!2\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070!2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070!H\u0002J\u0012\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0!H\u0016J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ljetbrains/datalore/plot/base/stat/YDensityStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "scale", "Ljetbrains/datalore/plot/base/stat/YDensityStat$Scale;", "trim", "", "bandWidth", "", "bandWidthMethod", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "adjust", "kernel", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "n", "", "fullScanMax", "(Ljetbrains/datalore/plot/base/stat/YDensityStat$Scale;ZLjava/lang/Double;Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;DLjetbrains/datalore/plot/base/stat/DensityStat$Kernel;II)V", "Ljava/lang/Double;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "buildStat", "", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "", "xs", "ys", "ws", "consumes", "Ljetbrains/datalore/plot/base/Aes;", "normalize", "dataAfterStat", "Companion", "Scale", "plot-base-portable"})
public final class YDensityStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scale scale;
    private final boolean trim;
    @Nullable
    private final Double bandWidth;
    @NotNull
    private final DensityStat.BandWidthMethod bandWidthMethod;
    private final double adjust;
    @NotNull
    private final DensityStat.Kernel kernel;
    private final int n;
    private final int fullScanMax;
    @NotNull
    private static final Scale DEF_SCALE = Scale.AREA;
    public static final boolean DEF_TRIM = true;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public YDensityStat(@NotNull Scale scale, boolean trim, @Nullable Double bandWidth, @NotNull DensityStat.BandWidthMethod bandWidthMethod, double adjust, @NotNull DensityStat.Kernel kernel2, int n, int fullScanMax) {
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        super(DEF_MAPPING);
        this.scale = scale;
        this.trim = trim;
        this.bandWidth = bandWidth;
        this.bandWidthMethod = bandWidthMethod;
        this.adjust = adjust;
        this.kernel = kernel2;
        this.n = n;
        this.fullScanMax = fullScanMax;
        if (!(this.n <= 1024)) {
            boolean bl = false;
            String string = "The input n = " + this.n + " > 1024 is too large!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        List list2;
        List xs;
        int n;
        ArrayList<Double> arrayList;
        int n2;
        int n3;
        List list3;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getY()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> ys = data.getNumeric(TransformVar.INSTANCE.getY());
        if (data.has(TransformVar.INSTANCE.getX())) {
            list3 = data.getNumeric(TransformVar.INSTANCE.getX());
        } else {
            int n4 = ys.size();
            ArrayList<Double> arrayList2 = new ArrayList<Double>(n4);
            int n5 = 0;
            while (n5 < n4) {
                n2 = n3 = n5++;
                arrayList = arrayList2;
                n = 0;
                arrayList.add(0.0);
            }
            list3 = xs = (List)arrayList2;
        }
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            list2 = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
        } else {
            int n6 = ys.size();
            ArrayList arrayList3 = new ArrayList(n6);
            n3 = 0;
            while (n3 < n6) {
                n = n2 = n3++;
                arrayList = arrayList3;
                boolean bl = false;
                arrayList.add(1.0);
            }
            list2 = arrayList3;
        }
        List ws = list2;
        Map<DataFrame.Variable, List<Double>> statData = this.buildStat(xs, ys, ws);
        DataFrame.Builder builder = new DataFrame.Builder();
        for (Map.Entry<DataFrame.Variable, List<Double>> entry : statData.entrySet()) {
            DataFrame.Variable variable = entry.getKey();
            List<Double> series = entry.getValue();
            builder.putNumeric(variable, series);
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame normalize(@NotNull DataFrame dataAfterStat) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)dataAfterStat, (String)"dataAfterStat");
        if (dataAfterStat.rowCount() == 0) {
            list2 = CollectionsKt.emptyList();
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.scale.ordinal()]) {
                case 1: {
                    void $this$mapTo$iv$iv;
                    Collection collection;
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv = dataAfterStat.getNumeric(Stats.INSTANCE.getDENSITY());
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        Iterator it;
                        Double d = (Double)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        void v1 = it;
                        Intrinsics.checkNotNull((Object)v1);
                        collection.add(v1.doubleValue());
                    }
                    List statDensity = (List)destination$iv$iv;
                    Double d = CollectionsKt.maxOrNull((Iterable)statDensity);
                    Intrinsics.checkNotNull((Object)d);
                    double densityMax = d;
                    Iterable $this$map$iv2 = statDensity;
                    boolean $i$f$map2 = false;
                    Iterable $i$f$mapTo22 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        double d2 = ((Number)item$iv$iv).doubleValue();
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add((double)(it / densityMax));
                    }
                    list2 = (List)destination$iv$iv2;
                    break;
                }
                case 2: {
                    void $this$mapTo$iv$iv;
                    double d;
                    void $this$mapIndexedTo$iv$iv;
                    void $this$mapTo$iv$iv3;
                    Collection collection;
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv = dataAfterStat.getNumeric(Stats.INSTANCE.getDENSITY());
                    boolean $i$f$map = false;
                    Iterable $this$map$iv2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        Double it = (Double)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Double d3 = it;
                        Intrinsics.checkNotNull((Object)d3);
                        collection.add(Double.valueOf(d3));
                    }
                    List statDensity = (List)destination$iv$iv;
                    Double d4 = CollectionsKt.maxOrNull((Iterable)statDensity);
                    Intrinsics.checkNotNull((Object)d4);
                    double densityMax = d4;
                    Iterable $this$map$iv3 = dataAfterStat.getNumeric(Stats.INSTANCE.getCOUNT());
                    boolean $i$f$map3 = false;
                    Iterable destination$iv$iv2 = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo32 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it;
                        Double d5 = (Double)item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl = false;
                        void v5 = it;
                        Intrinsics.checkNotNull((Object)v5);
                        collection.add(v5.doubleValue());
                    }
                    List statCount = (List)destination$iv$iv3;
                    Iterable $this$mapIndexed$iv = statDensity;
                    boolean $i$f$mapIndexed = false;
                    Iterable $i$f$mapTo32 = $this$mapIndexed$iv;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo22 = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void i;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        double d6 = ((Number)item$iv$iv).doubleValue();
                        int n2 = n;
                        collection = destination$iv$iv4;
                        boolean bl = false;
                        collection.add(d > 0.0 ? ((Number)statCount.get((int)i)).doubleValue() / d : Double.NaN);
                    }
                    Double d7 = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv4));
                    Intrinsics.checkNotNull((Object)d7);
                    double widthsSumMax = d7;
                    double norm = densityMax * widthsSumMax;
                    Iterable $this$map$iv4 = statCount;
                    boolean $i$f$map4 = false;
                    Iterable $i$f$mapIndexedTo22 = $this$map$iv4;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        d = ((Number)item$iv$iv).doubleValue();
                        collection = destination$iv$iv5;
                        boolean bl = false;
                        collection.add((double)(it / norm));
                    }
                    list2 = (List)destination$iv$iv5;
                    break;
                }
                case 3: {
                    list2 = dataAfterStat.getNumeric(Stats.INSTANCE.getSCALED());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        List statViolinWidth = list2;
        return dataAfterStat.builder().putNumeric(Stats.INSTANCE.getVIOLIN_WIDTH(), statViolinWidth).build();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<DataFrame.Variable, List<Double>> buildStat(List<Double> xs, List<Double> ys, List<Double> ws) {
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object2;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = CollectionsKt.zip((Iterable)xs, (Iterable)CollectionsKt.zip((Iterable)ys, (Iterable)ws));
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            double d;
            it = (Pair)t;
            boolean bl = false;
            Double d2 = (Double)it.getFirst();
            boolean bl2 = d2 != null ? !Double.isInfinite(d = d2.doubleValue()) && !Double.isNaN(d) : false;
            if (!bl2) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object entry : $this$groupByTo$iv$iv) {
            void it2;
            Object object3;
            it = (Pair)entry;
            boolean $i$a$-groupBy-YDensityStat$buildStat$binnedData$432 = false;
            Object object4 = it.getFirst();
            Intrinsics.checkNotNull((Object)object4);
            Double key$iv$iv = ((Number)object4).doubleValue();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            Pair $i$a$-groupBy-YDensityStat$buildStat$binnedData$432 = (Pair)entry;
            object2 = list$iv$iv;
            boolean bl4 = false;
            object2.add((Pair)it2.getSecond());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it3;
            void it$iv$iv;
            Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object2 = object;
            boolean bl32 = false;
            Pair pair = CollectionsKt.unzip((Iterable)((Iterable)it3.getValue()));
            object2.put(k, pair);
        }
        Object binnedData = destination$iv$iv;
        ArrayList statX = new ArrayList();
        ArrayList statY = new ArrayList();
        ArrayList statDensity = new ArrayList();
        ArrayList statCount = new ArrayList();
        ArrayList statScaled = new ArrayList();
        for (Map.Entry entry : binnedData.entrySet()) {
            double it4;
            Iterable $this$mapTo$iv$iv;
            int n;
            Object item$iv$iv22;
            void $this$mapTo$iv$iv2;
            void $this$sortedBy$iv;
            double x = ((Number)entry.getKey()).doubleValue();
            Pair bin = (Pair)entry.getValue();
            object = SeriesUtil.INSTANCE.filterFinite((List)bin.getFirst(), (List)bin.getSecond());
            List filteredY = (List)object.get(0);
            List filteredW = (List)object.get(1);
            Iterable bl4 = CollectionsKt.zip((Iterable)filteredY, (Iterable)filteredW);
            boolean $i$f$sortedBy = false;
            Pair pair = CollectionsKt.unzip((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getFirst()));
                }
            }));
            List binY = (List)pair.component1();
            List binW = (List)pair.component2();
            if (binY.isEmpty()) continue;
            FiveNumberSummary ySummary = new FiveNumberSummary(binY);
            double modifier = this.trim ? 0.0 : 3.0;
            Double d = this.bandWidth;
            double bw = d != null ? d.doubleValue() : DensityStatUtil.INSTANCE.bandWidth(this.bandWidthMethod, binY);
            DoubleSpan rangeY = new DoubleSpan(ySummary.getMin() - modifier * bw, ySummary.getMax() + modifier * bw);
            List<Double> binStatY = DensityStatUtil.INSTANCE.createStepValues(rangeY, this.n);
            Function1<Double, Double> densityFunction = DensityStatUtil.INSTANCE.densityFunction$plot_base_portable(binY, binW, this.bandWidth, this.bandWidthMethod, this.adjust, this.kernel, this.fullScanMax);
            Iterable $this$map$iv = binStatY;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv22 : $this$mapTo$iv$iv2) {
                void it232;
                double d3 = ((Number)item$iv$iv22).doubleValue();
                object2 = destination$iv$iv2;
                n = 0;
                object2.add(((Number)densityFunction.invoke((Object)((double)it232))).doubleValue());
            }
            List binStatCount = (List)destination$iv$iv2;
            double widthsSum = CollectionsKt.sumOfDouble((Iterable)binW);
            Double d4 = CollectionsKt.maxOrNull((Iterable)binStatCount);
            Intrinsics.checkNotNull((Object)d4);
            double maxBinCount = d4;
            Collection collection = statX;
            int n2 = binStatY.size();
            item$iv$iv22 = new ArrayList(n2);
            int it232 = 0;
            while (it232 < n2) {
                int n3;
                n = n3 = it232++;
                object2 = item$iv$iv22;
                boolean bl42 = false;
                ((ArrayList)object2).add(x);
            }
            Object object5 = (List)item$iv$iv22;
            CollectionsKt.addAll((Collection)collection, (Iterable)object5);
            CollectionsKt.addAll((Collection)statY, (Iterable)binStatY);
            collection = statDensity;
            Iterable $this$map$iv2 = binStatCount;
            boolean $i$f$map2 = false;
            Iterable it232 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                double d5 = ((Number)item$iv$iv3).doubleValue();
                object2 = destination$iv$iv3;
                boolean bl5 = false;
                object2.add((double)(it4 / widthsSum));
            }
            $this$map$iv2 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)collection, (Iterable)$this$map$iv2);
            CollectionsKt.addAll((Collection)statCount, (Iterable)binStatCount);
            collection = statScaled;
            Iterable $this$map$iv3 = binStatCount;
            boolean $i$f$map3 = false;
            $this$mapTo$iv$iv = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                it4 = ((Number)item$iv$iv).doubleValue();
                object2 = destination$iv$iv4;
                boolean bl6 = false;
                object2.add((double)(it2 / maxBinCount));
            }
            object5 = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)collection, (Iterable)object5);
        }
        Iterator<Object> iterator = new Pair[]{TuplesKt.to((Object)Stats.INSTANCE.getX(), statX), TuplesKt.to((Object)Stats.INSTANCE.getY(), statY), TuplesKt.to((Object)Stats.INSTANCE.getDENSITY(), statDensity), TuplesKt.to((Object)Stats.INSTANCE.getCOUNT(), statCount), TuplesKt.to((Object)Stats.INSTANCE.getSCALED(), statScaled)};
        return MapsKt.mutableMapOf(iterator);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getVIOLINWIDTH(), (Object)Stats.INSTANCE.getVIOLIN_WIDTH())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/stat/YDensityStat$Scale;", "", "(Ljava/lang/String;I)V", "AREA", "COUNT", "WIDTH", "plot-base-portable"})
    public static final class Scale
    extends Enum<Scale> {
        public static final /* enum */ Scale AREA = new Scale();
        public static final /* enum */ Scale COUNT = new Scale();
        public static final /* enum */ Scale WIDTH = new Scale();
        private static final /* synthetic */ Scale[] $VALUES;

        public static Scale[] values() {
            return (Scale[])$VALUES.clone();
        }

        public static Scale valueOf(String value) {
            return Enum.valueOf(Scale.class, value);
        }

        static {
            $VALUES = scaleArray = new Scale[]{Scale.AREA, Scale.COUNT, Scale.WIDTH};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/stat/YDensityStat$Companion;", "", "()V", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_SCALE", "Ljetbrains/datalore/plot/base/stat/YDensityStat$Scale;", "getDEF_SCALE", "()Ljetbrains/datalore/plot/base/stat/YDensityStat$Scale;", "DEF_TRIM", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Scale getDEF_SCALE() {
            return DEF_SCALE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scale.values().length];
            nArray[Scale.AREA.ordinal()] = 1;
            nArray[Scale.COUNT.ordinal()] = 2;
            nArray[Scale.WIDTH.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

