/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.AbstractUnivariateSolver;
import jetbrains.datalore.plot.base.stat.math3.Precision;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0014\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/BrentSolver;", "Ljetbrains/datalore/plot/base/stat/math3/AbstractUnivariateSolver;", "absoluteAccuracy", "", "(D)V", "relativeAccuracy", "(DD)V", "functionValueAccuracy", "(DDD)V", "brent", "lo", "hi", "fLo", "fHi", "doSolve", "Companion", "plot-base-portable"})
public final class BrentSolver
extends AbstractUnivariateSolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    @JvmOverloads
    public BrentSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public /* synthetic */ BrentSolver(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = DEFAULT_ABSOLUTE_ACCURACY;
        }
        this(d);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
    }

    @Override
    protected double doSolve() {
        double min = this.getMin();
        double max = this.getMax();
        double initial = this.getStartValue();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        this.verifySequence(min, initial, max);
        double yInitial = this.computeObjectiveValue(initial);
        if (Math.abs(yInitial) <= functionValueAccuracy) {
            return initial;
        }
        double yMin = this.computeObjectiveValue(min);
        if (Math.abs(yMin) <= functionValueAccuracy) {
            return min;
        }
        if (yInitial * yMin < 0.0) {
            return this.brent(min, initial, yMin, yInitial);
        }
        double yMax = this.computeObjectiveValue(max);
        if (Math.abs(yMax) <= functionValueAccuracy) {
            return max;
        }
        if (yInitial * yMax < 0.0) {
            return this.brent(initial, max, yInitial, yMax);
        }
        throw new IllegalStateException(("NoBracketing - min: " + min + ", max: " + max + ", yMin: " + yMin + ", yMax: " + yMax).toString());
    }

    private final double brent(double lo, double hi, double fLo, double fHi) {
        double d;
        double a = lo;
        double fa = fLo;
        double b = hi;
        double fb = fHi;
        double c = a;
        double fc = fa;
        double e = d = b - a;
        double t = this.getAbsoluteAccuracy();
        double eps = this.getRelativeAccuracy();
        while (true) {
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol = 2.0 * eps * Math.abs(b) + t;
            double m = 0.5 * (c - b);
            if (Math.abs(m) <= tol || Precision.equals$default(Precision.INSTANCE, fb, 0.0, 0, 4, null)) {
                return b;
            }
            if (Math.abs(e) < tol || Math.abs(fa) <= Math.abs(fb)) {
                e = d = m;
            } else {
                double s = fb / fa;
                double p = 0.0;
                double q = 0.0;
                if (a == c) {
                    p = 2.0 * m * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * m * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                s = e;
                e = d;
                if (p >= 1.5 * m * q - Math.abs(tol * q) || p >= Math.abs(0.5 * s * q)) {
                    e = d = m;
                } else {
                    d = p / q;
                }
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol ? (b += d) : (m > 0.0 ? (b += tol) : (b -= tol));
            fb = this.computeObjectiveValue(b);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb <= 0.0) || !(fc <= 0.0))) continue;
            c = a;
            fc = fa;
            e = d = b - a;
        }
    }

    @JvmOverloads
    public BrentSolver() {
        this(0.0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/BrentSolver$Companion;", "", "()V", "DEFAULT_ABSOLUTE_ACCURACY", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

