/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.AbstractRealDistribution;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/NormalDistribution;", "Ljetbrains/datalore/plot/base/stat/math3/AbstractRealDistribution;", "mean", "", "standardDeviation", "(DD)V", "isSupportConnected", "", "()Z", "isSupportLowerBoundInclusive", "isSupportUpperBoundInclusive", "numericalMean", "getNumericalMean", "()D", "numericalVariance", "getNumericalVariance", "supportLowerBound", "getSupportLowerBound", "supportUpperBound", "getSupportUpperBound", "cumulativeProbability", "x", "density", "inverseCumulativeProbability", "p", "probability", "plot-base-portable"})
public final class NormalDistribution
extends AbstractRealDistribution {
    private final double mean;
    private final double standardDeviation;
    private final double numericalMean;
    private final double numericalVariance;
    private final double supportLowerBound;
    private final double supportUpperBound;
    private final boolean isSupportLowerBoundInclusive;
    private final boolean isSupportUpperBoundInclusive;
    private final boolean isSupportConnected;

    @JvmOverloads
    public NormalDistribution(double mean, double standardDeviation) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
        this.numericalMean = this.mean;
        this.numericalVariance = Math.pow(this.standardDeviation, 2);
        this.supportLowerBound = Double.NEGATIVE_INFINITY;
        this.supportUpperBound = Double.POSITIVE_INFINITY;
        this.isSupportConnected = true;
        if (this.standardDeviation <= 0.0) {
            throw new IllegalStateException(("NotStrictlyPositive - STANDARD_DEVIATION: " + this.standardDeviation).toString());
        }
    }

    @Override
    public double getNumericalMean() {
        return this.numericalMean;
    }

    @Override
    public double getNumericalVariance() {
        return this.numericalVariance;
    }

    @Override
    public double getSupportLowerBound() {
        return this.supportLowerBound;
    }

    @Override
    public double getSupportUpperBound() {
        return this.supportUpperBound;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return this.isSupportLowerBoundInclusive;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return this.isSupportUpperBoundInclusive;
    }

    @Override
    public boolean isSupportConnected() {
        return this.isSupportConnected;
    }

    @Override
    public double probability(double x) {
        return 0.0;
    }

    @Override
    public double density(double x) {
        return 1.0 / (this.standardDeviation * Math.sqrt(Math.PI * 2)) * Math.pow(Math.E, -0.5 * Math.pow((x - this.mean) / this.standardDeviation, 2));
    }

    @Override
    public double cumulativeProbability(double x) {
        double y = (x - this.mean) / this.standardDeviation;
        if (y < -37.0) {
            return 0.0;
        }
        if (y > 37.0) {
            return 1.0;
        }
        Object[] objectArray = new Double[]{220.206867912376, 221.213596169931, 112.079291497871, 33.912866078383, 6.37396220353165, 0.700383064443688, 0.0352624965998911};
        List a = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{440.413735824752, 793.826512519948, 637.333633378831, 296.564248779674, 86.7807322029461, 16.064177579207, 1.75566716318264, 0.0883883476483184};
        List b = CollectionsKt.listOf((Object[])objectArray2);
        double c = 2.506628274631;
        double yAbs = Math.abs(y);
        double exp = Math.pow(Math.E, -Math.pow(yAbs, 2) / 2.0);
        double cumNorm = yAbs < 7.07106781186547 ? exp * ((((((((Number)a.get(6)).doubleValue() * yAbs + ((Number)a.get(5)).doubleValue()) * yAbs + ((Number)a.get(4)).doubleValue()) * yAbs + ((Number)a.get(3)).doubleValue()) * yAbs + ((Number)a.get(2)).doubleValue()) * yAbs + ((Number)a.get(1)).doubleValue()) * yAbs + ((Number)a.get(0)).doubleValue()) / (((((((((Number)b.get(7)).doubleValue() * yAbs + ((Number)b.get(6)).doubleValue()) * yAbs + ((Number)b.get(5)).doubleValue()) * yAbs + ((Number)b.get(4)).doubleValue()) * yAbs + ((Number)b.get(3)).doubleValue()) * yAbs + ((Number)b.get(2)).doubleValue()) * yAbs + ((Number)b.get(1)).doubleValue()) * yAbs + ((Number)b.get(0)).doubleValue()) : exp / ((yAbs + 1.0 / (yAbs + 2.0 / (yAbs + 3.0 / (yAbs + 4.0 / (yAbs + 0.65))))) * c);
        return y > 0.0 ? (1.0 - cumNorm) / this.standardDeviation : cumNorm / this.standardDeviation;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalStateException(("OutOfRange [0, 1] - p" + p).toString());
        }
        if (p == 0.0) {
            return this.getSupportLowerBound();
        }
        if (p == 1.0) {
            return this.getSupportUpperBound();
        }
        double r = 0.0;
        double q = p - 0.5;
        double result = 0.0;
        Object[] objectArray = new Double[]{3.3871328727963665, 133.14166789178438, 1971.5909503065513, 13731.69376550946, 45921.95393154987, 67265.7709270087, 33430.57558358813, 2509.0809287301227};
        List a = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{42.31333070160091, 687.1870074920579, 5394.196021424751, 21213.794301586597, 39307.89580009271, 28729.085735721943, 5226.495278852854};
        List b = CollectionsKt.listOf((Object[])objectArray2);
        Object[] objectArray3 = new Double[]{1.4234371107496835, 4.630337846156546, 5.769497221460691, 3.6478483247632045, 1.2704582524523684, 0.2417807251774506, 0.022723844989269184, 7.745450142783414E-4};
        List c = CollectionsKt.listOf((Object[])objectArray3);
        Object[] objectArray4 = new Double[]{2.053191626637759, 1.6763848301838038, 0.6897673349851, 0.14810397642748008, 0.015198666563616457, 5.475938084995345E-4, 1.0507500716444169E-9};
        List d = CollectionsKt.listOf((Object[])objectArray4);
        Object[] objectArray5 = new Double[]{6.657904643501103, 5.463784911164114, 1.7848265399172913, 0.29656057182850487, 0.026532189526576124, 0.0012426609473880784, 2.7115555687434876E-5, 2.0103343992922881E-7};
        List e = CollectionsKt.listOf((Object[])objectArray5);
        Object[] objectArray6 = new Double[]{0.599832206555888, 0.1369298809227358, 0.014875361290850615, 7.868691311456133E-4, 1.8463183175100548E-5, 1.421511758316446E-7, 2.0442631033899397E-15};
        List f = CollectionsKt.listOf((Object[])objectArray6);
        if (Math.abs(q) <= 0.425) {
            r = 0.180625 - Math.pow(q, 2);
            result = q * (((((((r * ((Number)a.get(7)).doubleValue() + ((Number)a.get(6)).doubleValue()) * r + ((Number)a.get(5)).doubleValue()) * r + ((Number)a.get(4)).doubleValue()) * r + ((Number)a.get(3)).doubleValue()) * r + ((Number)a.get(2)).doubleValue()) * r + ((Number)a.get(1)).doubleValue()) * r + ((Number)a.get(0)).doubleValue()) / (((((((r * ((Number)b.get(6)).doubleValue() + ((Number)b.get(5)).doubleValue()) * r + ((Number)b.get(4)).doubleValue()) * r + ((Number)b.get(3)).doubleValue()) * r + ((Number)b.get(2)).doubleValue()) * r + ((Number)b.get(1)).doubleValue()) * r + ((Number)b.get(0)).doubleValue()) * r + 1.0);
        } else {
            r = q > 0.0 ? 1.0 - p : p;
            r = Math.sqrt(-Math.log(r));
            result = r <= 5.0 ? ((((((((r -= 1.6) * ((Number)c.get(7)).doubleValue() + ((Number)c.get(6)).doubleValue()) * r + ((Number)c.get(5)).doubleValue()) * r + ((Number)c.get(4)).doubleValue()) * r + ((Number)c.get(3)).doubleValue()) * r + ((Number)c.get(2)).doubleValue()) * r + ((Number)c.get(1)).doubleValue()) * r + ((Number)c.get(0)).doubleValue()) / (((((((r * ((Number)d.get(6)).doubleValue() + ((Number)d.get(5)).doubleValue()) * r + ((Number)d.get(4)).doubleValue()) * r + ((Number)d.get(3)).doubleValue()) * r + ((Number)d.get(2)).doubleValue()) * r + ((Number)d.get(1)).doubleValue()) * r + ((Number)d.get(0)).doubleValue()) * r + 1.0) : ((((((((r -= 5.0) * ((Number)e.get(7)).doubleValue() + ((Number)e.get(6)).doubleValue()) * r + ((Number)e.get(5)).doubleValue()) * r + ((Number)e.get(4)).doubleValue()) * r + ((Number)e.get(3)).doubleValue()) * r + ((Number)e.get(2)).doubleValue()) * r + ((Number)e.get(1)).doubleValue()) * r + ((Number)e.get(0)).doubleValue()) / (((((((r * ((Number)f.get(6)).doubleValue() + ((Number)f.get(5)).doubleValue()) * r + ((Number)f.get(4)).doubleValue()) * r + ((Number)f.get(3)).doubleValue()) * r + ((Number)f.get(2)).doubleValue()) * r + ((Number)f.get(1)).doubleValue()) * r + ((Number)f.get(0)).doubleValue()) * r + 1.0);
            if (q < 0.0) {
                result = -result;
            }
        }
        return this.mean + this.standardDeviation * result;
    }
}

