/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.MathArrays;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunction;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/PolynomialSplineFunction;", "", "_knots", "", "_polynomials", "", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "([D[Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;)V", "knots", "getKnots", "()[D", "n", "", "polynomials", "getPolynomials", "()[Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "[Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "value", "", "v", "(D)Ljava/lang/Double;", "plot-base-portable"})
public final class PolynomialSplineFunction {
    @NotNull
    private final double[] knots;
    @NotNull
    private final PolynomialFunction[] polynomials;
    private final int n;

    public PolynomialSplineFunction(@Nullable double[] _knots, @NotNull PolynomialFunction[] _polynomials) {
        Intrinsics.checkNotNullParameter((Object)_polynomials, (String)"_polynomials");
        if (_knots == null) {
            throw new IllegalStateException("Null argument ".toString());
        }
        if (_knots.length < 2) {
            throw new IllegalStateException(("Spline partition must have at least 2 points, got " + _knots.length).toString());
        }
        if (_knots.length - 1 != _polynomials.length) {
            throw new IllegalStateException(("Dimensions mismatch: " + _polynomials.length + " polynomial functions !=  " + _knots.length + " segment delimiters").toString());
        }
        MathArrays.INSTANCE.checkOrder(_knots);
        this.n = _knots.length - 1;
        this.knots = _knots;
        this.polynomials = new PolynomialFunction[this.n];
        ArraysKt.copyInto((Object[])_polynomials, (Object[])this.polynomials, (int)0, (int)0, (int)this.n);
    }

    @NotNull
    public final double[] getKnots() {
        return this.knots;
    }

    @NotNull
    public final PolynomialFunction[] getPolynomials() {
        return this.polynomials;
    }

    @Nullable
    public final Double value(double v) {
        if (v < this.knots[0] || v > this.knots[this.n]) {
            throw new IllegalStateException((v + " out of [" + this.knots[0] + ", " + this.knots[this.n] + "] range").toString());
        }
        int i = CollectionsKt.binarySearch$default((List)ArraysKt.toMutableList((double[])this.knots), (Comparable)Double.valueOf(v), (int)0, (int)0, (int)6, null);
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        PolynomialFunction polynomialFunction = this.polynomials[i];
        return polynomialFunction != null ? Double.valueOf(polynomialFunction.value(v - this.knots[i])) : null;
    }
}

