/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.MathArrays;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunction;
import jetbrains.datalore.plot.base.stat.math3.PolynomialSplineFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/SplineInterpolator;", "", "()V", "interpolate", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialSplineFunction;", "x", "", "y", "plot-base-portable"})
public final class SplineInterpolator {
    @NotNull
    public final PolynomialSplineFunction interpolate(@NotNull double[] x, @NotNull double[] y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        if (x.length != y.length) {
            throw new IllegalStateException(("Dimension mismatch " + x.length + " != " + y.length).toString());
        }
        if (x.length < 3) {
            throw new IllegalStateException(("Too small value of points number: " + x.length + " < 3").toString());
        }
        int n = x.length - 1;
        MathArrays.INSTANCE.checkOrder(x);
        double[] h = new double[n];
        for (int i = 0; i < n; ++i) {
            h[i] = x[i + 1] - x[i];
        }
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        for (int i = 1; i < n; ++i) {
            double g = 2.0 * (x[i + 1] - x[i - 1]) - h[i - 1] * mu[i - 1];
            mu[i] = h[i] / g;
            z[i] = (3.0 * (y[i + 1] * h[i - 1] - y[i] * (x[i + 1] - x[i - 1]) + y[i - 1] * h[i]) / (h[i - 1] * h[i]) - h[i - 1] * z[i - 1]) / g;
        }
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        z[n] = 0.0;
        c[n] = 0.0;
        for (int j = n - 1; -1 < j; --j) {
            c[j] = z[j] - mu[j] * c[j + 1];
            b[j] = (y[j + 1] - y[j]) / h[j] - h[j] * (c[j + 1] + 2.0 * c[j]) / 3.0;
            d[j] = (c[j + 1] - c[j]) / (3.0 * h[j]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = b[i];
            coefficients[2] = c[i];
            coefficients[3] = d[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

