/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.AbstractRealDistribution;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/UniformDistribution;", "Ljetbrains/datalore/plot/base/stat/math3/AbstractRealDistribution;", "a", "", "b", "(DD)V", "isSupportConnected", "", "()Z", "isSupportLowerBoundInclusive", "isSupportUpperBoundInclusive", "numericalMean", "getNumericalMean", "()D", "numericalVariance", "getNumericalVariance", "supportLowerBound", "getSupportLowerBound", "supportUpperBound", "getSupportUpperBound", "cumulativeProbability", "x", "density", "inverseCumulativeProbability", "p", "probability", "plot-base-portable"})
public final class UniformDistribution
extends AbstractRealDistribution {
    private final double a;
    private final double b;
    private final double numericalMean;
    private final double numericalVariance;
    private final double supportLowerBound;
    private final double supportUpperBound;
    private final boolean isSupportLowerBoundInclusive;
    private final boolean isSupportUpperBoundInclusive;
    private final boolean isSupportConnected;

    @JvmOverloads
    public UniformDistribution(double a, double b) {
        this.a = a;
        this.b = b;
        this.numericalMean = (this.a + this.b) / 2.0;
        this.numericalVariance = Math.pow(this.b - this.a, 2) / 12.0;
        this.supportLowerBound = Double.NEGATIVE_INFINITY;
        this.supportUpperBound = Double.POSITIVE_INFINITY;
        this.isSupportConnected = true;
        if (this.b < this.a) {
            throw new IllegalStateException(("Not a segment [a, b]=[" + this.a + ", " + this.b + ']').toString());
        }
    }

    @Override
    public double getNumericalMean() {
        return this.numericalMean;
    }

    @Override
    public double getNumericalVariance() {
        return this.numericalVariance;
    }

    @Override
    public double getSupportLowerBound() {
        return this.supportLowerBound;
    }

    @Override
    public double getSupportUpperBound() {
        return this.supportUpperBound;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return this.isSupportLowerBoundInclusive;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return this.isSupportUpperBoundInclusive;
    }

    @Override
    public boolean isSupportConnected() {
        return this.isSupportConnected;
    }

    @Override
    public double probability(double x) {
        return 0.0;
    }

    @Override
    public double density(double x) {
        double d = this.a;
        return (x <= this.b ? d <= x : false) ? 1.0 / (this.b - this.a) : 0.0;
    }

    @Override
    public double cumulativeProbability(double x) {
        return x < this.a ? 0.0 : (x > this.b ? 1.0 : (x - this.a) / (this.b - this.a));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalStateException(("OutOfRange [0, 1] - p" + p).toString());
        }
        if (p == 0.0) {
            return this.getSupportLowerBound();
        }
        if (p == 1.0) {
            return this.getSupportUpperBound();
        }
        return this.a + p * (this.b - this.a);
    }
}

