/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.util;

import java.util.HashSet;
import java.util.Set;
import jetbrains.datalore.plot.base.DataFrame;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J]\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f\u0012\u0004\u0012\u0002H\u00040\u000b2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f\u0012\u0004\u0012\u0002H\u00040\u000b\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/base/util/SamplingUtil;", "", "()V", "sampleWithoutReplacement", "T", "popSize", "", "sampleSize", "rand", "Lkotlin/random/Random;", "onPick", "Lkotlin/Function1;", "", "onDrop", "(IILkotlin/random/Random;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "plot-base-portable"})
public final class SamplingUtil {
    @NotNull
    public static final SamplingUtil INSTANCE = new SamplingUtil();

    private SamplingUtil() {
    }

    public final <T> T sampleWithoutReplacement(int popSize, int sampleSize, @NotNull Random rand, @NotNull Function1<? super Set<Integer>, ? extends T> onPick, @NotNull Function1<? super Set<Integer>, ? extends T> onDrop) {
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter(onPick, (String)"onPick");
        Intrinsics.checkNotNullParameter(onDrop, (String)"onDrop");
        boolean pick = sampleSize <= popSize / 2;
        int indexCount = pick ? sampleSize : popSize - sampleSize;
        HashSet<Integer> indexSet = new HashSet<Integer>();
        while (indexSet.size() < indexCount) {
            indexSet.add(rand.nextInt(popSize));
        }
        return (T)(pick ? onPick.invoke(indexSet) : onDrop.invoke(indexSet));
    }

    @NotNull
    public final DataFrame sampleWithoutReplacement(int sampleSize, @NotNull Random rand, @NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return (DataFrame)this.sampleWithoutReplacement(data.rowCount(), sampleSize, rand, (Function1)new Function1<Set<? extends Integer>, DataFrame>(data){
            final /* synthetic */ DataFrame $data;
            {
                this.$data = $data;
                super(1);
            }

            @NotNull
            public final DataFrame invoke(@NotNull Set<Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$data.selectIndices(it);
            }
        }, (Function1)new Function1<Set<? extends Integer>, DataFrame>(data){
            final /* synthetic */ DataFrame $data;
            {
                this.$data = $data;
                super(1);
            }

            @NotNull
            public final DataFrame invoke(@NotNull Set<Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$data.dropIndices(it);
            }
        });
    }
}

