/*
 * Copyright (c) 2019. JetBrains s.r.o.
 * Use of this source code is governed by the MIT license that can be found in the LICENSE file.
 */

package jetbrains.datalore.plot.base.scale

import jetbrains.datalore.base.interval.DoubleSpan

interface BreaksGenerator {
    fun generateBreaks(domain: DoubleSpan, targetCount: Int): ScaleBreaks

    /**
     * Formatting arbitrary datapoints according to user-defined format or default formatter.
     */
    fun labelFormatter(domain: DoubleSpan, targetCount: Int): (Any) -> String

    /**
     * Formatting arbitrary datapoints excluding user-defined options; the formatter is used for labels and tooltips.
     */
    fun defaultFormatter(domain: DoubleSpan, targetCount: Int): (Any) -> String
}
