/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.color;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.Ordering;
import jetbrains.datalore.base.interval.IntSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\u0004J\b\u0010\n\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/common/color/RGBChannelGen;", "", "myBaseValues", "", "", "(Ljava/util/List;)V", "myRange", "Ljetbrains/datalore/base/interval/IntSpan;", "generate", "maxCount", "maxValueCount", "Companion", "plot-common-portable"})
public final class RGBChannelGen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> myBaseValues;
    @Nullable
    private IntSpan myRange;
    @NotNull
    private static final IntSpan[] RANGES;

    public RGBChannelGen(@NotNull List<Integer> myBaseValues) {
        Intrinsics.checkNotNullParameter(myBaseValues, (String)"myBaseValues");
        this.myBaseValues = myBaseValues;
        int min = ((Number)Ordering.Companion.natural().min((Iterable)this.myBaseValues)).intValue();
        int max = ((Number)Ordering.Companion.natural().max((Iterable)this.myBaseValues)).intValue();
        for (IntSpan r : RANGES) {
            if (!r.contains(min) && !r.contains(max)) continue;
            if (this.myRange == null) {
                this.myRange = r;
                continue;
            }
            IntSpan intSpan = this.myRange;
            Intrinsics.checkNotNull((Object)intSpan);
            this.myRange = intSpan.union(r);
        }
    }

    @NotNull
    public final List<Integer> generate(int maxCount) {
        int genPerBaseValue = (int)Math.ceil((double)maxCount / (double)this.myBaseValues.size());
        genPerBaseValue = Math.min(this.maxValueCount() - 1, genPerBaseValue);
        int inc = (int)Math.floor((double)this.maxValueCount() / (double)(genPerBaseValue + 1));
        inc = Math.max(1, (int)((double)inc * 1.33));
        ArrayList<Integer> values = new ArrayList<Integer>(maxCount);
        List baseValues = this.myBaseValues;
        while (values.size() < maxCount) {
            ArrayList<Integer> nextBaseValues = new ArrayList<Integer>();
            Iterator<Integer> iterator = baseValues.iterator();
            while (iterator.hasNext()) {
                int baseValue = ((Number)iterator.next()).intValue();
                int genValue = baseValue + inc;
                IntSpan intSpan = this.myRange;
                Intrinsics.checkNotNull((Object)intSpan);
                if (!intSpan.contains(genValue)) {
                    IntSpan intSpan2 = this.myRange;
                    Intrinsics.checkNotNull((Object)intSpan2);
                    int n = intSpan2.getLowerEnd();
                    IntSpan intSpan3 = this.myRange;
                    Intrinsics.checkNotNull((Object)intSpan3);
                    genValue = n + (genValue - intSpan3.getUpperEnd());
                }
                values.add(genValue);
                nextBaseValues.add(genValue);
                if (values.size() != maxCount) continue;
            }
            baseValues = nextBaseValues;
        }
        return values;
    }

    private final int maxValueCount() {
        IntSpan intSpan = this.myRange;
        Intrinsics.checkNotNull((Object)intSpan);
        int n = intSpan.getUpperEnd();
        IntSpan intSpan2 = this.myRange;
        Intrinsics.checkNotNull((Object)intSpan2);
        return n - intSpan2.getLowerEnd() + 1;
    }

    static {
        IntSpan[] intSpanArray = new IntSpan[]{new IntSpan(0, 37), new IntSpan(38, 97), new IntSpan(98, 157), new IntSpan(158, 217), new IntSpan(218, 255)};
        RANGES = intSpanArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/common/color/RGBChannelGen$Companion;", "", "()V", "RANGES", "", "Ljetbrains/datalore/base/interval/IntSpan;", "[Ljetbrains/datalore/base/interval/IntSpan;", "plot-common-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

