/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.datalore.base.gcommon.collect.Iterables;
import jetbrains.datalore.base.gcommon.collect.Ordering;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.common.data.RegularMeshDetector;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002FGB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0010J)\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0012J3\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cJ\u0012\u0010\u0019\u001a\u00020\u001d2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001eJ\u001c\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010 J\u0016\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0007J\u001e\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007J2\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001e0\u001e2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001e2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001eJ'\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u001e2\u0006\u0010\u0017\u001a\u0002H+\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\u00020\b2\u0006\u0010!\u001a\u00020 J\u0016\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0007J\u000e\u00101\u001a\u00020\b2\u0006\u0010!\u001a\u00020 J\u000e\u00101\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0007J\u0015\u00101\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00102J\"\u00103\u001a\b\u0012\u0004\u0012\u00020\u0004042\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u001e2\b\u00105\u001a\u0004\u0018\u00010\u0001J$\u00103\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030\u001e2\n\u00106\u001a\u0006\u0012\u0002\b\u000307J'\u00108\u001a\u0004\u0018\u00010\u00072\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u00109J.\u0010:\u001a\b\u0012\u0004\u0012\u0002H+0\u001e\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u001e2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ.\u0010:\u001a\b\u0012\u0004\u0012\u0002H+0\u001e\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u001e2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000407J\u0018\u0010!\u001a\u0004\u0018\u00010 2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001cJ\u001e\u0010<\u001a\u00020\u00072\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001c2\u0006\u0010=\u001a\u00020\u0007J \u0010>\u001a\u00020\u00072\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001c2\u0006\u0010=\u001a\u00020\u0007H\u0002J.\u0010?\u001a\b\u0012\u0004\u0012\u0002H+0\u001e\"\u0004\b\u0000\u0010+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0\u001e2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000407J\u001c\u0010@\u001a\u0004\u0018\u00010 2\b\u0010A\u001a\u0004\u0018\u00010 2\b\u0010B\u001a\u0004\u0018\u00010 J\u0016\u0010C\u001a\u00020\u00072\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001eJ\u001e\u0010D\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u001e2\f\u0010E\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Ljetbrains/datalore/plot/common/data/SeriesUtil;", "", "()V", "MAX_DECIMAL_PLACES", "", "NEGATIVE_NUMBER", "Lkotlin/Function1;", "", "", "getNEGATIVE_NUMBER", "()Lkotlin/jvm/functions/Function1;", "REAL_NUMBER", "TINY", "allFinite", "v0", "v1", "(Ljava/lang/Double;Ljava/lang/Double;)Z", "v2", "(Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)Z", "v3", "(Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;)Z", "asFinite", "v", "defaultValue", "(Ljava/lang/Double;D)D", "checkedDoubles", "Ljetbrains/datalore/plot/common/data/SeriesUtil$CheckedDoubleIterable;", "values", "", "Ljetbrains/datalore/plot/common/data/SeriesUtil$CheckedDoubleList;", "", "ensureApplicableRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "range", "preferableNullRange", "expand", "newSpan", "lowerExpand", "upperExpand", "filterFinite", "l0", "l1", "firstNotNull", "T", "list", "(Ljava/util/List;Ljava/lang/Object;)Ljava/lang/Object;", "isBeyondPrecision", "base", "delta", "isFinite", "(Ljava/lang/Double;)Z", "matchingIndices", "", "matchedValue", "matchedValues", "", "mean", "(Ljava/util/List;Ljava/lang/Double;)Ljava/lang/Double;", "pickAtIndices", "indices", "resolution", "naValue", "resolutionFullScan", "skipAtIndices", "span", "range0", "range1", "sum", "toDoubleList", "l", "CheckedDoubleIterable", "CheckedDoubleList", "plot-common-portable"})
public final class SeriesUtil {
    @NotNull
    public static final SeriesUtil INSTANCE = new SeriesUtil();
    public static final double TINY = 1.0E-50;
    private static final int MAX_DECIMAL_PLACES = 12;
    @NotNull
    private static final Function1<Double, Boolean> REAL_NUMBER = REAL_NUMBER.1.INSTANCE;
    @NotNull
    private static final Function1<Double, Boolean> NEGATIVE_NUMBER = NEGATIVE_NUMBER.1.INSTANCE;

    private SeriesUtil() {
    }

    @NotNull
    public final Function1<Double, Boolean> getNEGATIVE_NUMBER() {
        return NEGATIVE_NUMBER;
    }

    public final boolean isBeyondPrecision(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        double delta = range.getLength();
        return delta < 1.0E-50 || this.isBeyondPrecision(range.getLowerEnd(), delta) || this.isBeyondPrecision(range.getUpperEnd(), delta);
    }

    public final boolean isBeyondPrecision(double base, double delta) {
        double deltaPower;
        double basePower = Math.log10(base);
        return basePower - (deltaPower = Math.log10(delta)) > 12.0;
    }

    @NotNull
    public final CheckedDoubleIterable checkedDoubles(@NotNull Iterable<?> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new CheckedDoubleIterable(values);
    }

    @NotNull
    public final CheckedDoubleList checkedDoubles(@NotNull List<?> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new CheckedDoubleList(values);
    }

    public final boolean isFinite(@Nullable Double v) {
        double d;
        return v != null && !Double.isInfinite(d = v.doubleValue()) && !Double.isNaN(d);
    }

    public final double asFinite(@Nullable Double v, double defaultValue) {
        double d;
        return v != null && !Double.isInfinite(d = v.doubleValue()) && !Double.isNaN(d) ? v : defaultValue;
    }

    public final boolean isFinite(double v) {
        double d = v;
        return !Double.isInfinite(d) && !Double.isNaN(d);
    }

    public final boolean allFinite(@Nullable Double v0, @Nullable Double v1) {
        return this.isFinite(v0) && this.isFinite(v1);
    }

    public final boolean allFinite(@Nullable Double v0, @Nullable Double v1, @Nullable Double v2) {
        return this.allFinite(v0, v1) && this.isFinite(v2);
    }

    public final boolean allFinite(@Nullable Double v0, @Nullable Double v1, @Nullable Double v2, @Nullable Double v3) {
        return this.allFinite(v0, v1, v2) && this.isFinite(v3);
    }

    @NotNull
    public final List<List<Double>> filterFinite(@NotNull List<Double> l0, @NotNull List<Double> l1) {
        List list;
        Intrinsics.checkNotNullParameter(l0, (String)"l0");
        Intrinsics.checkNotNullParameter(l1, (String)"l1");
        if (!(l0.size() == l1.size())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ArrayList<Double> l0Copy = new ArrayList<Double>();
        ArrayList<Double> l1Copy = new ArrayList<Double>();
        boolean copy = false;
        Iterator<Double> iterator = l0.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Double v1;
            int i = n++;
            Double v0 = iterator.next();
            if (!this.allFinite(v0, v1 = l1.get(i))) {
                if (copy) continue;
                l0Copy.addAll(CollectionsKt.toList((Iterable)CollectionsKt.take((Iterable)l0, (int)i)));
                l1Copy.addAll(CollectionsKt.toList((Iterable)CollectionsKt.take((Iterable)l1, (int)i)));
                copy = true;
                continue;
            }
            if (!copy) continue;
            Double d = v0;
            if (d == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            l0Copy.add(d);
            Double d2 = v1;
            if (d2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            l1Copy.add(d2);
        }
        boolean bl = copy;
        if (bl) {
            Object[] objectArray = new ArrayList[]{l0Copy, l1Copy};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (!bl) {
            Object[] objectArray = new List[]{l0, l1};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @Nullable
    public final DoubleSpan range(@NotNull Iterable<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        double min = 0.0;
        double max = 0.0;
        boolean inited = false;
        for (Double v : values) {
            if (!this.isFinite(v)) continue;
            if (inited) {
                Double d = v;
                Intrinsics.checkNotNull((Object)d);
                min = Math.min(min, d);
                double d2 = v;
                max = Math.max(max, d2);
                continue;
            }
            Double d = v;
            Intrinsics.checkNotNull((Object)d);
            min = max = d.doubleValue();
            inited = true;
        }
        return inited ? new DoubleSpan(min, max) : null;
    }

    public final double resolution(@NotNull Iterable<Double> values, double naValue) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        RegularMeshDetector rowDetector = RegularMeshDetector.Companion.tryRow(values);
        if (rowDetector.isMesh()) {
            return rowDetector.getResolution();
        }
        RegularMeshDetector columnDetector = RegularMeshDetector.Companion.tryColumn(values);
        return columnDetector.isMesh() ? columnDetector.getResolution() : this.resolutionFullScan(values, naValue);
    }

    /*
     * WARNING - void declaration
     */
    private final double resolutionFullScan(Iterable<Double> values, double naValue) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable<Double> iterable = values;
        Function1<Double, Boolean> predicate$iv = REAL_NUMBER;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable goodDataVector = (List)destination$iv$iv;
        if (Iterables.INSTANCE.isEmpty(goodDataVector)) {
            return naValue;
        }
        List copy = Ordering.Companion.natural().sortedCopy(goodDataVector);
        if (copy.size() < 2) {
            return naValue;
        }
        Iterator it = copy.iterator();
        double resolution = naValue;
        boolean allZero = true;
        double prev = ((Number)it.next()).doubleValue();
        while (it.hasNext()) {
            double curr = ((Number)it.next()).doubleValue();
            double dist = curr - prev;
            if (dist > 0.0 && (dist < resolution || allZero)) {
                allZero = false;
                resolution = dist;
            }
            prev = curr;
        }
        return resolution;
    }

    @NotNull
    public final DoubleSpan ensureApplicableRange(@Nullable DoubleSpan range, @Nullable DoubleSpan preferableNullRange) {
        if (range == null) {
            DoubleSpan doubleSpan = preferableNullRange;
            if (doubleSpan == null) {
                doubleSpan = new DoubleSpan(-0.5, 0.5);
            }
            return doubleSpan;
        }
        if (this.isBeyondPrecision(range)) {
            double median = range.getLowerEnd();
            return new DoubleSpan(median - 0.5, median + 0.5);
        }
        return range;
    }

    public static /* synthetic */ DoubleSpan ensureApplicableRange$default(SeriesUtil seriesUtil, DoubleSpan doubleSpan, DoubleSpan doubleSpan2, int n, Object object) {
        if ((n & 2) != 0) {
            doubleSpan2 = null;
        }
        return seriesUtil.ensureApplicableRange(doubleSpan, doubleSpan2);
    }

    @Nullable
    public final DoubleSpan span(@Nullable DoubleSpan range0, @Nullable DoubleSpan range1) {
        if (range0 == null) {
            return range1;
        }
        DoubleSpan doubleSpan = range1;
        return doubleSpan == null ? range0 : range0.union(doubleSpan);
    }

    @NotNull
    public final DoubleSpan expand(@NotNull DoubleSpan range, double newSpan) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        double expand = (newSpan - range.getLength()) / (double)2;
        return this.expand(range, expand, expand);
    }

    @NotNull
    public final DoubleSpan expand(@NotNull DoubleSpan range, double lowerExpand, double upperExpand) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new DoubleSpan(range.getLowerEnd() - lowerExpand, range.getUpperEnd() + upperExpand);
    }

    public final boolean isFinite(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return !Double.isInfinite(range.getLowerEnd()) && !Double.isInfinite(range.getUpperEnd());
    }

    @NotNull
    public final List<Integer> matchingIndices(@NotNull List<?> list, @Nullable Object matchedValue) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        ArrayList<Integer> result = new ArrayList<Integer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)matchedValue, list.get(i))) continue;
            result.add(i);
        }
        return result;
    }

    @NotNull
    public final List<Integer> matchingIndices(@NotNull List<?> list, @NotNull Set<?> matchedValues) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(matchedValues, (String)"matchedValues");
        ArrayList<Integer> result = new ArrayList<Integer>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!CollectionsKt.contains((Iterable)matchedValues, list.get(i))) continue;
            result.add(i);
        }
        return result;
    }

    @NotNull
    public final <T> List<T> pickAtIndices(@NotNull List<? extends T> list, @NotNull List<Integer> indices) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        int initialCapacity = indices.size() > 10 ? indices.size() : 10;
        ArrayList<T> result = new ArrayList<T>(initialCapacity);
        Iterator<Integer> iterator = indices.iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            if (index >= list.size()) continue;
            result.add(list.get(index));
        }
        return result;
    }

    @NotNull
    public final <T> List<T> pickAtIndices(@NotNull List<? extends T> list, @NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        ArrayList<T> result = new ArrayList<T>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!indices.contains(i)) continue;
            result.add(list.get(i));
        }
        return result;
    }

    @NotNull
    public final <T> List<T> skipAtIndices(@NotNull List<? extends T> list, @NotNull Set<Integer> indices) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        ArrayList<T> result = new ArrayList<T>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (indices.contains(i)) continue;
            result.add(list.get(i));
        }
        return result;
    }

    public final <T> T firstNotNull(@NotNull List<? extends T> list, T defaultValue) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        for (T v : list) {
            if (v == null) continue;
            return v;
        }
        return defaultValue;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double mean(@NotNull List<Double> values, @Nullable Double defaultValue) {
        void $this$foldIndexed$iv;
        boolean bl;
        double firstValue;
        block6: {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Double d = (Double)SequencesKt.firstOrNull(SeriesUtil.mean$notNanDoubles(values));
            if (d == null) {
                return defaultValue;
            }
            firstValue = d;
            Sequence<Double> $this$all$iv = SeriesUtil.mean$notNanDoubles(values);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                double it = ((Number)element$iv).doubleValue();
                boolean bl2 = false;
                if (it == firstValue) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            return firstValue;
        }
        Sequence<Double> sequence = SeriesUtil.mean$notNanDoubles(values);
        double initial$iv = 0.0;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void mean2;
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)element$iv).doubleValue();
            double d2 = accumulator$iv;
            int i = n;
            boolean bl3 = false;
            accumulator$iv = value / ((double)i + 1.0) + mean2 * ((double)i / ((double)i + 1.0));
        }
        double result = accumulator$iv;
        Double d = result;
        double it = ((Number)d).doubleValue();
        boolean bl4 = false;
        Double d3 = !Double.isNaN(it) ? d : null;
        if (d3 == null) {
            d3 = defaultValue;
        }
        return d3;
    }

    public final double sum(@NotNull List<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        double result = 0.0;
        for (Double value : values) {
            double d;
            if (value == null || !(!Double.isInfinite(d = value.doubleValue()) && !Double.isNaN(d))) continue;
            result += value.doubleValue();
        }
        return result;
    }

    @Nullable
    public final List<Double> toDoubleList(@Nullable List<?> l) {
        return l == null ? null : new CheckedDoubleList(l).cast();
    }

    private static final Sequence<Double> mean$notNanDoubles(List<Double> $values) {
        return SequencesKt.filterNot((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)$values)), (Function1)mean.notNanDoubles.1.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003H\u0016\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/common/data/SeriesUtil$CheckedDoubleList;", "Ljetbrains/datalore/plot/common/data/SeriesUtil$CheckedDoubleIterable;", "list", "", "(Ljava/util/List;)V", "cast", "", "plot-common-portable"})
    public static final class CheckedDoubleList
    extends CheckedDoubleIterable {
        public CheckedDoubleList(@NotNull List<?> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            super((Iterable)list);
        }

        @NotNull
        public List<Double> cast() {
            return (List)super.cast();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003H\u0016J\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/common/data/SeriesUtil$CheckedDoubleIterable;", "", "myIterable", "", "(Ljava/lang/Iterable;)V", "myCanBeCast", "", "myEmpty", "canBeCast", "cast", "", "notEmptyAndCanBeCast", "plot-common-portable"})
    public static class CheckedDoubleIterable {
        @NotNull
        private final Iterable<?> myIterable;
        private final boolean myEmpty;
        private final boolean myCanBeCast;

        /*
         * WARNING - void declaration
         */
        public CheckedDoubleIterable(@NotNull Iterable<?> myIterable) {
            boolean bl;
            Intrinsics.checkNotNullParameter(myIterable, (String)"myIterable");
            this.myIterable = myIterable;
            this.myEmpty = Iterables.INSTANCE.isEmpty(this.myIterable);
            CheckedDoubleIterable checkedDoubleIterable = this;
            if (this.myEmpty) {
                bl = true;
            } else {
                boolean bl2;
                CheckedDoubleIterable checkedDoubleIterable2;
                block5: {
                    void $this$all$iv;
                    Iterable iterable = CollectionsKt.filterNotNull(this.myIterable);
                    checkedDoubleIterable2 = checkedDoubleIterable;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        Iterator iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv;
                            Object input = element$iv = iterator.next();
                            boolean bl3 = false;
                            if (input instanceof Double) continue;
                            bl2 = false;
                            break block5;
                        }
                        bl2 = true;
                    }
                }
                boolean bl4 = bl2;
                checkedDoubleIterable = checkedDoubleIterable2;
                bl = bl4;
            }
            checkedDoubleIterable.myCanBeCast = bl;
        }

        public final boolean notEmptyAndCanBeCast() {
            return !this.myEmpty && this.myCanBeCast;
        }

        public final boolean canBeCast() {
            return this.myCanBeCast;
        }

        @NotNull
        public Iterable<Double> cast() {
            if (!this.myCanBeCast) {
                boolean bl = false;
                String string = "Can't cast to a collection of Double(s)";
                throw new IllegalStateException(string.toString());
            }
            return this.myIterable;
        }
    }
}

