/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.geometry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.common.geometry.PolylineSimplifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0016J\u0016\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013H\u0002J\b\u0010\u0018\u001a\u00020\tH\u0002J\b\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/common/geometry/VisvalingamWhyattSimplification;", "Ljetbrains/datalore/plot/common/geometry/PolylineSimplifier$RankingStrategy;", "()V", "isEmpty", "", "()Z", "isSimplificationDone", "myTriangles", "", "Ljetbrains/datalore/plot/common/geometry/VisvalingamWhyattSimplification$Triangle;", "myVerticesToRemove", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "add", "", "triangle", "getIndex", "getWeights", "", "", "points", "Ljetbrains/datalore/base/geometry/DoubleVector;", "initTriangles", "peek", "poll", "takeTriangle", "update", "Companion", "Triangle", "plot-common-portable"})
public final class VisvalingamWhyattSimplification
implements PolylineSimplifier.RankingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<Integer> myVerticesToRemove = new ArrayList();
    @Nullable
    private List<Triangle> myTriangles;
    private static final double INITIAL_AREA = Double.MAX_VALUE;

    private final boolean isSimplificationDone() {
        return this.isEmpty();
    }

    private final boolean isEmpty() {
        List<Triangle> list = this.myTriangles;
        Intrinsics.checkNotNull(list);
        return list.isEmpty();
    }

    @Override
    @NotNull
    public List<Double> getWeights(@NotNull List<DoubleVector> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        this.myTriangles = new ArrayList(points.size() - 2);
        this.initTriangles(points);
        int n = points.size();
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Double> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(INITIAL_AREA);
        }
        List weights = arrayList;
        double lastRemovedVertexArea = 0.0;
        while (!this.isSimplificationDone()) {
            Triangle prev;
            Triangle triangle = this.takeTriangle();
            lastRemovedVertexArea = triangle.getArea() > lastRemovedVertexArea ? triangle.getArea() : lastRemovedVertexArea;
            weights.set(triangle.getCurrentVertex(), lastRemovedVertexArea);
            Triangle next = triangle.getNext();
            if (next != null) {
                next.takePrevFrom$plot_common_portable(triangle);
                this.update(next);
            }
            if ((prev = triangle.getPrev()) != null) {
                prev.takeNextFrom$plot_common_portable(triangle);
                this.update(prev);
            }
            this.myVerticesToRemove.add(triangle.getCurrentVertex());
        }
        return weights;
    }

    private final void initTriangles(List<DoubleVector> points) {
        ArrayList<Triangle> triangles = new ArrayList<Triangle>(points.size() - 2);
        VisvalingamWhyattSimplification $this$initTriangles_u24lambda_u2d1 = this;
        boolean bl = false;
        int n = points.size() - 1;
        for (int i = 1; i < n; ++i) {
            triangles.add(new Triangle(i, points));
        }
        int n2 = triangles.size() - 1;
        for (int i = 1; i < n2; ++i) {
            ((Triangle)triangles.get(i)).setNext((Triangle)triangles.get(i + 1));
            ((Triangle)triangles.get(i)).setPrev((Triangle)triangles.get(i - 1));
        }
        Iterable $this$forEach$iv = triangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triangle it = (Triangle)element$iv;
            boolean bl2 = false;
            this.add(it);
        }
    }

    private final Triangle takeTriangle() {
        Triangle minimalTriangle = this.poll();
        this.myVerticesToRemove.add(minimalTriangle.getCurrentVertex());
        return minimalTriangle;
    }

    private final void add(Triangle triangle) {
        int index = this.getIndex(triangle);
        List<Triangle> list = this.myTriangles;
        Intrinsics.checkNotNull(list);
        list.add(index, triangle);
    }

    private final int getIndex(Triangle triangle) {
        List<Triangle> list = this.myTriangles;
        Intrinsics.checkNotNull(list);
        int index = CollectionsKt.binarySearch$default(list, (Object)triangle, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Triangle it = (Triangle)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getArea());
                it = (Triangle)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getArea()));
            }
        }, (int)0, (int)0, (int)12, null);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        return index;
    }

    private final Triangle peek() {
        List<Triangle> list = this.myTriangles;
        Intrinsics.checkNotNull(list);
        return list.get(0);
    }

    private final Triangle poll() {
        Triangle triangle = this.peek();
        List<Triangle> list = this.myTriangles;
        Intrinsics.checkNotNull(list);
        list.remove(triangle);
        return triangle;
    }

    private final void update(Triangle triangle) {
        List<Triangle> list = this.myTriangles;
        Intrinsics.checkNotNull(list);
        list.remove(triangle);
        List<Triangle> list2 = this.myTriangles;
        Intrinsics.checkNotNull(list2);
        list2.add(triangle);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\tH\u0002J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001fR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/datalore/plot/common/geometry/VisvalingamWhyattSimplification$Triangle;", "", "currentVertex", "", "myPoints", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(ILjava/util/List;)V", "<set-?>", "", "area", "getArea", "()D", "getCurrentVertex", "()I", "next", "getNext", "()Ljetbrains/datalore/plot/common/geometry/VisvalingamWhyattSimplification$Triangle;", "setNext", "(Ljetbrains/datalore/plot/common/geometry/VisvalingamWhyattSimplification$Triangle;)V", "nextVertex", "prev", "getPrev", "setPrev", "prevVertex", "calculateArea", "takeNextFrom", "", "triangle", "takeNextFrom$plot_common_portable", "takePrevFrom", "takePrevFrom$plot_common_portable", "plot-common-portable"})
    private static final class Triangle {
        private final int currentVertex;
        @NotNull
        private final List<DoubleVector> myPoints;
        private double area;
        private int prevVertex;
        private int nextVertex;
        @Nullable
        private Triangle prev;
        @Nullable
        private Triangle next;

        public Triangle(int currentVertex, @NotNull List<DoubleVector> myPoints) {
            Intrinsics.checkNotNullParameter(myPoints, (String)"myPoints");
            this.currentVertex = currentVertex;
            this.myPoints = myPoints;
            this.prevVertex = this.currentVertex - 1;
            this.nextVertex = this.currentVertex + 1;
            this.area = this.calculateArea();
        }

        public final int getCurrentVertex() {
            return this.currentVertex;
        }

        public final double getArea() {
            return this.area;
        }

        @Nullable
        public final Triangle getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Triangle triangle) {
            this.prev = triangle;
        }

        @Nullable
        public final Triangle getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Triangle triangle) {
            this.next = triangle;
        }

        public final void takeNextFrom$plot_common_portable(@NotNull Triangle triangle) {
            Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
            this.next = triangle.next;
            this.nextVertex = triangle.nextVertex;
            this.area = this.calculateArea();
        }

        public final void takePrevFrom$plot_common_portable(@NotNull Triangle triangle) {
            Intrinsics.checkNotNullParameter((Object)triangle, (String)"triangle");
            this.prev = triangle.prev;
            this.prevVertex = triangle.prevVertex;
            this.area = this.calculateArea();
        }

        private final double calculateArea() {
            DoubleVector a = this.myPoints.get(this.prevVertex);
            DoubleVector b = this.myPoints.get(this.currentVertex);
            DoubleVector c = this.myPoints.get(this.nextVertex);
            return Math.abs(((b.getX() - a.getX()) * (c.getY() - a.getY()) - (c.getX() - a.getX()) * (b.getY() - a.getY())) / 2.0);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/common/geometry/VisvalingamWhyattSimplification$Companion;", "", "()V", "INITIAL_AREA", "", "plot-common-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

