/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.time.interval;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.plot.common.text.Formatter;
import jetbrains.datalore.plot.common.time.interval.MeasuredInDays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/common/time/interval/YearInterval;", "Ljetbrains/datalore/plot/common/time/interval/MeasuredInDays;", "count", "", "(I)V", "tickFormatPattern", "", "getTickFormatPattern", "()Ljava/lang/String;", "addInterval", "Ljetbrains/datalore/base/datetime/DateTime;", "toInstant", "addYear", "getFirstDayContaining", "Ljetbrains/datalore/base/datetime/Date;", "instant", "Companion", "plot-common-portable"})
public final class YearInterval
extends MeasuredInDays {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tickFormatPattern;
    @NotNull
    public static final String TICK_FORMAT = "%Y";
    public static final double MS = 3.1536E10;
    @NotNull
    private static final Function1<Object, String> TICK_FORMATTER = Formatter.INSTANCE.time("%Y");

    public YearInterval(int count) {
        super(count);
        this.tickFormatPattern = TICK_FORMAT;
    }

    @Override
    @NotNull
    public String getTickFormatPattern() {
        return this.tickFormatPattern;
    }

    @Override
    @NotNull
    protected Date getFirstDayContaining(@NotNull DateTime instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return Date.Companion.firstDayOf$default((Date.Companion)Date.Companion, (int)instant.getYear(), null, (int)2, null);
    }

    @Override
    @NotNull
    protected DateTime addInterval(@NotNull DateTime toInstant) {
        Intrinsics.checkNotNullParameter((Object)toInstant, (String)"toInstant");
        DateTime result = toInstant;
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            result = this.addYear(result);
        }
        return result;
    }

    private final DateTime addYear(DateTime toInstant) {
        int year = toInstant.getYear();
        return new DateTime(Date.Companion.firstDayOf$default((Date.Companion)Date.Companion, (int)(year + 1), null, (int)2, null), null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/common/time/interval/YearInterval$Companion;", "", "()V", "MS", "", "TICK_FORMAT", "", "TICK_FORMATTER", "Lkotlin/Function1;", "getTICK_FORMATTER", "()Lkotlin/jvm/functions/Function1;", "plot-common-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Object, String> getTICK_FORMATTER() {
            return TICK_FORMATTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

