/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.server.config.transform.bistro.corr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.values.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J*\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\b2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bJ\u0018\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u001e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0001\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/server/config/transform/bistro/corr/DataUtil;", "", "()V", "needToStandardizeValues", "", "series", "", "standardiseData", "", "", "", "rawData", "standardizeIterable", "standardizeList", "toList", "key", "rawValue", "plot-config-portable"})
public final class DataUtil {
    @NotNull
    public static final DataUtil INSTANCE = new DataUtil();

    private DataUtil() {
    }

    @NotNull
    public final Map<String, List<Object>> standardiseData(@NotNull Map<?, ?> rawData) {
        Intrinsics.checkNotNullParameter(rawData, (String)"rawData");
        LinkedHashMap standardisedData = new LinkedHashMap();
        Object object = rawData;
        boolean bl = false;
        Iterator<Map.Entry<?, ?>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            Object rawKey = object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            Object rawValue = object3.getValue();
            String key = String.valueOf(rawKey);
            Map map2 = standardisedData;
            Object v = rawValue;
            Intrinsics.checkNotNull(v);
            List<Object> list2 = this.toList(key, v);
            boolean bl4 = false;
            map2.put(key, list2);
        }
        return standardisedData;
    }

    @NotNull
    public final List<Object> toList(@NotNull String key, @NotNull Object rawValue) {
        List<?> list2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        Object object = rawValue;
        if (object instanceof List) {
            list2 = this.standardizeList((List)rawValue);
        } else if (object instanceof Iterable) {
            list2 = CollectionsKt.toList(this.standardizeIterable((Iterable)rawValue));
        } else if (object instanceof Sequence) {
            list2 = CollectionsKt.toList(this.standardizeIterable(SequencesKt.asIterable((Sequence)((Sequence)rawValue))));
        } else if (object instanceof Object[]) {
            list2 = this.standardizeList(ArraysKt.asList((Object[])((Object[])rawValue)));
        } else if (object instanceof byte[]) {
            list2 = this.standardizeList(ArraysKt.asList((byte[])((byte[])rawValue)));
        } else if (object instanceof short[]) {
            list2 = this.standardizeList(ArraysKt.asList((short[])((short[])rawValue)));
        } else if (object instanceof int[]) {
            list2 = this.standardizeList(ArraysKt.asList((int[])((int[])rawValue)));
        } else if (object instanceof long[]) {
            list2 = this.standardizeList(ArraysKt.asList((long[])((long[])rawValue)));
        } else if (object instanceof float[]) {
            list2 = this.standardizeList(ArraysKt.asList((float[])((float[])rawValue)));
        } else if (object instanceof double[]) {
            list2 = this.standardizeList(ArraysKt.asList((double[])((double[])rawValue)));
        } else if (object instanceof char[]) {
            list2 = this.standardizeList(ArraysKt.asList((char[])((char[])rawValue)));
        } else if (object instanceof Pair) {
            list2 = this.standardizeList(TuplesKt.toList((Pair)((Pair)rawValue)));
        } else {
            throw new IllegalArgumentException("Can't transform data[\"" + key + "\"] of type " + Reflection.getOrCreateKotlinClass(rawValue.getClass()).getSimpleName() + " to a list");
        }
        return list2;
    }

    private final List<?> standardizeList(List<?> series) {
        return (List)this.standardizeIterable((Iterable)series);
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<?> standardizeIterable(Iterable<?> series) {
        Iterable iterable;
        if (this.needToStandardizeValues(series)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = series;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                if (var11_11 == null) {
                    object = it;
                } else if (var11_11 instanceof String) {
                    object = it;
                } else if (var11_11 instanceof Number) {
                    object = DataUtil.standardizeIterable$toDouble((Number)it);
                } else if (var11_11 instanceof Character) {
                    object = String.valueOf(((Character)it).charValue());
                } else if (var11_11 instanceof Color) {
                    object = ((Color)it).toHexColor();
                } else {
                    throw new IllegalArgumentException("Can't standardize the value \"" + it + "\" of type " + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + " as a string, number or date-time.");
                }
                void var13_13 = object;
                collection.add(var13_13);
            }
            iterable = (List)destination$iv$iv;
        } else {
            iterable = series;
        }
        return iterable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToStandardizeValues(Iterable<?> series) {
        boolean bl;
        Iterable<?> $this$any$iv = series;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator<?> iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            Object it = element$iv = iterator.next();
            boolean bl2 = false;
            if (it != null) {
                if (!(it instanceof String)) {
                    if (!(it instanceof Double)) return true;
                }
                if (it instanceof Double) {
                    double d = ((Number)it).doubleValue();
                    boolean bl3 = false;
                    double d2 = d;
                    boolean bl4 = false;
                    if (Double.isInfinite(d2)) return true;
                    d2 = d;
                    bl4 = false;
                    if (Double.isNaN(d2)) return true;
                    boolean bl5 = true;
                    if (!bl5) {
                        return true;
                    }
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final Void standardizeIterable$noTimeZoneError(Object time) {
        throw new IllegalArgumentException("Can't convert " + Reflection.getOrCreateKotlinClass(time.getClass()).getSimpleName() + " to the number of milliseconds from the epoch of 1970-01-01T00:00:00Z.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Double standardizeIterable$toDouble(Number n) {
        Double d;
        Number number = n;
        if (number instanceof Float) {
            float f = n.floatValue();
            boolean bl = false;
            float f2 = f;
            boolean bl2 = false;
            if (Float.isInfinite(f2)) return null;
            f2 = f;
            bl2 = false;
            if (Float.isNaN(f2)) return null;
            boolean bl3 = true;
            if (!bl3) return null;
            d = n.doubleValue();
            return d;
        } else if (number instanceof Double) {
            double d2 = n.doubleValue();
            boolean bl = false;
            double d3 = d2;
            boolean bl4 = false;
            if (Double.isInfinite(d3)) return null;
            d3 = d2;
            bl4 = false;
            if (Double.isNaN(d3)) return null;
            boolean bl5 = true;
            if (!bl5) return null;
            d = (Double)n;
            return d;
        } else {
            d = n.doubleValue();
        }
        return d;
    }
}

