/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svg;

import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgTextNode;
import jetbrains.datalore.vis.svg.slim.WithTextGen;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/vis/svg/SvgNodeBufferUtil;", "", "()V", "generateSvgElementBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "source", "Ljetbrains/datalore/vis/svg/SvgElement;", "generateSvgNodeBuffer", "Ljetbrains/datalore/vis/svg/SvgNode;", "vis-svg-portable"})
public final class SvgNodeBufferUtil {
    @NotNull
    public static final SvgNodeBufferUtil INSTANCE = new SvgNodeBufferUtil();

    private SvgNodeBufferUtil() {
    }

    @NotNull
    public final StringBuilder generateSvgNodeBuffer(@NotNull SvgNode source) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        if (source instanceof WithTextGen) {
            StringBuilder sb = new StringBuilder();
            ((WithTextGen)((Object)source)).appendTo(sb);
            return sb;
        }
        if (source instanceof SvgElement) {
            return this.generateSvgElementBuffer((SvgElement)source);
        }
        if (source instanceof SvgTextNode) {
            return new StringBuilder((String)((SvgTextNode)source).textContent().get());
        }
        throw new IllegalStateException("Can't generate dom for svg node " + Reflection.getOrCreateKotlinClass(((Object)((Object)source)).getClass()).getSimpleName());
    }

    private final StringBuilder generateSvgElementBuffer(SvgElement source) {
        String elementName = source.getElementName();
        StringBuilder sb = new StringBuilder();
        sb.append('<').append(elementName);
        for (SvgAttributeSpec<?> key : source.getAttributeKeys()) {
            sb.append(' ').append(key).append("=\"").append(source.getAttribute(key.getName()).get()).append('\"');
        }
        sb.append('>');
        for (SvgNode child : source.children()) {
            sb.append((CharSequence)this.generateSvgNodeBuffer(child));
        }
        sb.append("</").append(elementName).append('>');
        return sb;
    }
}

