/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svg;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002J\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000bJ\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/vis/svg/SvgStylableElement;", "Ljetbrains/datalore/vis/svg/SvgElement;", "()V", "addClass", "", "cl", "", "buildClassString", "classes", "", "classAttribute", "Ljetbrains/datalore/base/observable/property/Property;", "fullClass", "hasClass", "removeClass", "replaceClass", "", "oldClass", "newClass", "toggleClass", "validateClassName", "Companion", "vis-svg-portable"})
public abstract class SvgStylableElement
extends SvgElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SvgAttributeSpec<String> CLASS = SvgAttributeSpec.Companion.createSpec("class");

    @NotNull
    public final Property<String> classAttribute() {
        return this.getAttribute(CLASS);
    }

    public final boolean addClass(@NotNull String cl) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        this.validateClassName(cl);
        Property<String> attr = this.classAttribute();
        if (attr.get() == null) {
            attr.set((Object)cl);
            return true;
        }
        Object object = attr.get();
        Intrinsics.checkNotNull((Object)object);
        String[] stringArray = new String[]{" "};
        if (StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null).contains(cl)) {
            return false;
        }
        attr.set((Object)((String)attr.get() + ' ' + cl));
        return true;
    }

    public final boolean removeClass(@NotNull String cl) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        this.validateClassName(cl);
        Property<String> attr = this.classAttribute();
        if (attr.get() == null) {
            return false;
        }
        Object object = attr.get();
        Intrinsics.checkNotNull((Object)object);
        String[] stringArray = new String[]{" "};
        ArrayList classes = new ArrayList(StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        boolean result = classes.remove(cl);
        if (result) {
            attr.set((Object)this.buildClassString(classes));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceClass(@NotNull String oldClass, @NotNull String newClass) {
        Intrinsics.checkNotNullParameter((Object)oldClass, (String)"oldClass");
        Intrinsics.checkNotNullParameter((Object)newClass, (String)"newClass");
        this.validateClassName(oldClass);
        this.validateClassName(newClass);
        Property<String> attr = this.classAttribute();
        if (attr.get() == null) {
            throw new IllegalStateException("Trying to replace class when class is empty");
        }
        Object object = attr.get();
        Intrinsics.checkNotNull((Object)object);
        String[] stringArray = new String[]{" "};
        List classes = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!classes.contains(oldClass)) {
            throw new IllegalStateException("Class attribute does not contain specified oldClass");
        }
        int n = classes.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add((String)classes.get((int)i));
        }
        List mutableClasses = arrayList;
        mutableClasses.set(classes.indexOf(oldClass), newClass);
        attr.set((Object)this.buildClassString(mutableClasses));
    }

    public final boolean toggleClass(@NotNull String cl) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        if (this.hasClass(cl)) {
            this.removeClass(cl);
            bl = false;
        } else {
            this.addClass(cl);
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasClass(@NotNull String cl) {
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        this.validateClassName(cl);
        Property<String> attr = this.classAttribute();
        if (attr.get() == null) return false;
        Object object = attr.get();
        Intrinsics.checkNotNull((Object)object);
        String[] stringArray = new String[]{" "};
        if (!new ArrayList(StringsKt.split$default((CharSequence)((CharSequence)object), (String[])stringArray, (boolean)false, (int)0, (int)6, null)).contains(cl)) return false;
        return true;
    }

    @NotNull
    public final String fullClass() {
        String string;
        Property<String> attr = this.classAttribute();
        if (attr.get() == null) {
            string = "";
        } else {
            Object object = attr.get();
            Intrinsics.checkNotNull((Object)object);
            string = (String)object;
        }
        return string;
    }

    private final String buildClassString(List<String> classes) {
        StringBuilder builder = new StringBuilder();
        for (String className : classes) {
            if (((CharSequence)builder).length() > 0) {
                builder.append(' ');
            }
            builder.append(className);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final void validateClassName(String cl) {
        if (StringsKt.contains$default((CharSequence)cl, (CharSequence)" ", (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("Class name cannot contain spaces");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/vis/svg/SvgStylableElement$Companion;", "", "()V", "CLASS", "Ljetbrains/datalore/vis/svg/SvgAttributeSpec;", "", "getCLASS", "()Ljetbrains/datalore/vis/svg/SvgAttributeSpec;", "vis-svg-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgAttributeSpec<String> getCLASS() {
            return CLASS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

