/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.InlineBuilder;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.TopLevelBuilder;
import org.intellij.markdown.parser.sequentialparsers.LexerBasedTokensCache;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0006H\u0002J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0006J&\u0010\u0017\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/intellij/markdown/parser/MarkdownParser;", "", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "(Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;)V", "assertionsEnabled", "", "(Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;Z)V", "buildMarkdownTreeFromString", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "doParse", "root", "Lorg/intellij/markdown/IElementType;", "parseInlines", "doParseInline", "", "textStart", "", "textEnd", "inlineFallback", "parse", "parseInline", "topLevelFallback", "InlineExpandingASTNodeBuilder", "markdown"})
public final class MarkdownParser {
    @NotNull
    private final MarkdownFlavourDescriptor flavour;
    private final boolean assertionsEnabled;

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour, boolean assertionsEnabled) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        this.flavour = flavour;
        this.assertionsEnabled = assertionsEnabled;
    }

    public /* synthetic */ MarkdownParser(MarkdownFlavourDescriptor markdownFlavourDescriptor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(markdownFlavourDescriptor, bl);
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        this(flavour, true);
    }

    @NotNull
    public final ASTNode buildMarkdownTreeFromString(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.parse(MarkdownElementTypes.MARKDOWN_FILE, text, true);
    }

    @NotNull
    public final ASTNode parse(@NotNull IElementType root, @NotNull String text, boolean parseInlines) {
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            aSTNode = this.doParse(root, text, parseInlines);
        }
        catch (MarkdownParsingException e) {
            if (this.assertionsEnabled) {
                throw e;
            }
            aSTNode = this.topLevelFallback(root, text);
        }
        return aSTNode;
    }

    public static /* synthetic */ ASTNode parse$default(MarkdownParser markdownParser, IElementType iElementType, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return markdownParser.parse(iElementType, string, bl);
    }

    @NotNull
    public final ASTNode parseInline(@NotNull IElementType root, @NotNull CharSequence text, int textStart, int textEnd) {
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            aSTNode = this.doParseInline(root, text, textStart, textEnd);
        }
        catch (MarkdownParsingException e) {
            if (this.assertionsEnabled) {
                throw e;
            }
            aSTNode = this.inlineFallback(root, textStart, textEnd);
        }
        return aSTNode;
    }

    private final ASTNode doParse(IElementType root, String text, boolean parseInlines) {
        ProductionHolder productionHolder = new ProductionHolder();
        MarkerProcessor<?> markerProcessor = this.flavour.getMarkerProcessorFactory().createMarkerProcessor(productionHolder);
        ProductionHolder.Marker rootMarker = productionHolder.mark();
        LookaheadText textHolder = new LookaheadText(text);
        LookaheadText.Position pos = textHolder.getStartPosition();
        while (pos != null) {
            productionHolder.updatePosition(pos.getOffset());
            pos = markerProcessor.processPosition(pos);
        }
        productionHolder.updatePosition(text.length());
        markerProcessor.flushMarkers();
        rootMarker.done(root);
        ASTNodeBuilder nodeBuilder = parseInlines ? (ASTNodeBuilder)new InlineExpandingASTNodeBuilder(text) : new ASTNodeBuilder(text);
        TopLevelBuilder builder = new TopLevelBuilder(nodeBuilder);
        return builder.buildTree(productionHolder.getProduction());
    }

    static /* synthetic */ ASTNode doParse$default(MarkdownParser markdownParser, IElementType iElementType, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return markdownParser.doParse(iElementType, string, bl);
    }

    private final ASTNode doParseInline(IElementType root, CharSequence text, int textStart, int textEnd) {
        MarkdownLexer lexer = this.flavour.createInlinesLexer();
        MarkdownLexer.start$default(lexer, text, textStart, textEnd, 0, 8, null);
        LexerBasedTokensCache tokensCache = new LexerBasedTokensCache(lexer);
        IntRange wholeRange = new IntRange(0, tokensCache.getFilteredTokens().size());
        Collection<SequentialParser.Node> nodes = this.flavour.getSequentialParserManager().runParsingSequence(tokensCache, SequentialParserUtil.Companion.filterBlockquotes(tokensCache, wholeRange));
        return new InlineBuilder(new ASTNodeBuilder(text), tokensCache).buildTree(CollectionsKt.plus(nodes, (Iterable)CollectionsKt.listOf((Object)new SequentialParser.Node(wholeRange, root))));
    }

    private final ASTNode topLevelFallback(IElementType root, String text) {
        return new CompositeASTNode(root, CollectionsKt.listOf((Object)this.inlineFallback(MarkdownElementTypes.PARAGRAPH, 0, text.length())));
    }

    private final ASTNode inlineFallback(IElementType root, int textStart, int textEnd) {
        return new CompositeASTNode(root, CollectionsKt.listOf((Object)new LeafASTNode(MarkdownTokenTypes.TEXT, textStart, textEnd)));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/markdown/parser/MarkdownParser$InlineExpandingASTNodeBuilder;", "Lorg/intellij/markdown/ast/ASTNodeBuilder;", "text", "", "(Lorg/intellij/markdown/parser/MarkdownParser;Ljava/lang/CharSequence;)V", "createLeafNodes", "", "Lorg/intellij/markdown/ast/ASTNode;", "type", "Lorg/intellij/markdown/IElementType;", "startOffset", "", "endOffset", "markdown"})
    private final class InlineExpandingASTNodeBuilder
    extends ASTNodeBuilder {
        public InlineExpandingASTNodeBuilder(CharSequence text) {
            Intrinsics.checkNotNullParameter((Object)MarkdownParser.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
        }

        @Override
        @NotNull
        public List<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            IElementType iElementType = type;
            return (((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.ATX_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SETEXT_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CELL)) ? CollectionsKt.listOf((Object)MarkdownParser.this.parseInline(type, this.getText(), startOffset, endOffset)) : super.createLeafNodes(type, startOffset, endOffset);
        }
    }
}

