/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.bc.BcDSAContentSignerBuilder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\bH\u0007J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0014\u0010\u0018\u001a\u00020\u00132\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00190\bJ\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0010\u001a\u00020\u001bH\u0007J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0014\u0010\u001f\u001a\u00020\u0013*\u00020\u00192\u0006\u0010 \u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/zip/signer/signer/CertificateUtils;", "", "()V", "farAwayDate", "Ljava/util/Date;", "findRevokedCertificate", "Ljava/security/cert/X509Certificate;", "certs", "", "revocationLists", "Ljava/security/cert/X509CRL;", "generateDummyCertificate", "keyPair", "Lorg/bouncycastle/openssl/PEMKeyPair;", "getCrlUris", "Ljava/net/URI;", "certificate", "getRevocationLists", "isCertificateRevoked", "", "certificateAuthority", "revocationList", "isCrlValid", "certificateRevocationList", "isValidCertificateChain", "Ljava/security/cert/Certificate;", "loadCertificates", "", "loadCertificatesFromFile", "file", "Ljava/io/File;", "isSignedBy", "other", "lib"})
@SourceDebugExtension(value={"SMAP\nCertificateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateUtils.kt\norg/jetbrains/zip/signer/signer/CertificateUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,209:1\n1549#2:210\n1620#2,3:211\n1726#2,3:214\n1549#2:217\n1620#2,3:218\n3433#2,7:225\n13309#3:221\n13309#3,2:222\n13310#3:224\n1#4:232\n*S KotlinDebug\n*F\n+ 1 CertificateUtils.kt\norg/jetbrains/zip/signer/signer/CertificateUtils\n*L\n56#1:210\n56#1:211,3\n88#1:214,3\n105#1:217\n105#1:218,3\n166#1:225,7\n130#1:221\n134#1:222,2\n130#1:224\n*E\n"})
public final class CertificateUtils {
    @NotNull
    public static final CertificateUtils INSTANCE = new CertificateUtils();
    @NotNull
    private static final Date farAwayDate;

    private CertificateUtils() {
    }

    @JvmStatic
    @NotNull
    public static final List<X509Certificate> loadCertificatesFromFile(@NotNull File file) throws CertificateException {
        Intrinsics.checkNotNullParameter(file, "file");
        return CertificateUtils.loadCertificates(FilesKt.readText$default(file, null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<X509Certificate> loadCertificates(@NotNull String certificate) throws CertificateException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        String string = certificate;
        Object object = Charsets.UTF_8;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(new ByteArrayInputStream(byArray));
        Intrinsics.checkNotNullExpressionValue(collection, "generateCertificates(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Certificate certificate2 = (Certificate)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection2.add((X509Certificate)it);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final X509Certificate generateDummyCertificate(@NotNull PEMKeyPair keyPair) {
        ContentSigner contentSigner;
        Intrinsics.checkNotNullParameter(keyPair, "keyPair");
        X500Name dummyName = new X500Name("CN=Dummy Certificate");
        Date yesterday = Date.from(Instant.now().minus(Duration.ofDays(1L)));
        AsymmetricKeyParameter privateKey = PrivateKeyFactory.createKey(keyPair.getPrivateKeyInfo());
        if (privateKey instanceof RSAPrivateCrtKeyParameters) {
            contentSigner = new BcRSAContentSignerBuilder(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption), new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)).build(privateKey);
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            contentSigner = new BcDSAContentSignerBuilder(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)).build(privateKey);
        } else {
            throw new IllegalArgumentException("Unsupported key type: " + privateKey.getClass().getSimpleName());
        }
        ContentSigner contentSigner2 = contentSigner;
        X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(new X509v3CertificateBuilder(dummyName, BigInteger.valueOf(System.currentTimeMillis()), yesterday, farAwayDate, dummyName, keyPair.getPublicKeyInfo()).build(contentSigner2));
        Intrinsics.checkNotNullExpressionValue(x509Certificate, "getCertificate(...)");
        return x509Certificate;
    }

    public final boolean isValidCertificateChain(@NotNull List<? extends Certificate> certs) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(certs, "certs");
            Iterable $this$all$iv = CollectionsKt.zipWithNext((Iterable)certs);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.isSignedBy((Certificate)it.getFirst(), (Certificate)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<X509CRL> getRevocationLists(@NotNull List<? extends X509Certificate> certs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(certs, "certs");
        List<? extends X509Certificate> certsExceptCA = certs.subList(0, certs.size() - 1);
        Iterable $this$map$iv = certsExceptCA;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void certificate;
            X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<URI> crlUris = CertificateUtils.getCrlUris((X509Certificate)certificate);
            if (crlUris.isEmpty()) {
                throw new IllegalArgumentException("CRL not found for certificate");
            }
            if (crlUris.size() > 1) {
                throw new IllegalArgumentException("Multiple CRL URI found in certificate");
            }
            URI crlURI = CollectionsKt.first(crlUris);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            CRL cRL = certificateFactory.generateCRL(crlURI.toURL().openConnection().getInputStream());
            Intrinsics.checkNotNull(cRL, "null cannot be cast to non-null type java.security.cert.X509CRL");
            collection.add((X509CRL)cRL);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final List<URI> getCrlUris(@NotNull X509Certificate certificate) {
        Object it2;
        Intrinsics.checkNotNullParameter(certificate, "certificate");
        byte[] crlDistributionPointsBytes = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        Closeable closeable = new ASN1InputStream(new ByteArrayInputStream(crlDistributionPointsBytes));
        Object object = null;
        try {
            it2 = (ASN1InputStream)closeable;
            boolean bl = false;
            ASN1Primitive aSN1Primitive = ((ASN1InputStream)it2).readObject();
            Intrinsics.checkNotNull(aSN1Primitive, "null cannot be cast to non-null type org.bouncycastle.asn1.DEROctetString");
            it2 = (DEROctetString)aSN1Primitive;
        }
        catch (Throwable it2) {
            object = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
        Object derOctetString = it2;
        object = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)derOctetString).getOctets()));
        it2 = null;
        try {
            Object it3 = (ASN1InputStream)object;
            boolean bl = false;
            it3 = CRLDistPoint.getInstance(((ASN1InputStream)it3).readObject());
        }
        catch (Throwable it3) {
            it2 = it3;
            throw it3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)it2);
        }
        Object crlDistPoint = it3;
        List crlUris = new ArrayList();
        DistributionPoint[] distributionPointArray = ((CRLDistPoint)crlDistPoint).getDistributionPoints();
        Intrinsics.checkNotNullExpressionValue(distributionPointArray, "getDistributionPoints(...)");
        Object[] $this$forEach$iv = distributionPointArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DistributionPoint distributionPoint = (DistributionPoint)element$iv;
            boolean bl = false;
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName.getType() != 0) continue;
            GeneralName[] generalNames = GeneralNames.getInstance(distributionPointName.getName()).getNames();
            Intrinsics.checkNotNull(generalNames);
            GeneralName[] $this$forEach$iv2 = generalNames;
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                GeneralName element$iv2;
                GeneralName generalName = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                if (generalName.getTagNo() != 6) continue;
                String url = DERIA5String.getInstance(generalName.getName()).getString();
                crlUris.add(new URI(url));
            }
        }
        return crlUris;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final X509Certificate findRevokedCertificate(@NotNull List<? extends X509Certificate> certs, @NotNull List<? extends X509CRL> revocationLists) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(certs, "certs");
            Intrinsics.checkNotNullParameter(revocationLists, "revocationLists");
            if (revocationLists.size() != certs.size() - 1) {
                throw new IllegalArgumentException("Number of revocation lists should be one less than the number of certificates");
            }
            Iterable $this$zip$iv = CollectionsKt.zipWithNext((Iterable)certs);
            boolean $i$f$zip = false;
            Iterator first$iv = $this$zip$iv.iterator();
            Iterator second$iv = ((Iterable)revocationLists).iterator();
            ArrayList list$iv = new ArrayList(Math.min(CollectionsKt.collectionSizeOrDefault($this$zip$iv, 10), CollectionsKt.collectionSizeOrDefault((Iterable)revocationLists, 10)));
            while (first$iv.hasNext() && second$iv.hasNext()) {
                void revocationList;
                void certificates;
                X509CRL x509CRL = (X509CRL)second$iv.next();
                Pair pair = (Pair)first$iv.next();
                ArrayList arrayList = list$iv;
                boolean bl = false;
                arrayList.add(new Triple(certificates.getFirst(), certificates.getSecond(), revocationList));
            }
            Iterable iterable = CollectionsKt.reversed(list$iv);
            for (Object t : iterable) {
                X509CRL revocationList;
                X509Certificate certificateAuthority;
                Triple triple = (Triple)t;
                boolean bl = false;
                X509Certificate certificate = (X509Certificate)triple.component1();
                if (!INSTANCE.isCertificateRevoked(certificate, certificateAuthority = (X509Certificate)triple.component2(), revocationList = (X509CRL)triple.component3())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Triple triple = v0;
        return triple != null ? (X509Certificate)triple.getFirst() : null;
    }

    private final boolean isCertificateRevoked(X509Certificate certificate, X509Certificate certificateAuthority, X509CRL revocationList) {
        if (!this.isCrlValid(revocationList, certificateAuthority)) {
            throw new IllegalArgumentException("Invalid CRL provided");
        }
        return revocationList.getRevokedCertificate(certificate) != null;
    }

    private final boolean isCrlValid(X509CRL certificateRevocationList, X509Certificate certificateAuthority) {
        boolean bl;
        if (!Intrinsics.areEqual(certificateRevocationList.getIssuerDN(), certificateAuthority.getSubjectDN())) {
            return false;
        }
        try {
            certificateRevocationList.verify(certificateAuthority.getPublicKey());
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final boolean isSignedBy(Certificate $this$isSignedBy, Certificate other) {
        boolean bl;
        try {
            $this$isSignedBy.verify(other.getPublicKey());
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    static {
        Date date = Date.from(LocalDate.of(9999, 12, 31).atStartOfDay().toInstant(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue(date, "from(...)");
        farAwayDate = date;
    }
}

