/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.verifier;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.verifier.SignatureVerifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/zip/signer/verifier/DefaultSignatureVerifier;", "Lorg/jetbrains/zip/signer/verifier/SignatureVerifier;", "certificateChain", "", "Ljava/security/cert/X509Certificate;", "signatureAlgorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "(Ljava/util/List;Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;)V", "jcaSignatureAlgorithm", "", "publicKey", "Ljava/security/PublicKey;", "kotlin.jvm.PlatformType", "verify", "", "dataToVerify", "", "signature", "lib"})
public final class DefaultSignatureVerifier
implements SignatureVerifier {
    private final PublicKey publicKey;
    @NotNull
    private final String jcaSignatureAlgorithm;

    public DefaultSignatureVerifier(@NotNull List<? extends X509Certificate> certificateChain, @NotNull SignatureAlgorithm signatureAlgorithm) {
        Intrinsics.checkNotNullParameter(certificateChain, "certificateChain");
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, "signatureAlgorithm");
        this.publicKey = certificateChain.get(0).getPublicKey();
        this.jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithm();
    }

    @Override
    public void verify(@NotNull byte[] dataToVerify, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter(dataToVerify, "dataToVerify");
        Intrinsics.checkNotNullParameter(signature, "signature");
        try {
            Signature $this$verify_u24lambda_u240 = Signature.getInstance(this.jcaSignatureAlgorithm);
            boolean bl = false;
            $this$verify_u24lambda_u240.initVerify(this.publicKey);
            $this$verify_u24lambda_u240.update(dataToVerify);
            if (!$this$verify_u24lambda_u240.verify(signature)) {
                throw new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate");
            }
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
        catch (SignatureException e) {
            throw new SignatureException("Failed to verify " + this.jcaSignatureAlgorithm + " signature using public key from certificate", e);
        }
    }
}

