/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.digest;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.utils.ByteArrayExtensionsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/zip/signer/digest/ChunkDigester;", "", "digestAlgorithm", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "chunkCount", "", "(Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;I)V", "chunkPrefix", "", "digest", "", "getDigestAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "messageDigest", "Ljava/security/MessageDigest;", "kotlin.jvm.PlatformType", "position", "consume", "", "chunk", "Ljava/nio/ByteBuffer;", "getResult", "lib"})
@ExperimentalUnsignedTypes
public final class ChunkDigester {
    private final byte chunkPrefix;
    private final MessageDigest messageDigest;
    private final byte[] digest;
    private int position;
    @NotNull
    private final ContentDigestAlgorithm digestAlgorithm;
    private final int chunkCount;

    public final void consume(@NotNull ByteBuffer chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (this.position >= this.chunkCount) {
            String string = "Too many chunks provided";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        byte[] byArray = new byte[5];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        $this$apply[0] = this.chunkPrefix;
        int n = chunk.remaining();
        boolean bl4 = false;
        ByteArrayExtensionsKt.setUnsignedInt32LittleEndian-MFYke0I($this$apply, UInt.constructor-impl((int)n), 1);
        byte[] chunkPrefix = byArray;
        this.messageDigest.update(chunkPrefix);
        this.messageDigest.update(chunk);
        int bytesWritten = this.messageDigest.digest(this.digest, 5 + this.position * this.digestAlgorithm.getChunkDigestOutputSizeBytes(), this.digestAlgorithm.getChunkDigestOutputSizeBytes());
        bl = bytesWritten == this.digestAlgorithm.getChunkDigestOutputSizeBytes();
        bl2 = false;
        boolean bl5 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Digest algorithm output has an unexpected size";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ++this.position;
    }

    @NotNull
    public final byte[] getResult() {
        boolean bl = this.position == this.chunkCount;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Not all chunks were processed";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.digest;
    }

    @NotNull
    public final ContentDigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    /*
     * WARNING - void declaration
     */
    public ChunkDigester(@NotNull ContentDigestAlgorithm digestAlgorithm, int chunkCount) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)((Object)digestAlgorithm), (String)"digestAlgorithm");
        this.digestAlgorithm = digestAlgorithm;
        this.chunkCount = chunkCount;
        this.chunkPrefix = (byte)90;
        this.messageDigest = MessageDigest.getInstance(this.digestAlgorithm.getJcaMessageDigestAlgorithm());
        byte[] byArray = new byte[5 + this.chunkCount * this.digestAlgorithm.getChunkDigestOutputSizeBytes()];
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray2 = byArray;
        ChunkDigester chunkDigester = this;
        boolean bl3 = false;
        $this$apply[0] = this.chunkPrefix;
        int n = this.chunkCount;
        boolean bl4 = false;
        ByteArrayExtensionsKt.setUnsignedInt32LittleEndian-MFYke0I((byte[])$this$apply, UInt.constructor-impl((int)n), 1);
        Unit unit = Unit.INSTANCE;
        chunkDigester.digest = byArray;
    }
}

